/*
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <cabi/cabi_error.h>
#include "common.h"

int main (int argc, char **argv)
{
	int ret, c, index = 0;
	unsigned long cabiid = -1;
	struct cabi_uaccount ucabi, *ucabip;
	struct option *options;

	/* clear cabi_uaccount */
	memset(&ucabi, 0, sizeof(struct cabi_uaccount));
	ucabip = &ucabi;

	/* make option table */
	options = append_common_options(NULL, 0);
	options = append_cabiid_options(options, 1);
	options = append_ucabi_options(options, 1);

	c = 0;
	while( c != -1 ){
		c = getopt_long_only (argc, argv, "", options, &index);

		switch( c ){
		case -1:	// end of argument
			break;
		default:
			if ( !check_common(c, options, index) ){
				// accept argument : NOP
			} else if ( !check_cabiid(c, options, index, &cabiid) ){
				// accept argument : NOP
			} else if ( !check_ucabi(c, options, index, &ucabip) ){
				// accept argument : NOP
			} else {
				unknown_option(index, c, optarg);
			}
		}
	}

        /* reclear ucabi */
        memset(&ucabi, 0, sizeof(struct cabi_uaccount));

	cabi_information("account get. object_id [%lu(0x%lx)] ucabi[%p]\n", cabiid, cabiid, ucabip);
	ret = cabi_account_get(cabiid, ucabip);
	if ( ucabip == &ucabi ){
		dump_ucabi(&ucabi);
	}
	check_setarg_cabiid(0, "Usage: ctget --cabiid=x");
	cabi_result(ret, 1);

	return 0;
}


