#include <stdlib.h>
#include <stdio.h>
#include <sys/types.h>
#include <unistd.h>
#include <sched.h>
#include <string.h>
#include <fcntl.h>
#include <time.h>
#include <sys/time.h>
#include "common.h"

#define CHILDREN	0x03

void fork_child()
{
	int ret;

	if ( (ret = fork()) < 0 ) {
		program_fail("fork fail");
	}

	if (ret == 0) {
		/* child */
		while(1) {
			sleep(10);
		}
	} else {
		/* parent */
		cabi_information("ctfork:pid=<%d>\n", ret);
	}

	return;
}

int main ( int argc, char **argv)
{
	int c, index = 0;
	struct option *options;
	static struct option ctfork_options[] = {
		{"children", required_argument, 0, CHILDREN},	// Ҷο
		{0,0,0,0},
	};

	/* make option table */
	options = append_common_options(ctfork_options, 0);
	
	c = 0;
	while( c != -1 ){
		c = getopt_long_only (argc, argv, "", options, &index);

		switch( c ){

		case CHILDREN: {
			int i, num;

			num = parse_int("children", optarg);
			for ( i = 0; i < num; i++ ){
				fork_child();
			}
			break;
		}
		case -1:	// end of argument
			break;
		default:
			if ( !check_common(c, options, index) ){
				// accept argument : NOP
			} else {
				unknown_option(index, c, optarg);
			}
		}

	}

	cabi_information("ctfork:pgid=<%d>\n", getpgrp());
	cabi_export_int(ENV_CT_PGID, getpgrp());
	cabi_result(0, 1);
	
	return 0;
}
