#!/bin/sh
source cs00_common.sh

if [ $# == 0 ] ; then
	echo "usage: $0 <netperf server IP>"
	exit 1
fi

if [ ! -e /proc/cabi/cabi_status ] ; then
	echo "cabi disable"
	killall ctloop
	for (( i=0 ; i < 10 ; i=i+1 )) ; do
		ctloop &
	done
else
	echo "cabi enable"
fi

netperf -H $1 -l `expr 60 \* 5`
if [ $? != 0 ] ; then
	echo "ERROR netperf"
	echo " exec netserver on host"
	exit 1
fi
