#!/bin/sh
#source cs00_common.sh
PFX="${LOGDIR}/cs04"
TASK="--fifo=MAX"

function a_fork () {
    SUBTEST="A_fork"
    echo "[ TEST ] ${TEST} ${SUBTEST} START"
    LOGNAME="${PFX}_${TEST}_${SUBTEST}_${LOGNAMEBASE}"
    RESULT="${LOGNAME}.result"
    CSV="${LOGNAME}.csv"
    CSCOUNT=10000
    cstest ${TASK} --csv=${CSV} --count=${CSCOUNT} --fork > ${RESULT}
    if [ $? != 0 ] ; then
        echo "[ TEST ] ${TEST} fail"
        exit 1
    fi
    echo "output result ${RESULT}"
    echo "output csv ${CSV}"
    echo "[ TEST ] ${TEST} SUCCESS"
    echo ""
    echo ""
    sleep 3
}

function b_getpid () {
    SUBTEST="B_getpid"
    echo "[ TEST ] ${TEST} ${SUBTEST} START"
    LOGNAME="${PFX}_${TEST}_${SUBTEST}_${LOGNAMEBASE}"
    RESULT="${LOGNAME}.result"
    CSV="${LOGNAME}.csv"
    CSCOUNT=10000
    cstest ${TASK} --csv=${CSV} --count=${CSCOUNT} --getpid > ${RESULT}
    if [ $? != 0 ] ; then
        echo "[ TEST ] ${TEST} fail"
        exit 1
    fi
    echo "output result ${RESULT}"
    echo "output csv ${CSV}"
    echo "[ TEST ] ${TEST} SUCCESS"
    echo ""
    echo ""
    sleep 3
}

function c_busywait () {
    SUBTEST="C_busywait"
    echo "[ TEST ] ${TEST} ${SUBTEST} START"
    LOGNAME="${PFX}_${TEST}_${SUBTEST}_${LOGNAMEBASE}"
    RESULT="${LOGNAME}.result"
    CSV="${LOGNAME}.csv"
    BWCOUNT=10000
    LOOPCOUNT=20
    cstest ${TASK} --csv=${CSV} --count=${BWCOUNT} --loopcount=${LOOPCOUNT} --busywait > ${RESULT}
    if [ $? != 0 ] ; then
        echo "[ TEST ] ${TEST} fail"
        exit 1
    fi
    echo "output result ${RESULT}"
    echo "output csv ${CSV}"
    echo "[ TEST ] ${TEST} SUCCESS"
    echo ""
    echo ""
    sleep 3
}

function cs04_test () {
    a_fork
    b_getpid
    c_busywait
}
