#!/bin/sh
source cs00_common.sh
source cs04_common.sh

if [ ! -e /proc/cabi/cabi_status ] ; then
    echo "ERROR cabi disable!"
    exit 1
fi

eval `ctcreate --export --TERM_SIGNAL --sig=0 --cpu_time=1 --cpu_period=2`

PSCOUNT=100
COUNT=4
# make proccess
for (( i=1 ; i<=${COUNT} ; i=i+1 )) ; do
    NOWCOUNT=$( expr ${i} \* ${PSCOUNT} )
    exec_ctfork ${PSCOUNT}
    TMP=CT_PGID${NOWCOUNT}
    eval ${TMP}=${CT_PGID}
    echo "make process group ${i} pgid ${!TMP}"
done

# test
for (( i=0 ; i<=${COUNT} ; i=i+1 )) ; do
    NOWCOUNT=$( expr ${i} \* ${PSCOUNT} )
    if [ $NOWCOUNT == 0 ] ; then
        NOWCOUNT="000"
    fi

    TEST="2_B_PS${NOWCOUNT}"

    if [ ${i} != 0 ] ; then
        TMP=CT_PGID${NOWCOUNT}
        echo "bind pgid ${!TMP}"
        ctbindpgid --cabiid=${CT_CABI_ID} --pgid=${!TMP}
        if [ $? != 0 ] ; then
            echo "[ TEST ] ${TEST} fail"
            exit 1
        fi
    fi

    cs04_test
done

killall ctfork
sleep 1
ctdestroy `cabiid`
