#!/bin/sh
PATH=/home/ct/bin:${PATH}

if [ ! -e /proc/cabi/cabi_status ] ; then
	LOGNAMEBASE=$(date +%Y%m%d_%H%M%S)"_BEFORE"
else
	LOGNAMEBASE=$(date +%Y%m%d_%H%M%S)"_CABI"
        echo "cabi clean"
        for i in `cabips`; do
            ctunbind --pid=${i} &> /dev/null
        done
        ctdestroy `cabiid` &> /dev/null
fi

LOGDIR="./cslog"
if [ -f ${LOGDIR} ] ; then
	echo ${LOGDIR} is not directory
	exit 1
elif [ ! -d ${LOGDIR} ] ; then
	mkdir ${LOGDIR}
fi

echo "ps clean"
killall ctloop &> /dev/null
killall ctfork &> /dev/null

function exec_ctfork () {
    echo "fork count $1"
    export PS1=""
    sh --noediting -i <<EOF
ctfork --noverbose --export -child=$1 > /dev/shm/ctfork.pid
EOF
    sleep 1
    source /dev/shm/ctfork.pid
}
