/*
 * This is sample program for CABI system.
 * set accounting object.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <cabi/cabi_error.h>
#include "common.h"

int main (int argc, char **argv)
{
	int ret, c, index = 0;
	unsigned long cabiid = -1;
	struct cabi_uaccount ucabi;
	struct cabi_uaccount *ucabip = &ucabi;
	struct option *options;


	/* make option table */
	options = append_common_options(NULL, 0);
	options = append_cabiid_options(options, 1);
	options = append_ucabi_options(options, 1);

	c = 0;
	while( c != -1 ){
		c = getopt_long_only (argc, argv, "", options, &index);

		switch( c ){
		case -1:	// end of argument
			break;
		case OPT_CODE_CABI_ID:
			check_cabiid(c, options, index, &cabiid);
			/* clear cabi_uaccount */
			memset(&ucabi, 0, sizeof(struct cabi_uaccount));

			ret = cabi_account_get(cabiid, &ucabi);
			if ( ret != CABI_SUCCESS )
				cabi_result(ret, 1);
			dump_ucabi(&ucabi);
			break;

		default:
			if ( !check_common(c, options, index) ){
				break;
			}
			/* ˤޤǤˤcabiidåȤƤϤ */
			check_setarg_cabiid(1, "Usage: ctset --cabiid=x --other_options");
			if ( !check_ucabi(c, options, index, &ucabip) ){
				// accept argument : NOP
			} else {
				unknown_option(index, c, optarg);
			}
		}
	}

	dump_ucabi(&ucabi);
	ret = cabi_account_set(cabiid, ucabip);
	check_setarg_cabiid(0, "Usage: ctset --cabiid=x --other_options");
	cabi_result(ret, 1);

	cabi_information("account set. object_id [%lu(0x%lx)]\n", ucabi.cabi_id, ucabi.cabi_id);
	
	return 0;	
}


