/*
 * ctgetbindpid
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <cabi/cabi_error.h>
#include "common.h"

#define COUNT		0x01
#define COUNT_ADR	0x02
#define PIDLIST_ADR	0x03

#define CT_COUNT_MARK_L "<<<CTCOUNT"
#define CT_COUNT_MARK_R "CTCOUNT>>>"
#define CT_PID_MARK_L   "<<<CTPID"
#define CT_PID_MARK_R   "CTPID>>>"

int main (int argc, char **argv)
{
	int i, ret, c, index = 0;
	unsigned long cabiid = -1;
	struct option *options;
        static struct option ctgetbindpid_options[] = {
                {"count", required_argument, 0, COUNT},
                {"count_adr", required_argument, 0, COUNT_ADR},
                {"pidlist_adr", required_argument, 0, PIDLIST_ADR},
                {0,0,0,0},
        };
	unsigned int count=0;
	unsigned int *countp=NULL;
	int *pidlist=NULL;
	int setcount_adr=-1;
	int setpidlist_adr=-1;

	/* make option table */
	options = append_common_options(ctgetbindpid_options, 0);
	options = append_cabiid_options(options, 1);

	c = 0;
	while( c != -1 ){
		c = getopt_long_only (argc, argv, "", options, &index);

		switch( c ){
                case COUNT:
                        count = parse_int(options[index].name, optarg);
                        break;
                case COUNT_ADR:
                        setcount_adr = parse_int(options[index].name, optarg);
                        break;
                case PIDLIST_ADR:
                        setpidlist_adr = parse_int(options[index].name, optarg);
                        break;
		case -1:	// end of argument
			break;
		default:
			if ( !check_common(c, options, index) ){
				// accept argument : NOP
			} else if ( !check_cabiid(c, options, index, &cabiid) ){
				// accept argument : NOP
			} else {
				unknown_option(index, c, optarg);
			}
		}
	}

        /* --count_adr=0 */
        if (setcount_adr == -1) {
                countp = &count;
        } else {
                countp = (unsigned int *)setcount_adr;
        }

        if (count == 0) {
                cabi_information("get bind pid count. object_id [%lu(0x%lx)] count[%u] count_adr[%p] pidlist_adr[%p]\n", cabiid, cabiid, count, countp, pidlist);
                ret = cabi_get_bind_pid(cabiid, countp, pidlist);
                if ( ret != CABI_SUCCESS ) {
                        if (cabi_export()) {
                                cabi_result(ret, 1);
                        } else {
                                program_fail("get bind pid count");
                        }
                }
        }

        /* --pidlist_adr=0 */
        if (setpidlist_adr == -1) {
                pidlist = (int*)malloc(sizeof(int) * count);
                if (pidlist == NULL) {
                        program_fail("no mem");
                }
                memset(pidlist, 0, sizeof(int) * count);
        } else {
                pidlist = (int*)setpidlist_adr;
        }

        cabi_information("get bind pid. object_id [%lu(0x%lx)] count[%u] count_adr[%p] pidlist_adr[%p]\n", cabiid, cabiid, count, countp, pidlist);
	ret = cabi_get_bind_pid(cabiid, countp, pidlist);
	if (setcount_adr == -1 ){
                if (cabi_export()) {
                        cabi_information("%s%d%s\n",
                                         CT_COUNT_MARK_L, count, CT_COUNT_MARK_R);
                } else {
                        cabi_information("pid list count[%d]\n", count);
                }
        }
        if (setpidlist_adr == -1 ) {
		for (i=0; i<count; i++) {
                        if (cabi_export()) cabi_information("%s", CT_PID_MARK_L);
			cabi_information("%d", pidlist[i]);
                        if (cabi_export()) cabi_information("%s\n", CT_PID_MARK_R);
                        else cabi_information("\n");
		}
	}
	check_setarg_cabiid(0, "Usage: ctgetbindpid --cabiid=x");
	cabi_result(ret, 1);
	if (setpidlist_adr == -1) {
		free(pidlist);
	}

	return 0;
}


