/*
 * This is sample program for CABI system.
 * create accounting object.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <cabi/cabi_error.h>
#include "common.h"

int main (int argc, char **argv)
{
	int i, ret, c, index = 0;//, count = 0;
	struct option *options;


	/* make option table */
	options = append_common_options(NULL, 0);
	options = append_cabiid_options(options, 1);

	c = 0;
	while( c != -1 ){
		c = getopt_long_only (argc, argv, "", options, &index);

		switch( c ){
		case OPT_CODE_CABI_ID:
			{
				unsigned long id = parse_cabi_id(options[index].name, optarg);
				
				ret = cabi_account_destroy(id);
				if ( ret != CABI_SUCCESS ){
					cabi_result(ret, 1);
				}
				//		count++;
			}
			break;
		case -1:	// end of argument
			break;
		default:
			if ( !check_common(c, options, index) ){
				// accept argument : NOP
			} else {
				unknown_option(index, c, optarg);
			}
		}
	}


	for ( i = optind; i < argc; i++ ){
		unsigned long id = parse_cabi_id("cabiid", argv[i]);

		ret = cabi_account_destroy(id);
		if ( ret != CABI_SUCCESS ){
			cabi_result(ret, 1);
		}
//		count++;
	}

	/*
	 * ޤãϡ٤Ƥ뤿Υå
	 */
	cabi_result(0, 1);
	
	return 0;	
}


