#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <string.h>
#include "common.h"

#define CTPID_FILE		"/dev/shm/ctdd.pid"

#define INFILE		0x01
#define OUTFILE		0x02

int main ( int argc, char **argv)
{
	int c, index = 0;
	struct option *options;
	static struct option ctdd_options[] = {
		{"if", required_argument, 0, INFILE},
		{"of", required_argument, 0, OUTFILE},
		{0,0,0,0},
	};
	int infd=-1, outfd=-1;

	/* make option table */
	options = append_common_options(ctdd_options, 0);

	c = 0;
	while( c != -1 ){
		c = getopt_long_only (argc, argv, "", options, &index);
		check_common(c, options, index);
	}
	optind = 0;

	/* ƤPIDexportեؽ */
	cabi_file_export_int(CTPID_FILE, 1, ENV_CT_PID, getpid());

	c = 0;
	while( c != -1 ){
		c = getopt_long_only (argc, argv, "", options, &index);

		switch( c ){
		case INFILE:
			if (!strcmp("-", optarg)) {
				infd = 0;
			} else {
				infd = open(optarg, O_RDONLY);
				if (infd < 0) program_fail("open input file");
			}
			break;
		case OUTFILE:
			if (!strcmp("-", optarg)) {
				outfd = 0;
			} else {
				outfd = open(optarg, O_WRONLY);
				if (outfd < 0) program_fail("open write file");
			}
			break;
		case -1:	// end of argument
			break;
		default:
			if ( !check_common(c, options, index) ){
				// accept argument : NOP
			} else {
				unknown_option(index, c, optarg);
			}
		}
	}

	if (infd < 0 || outfd < 0) {
		close(infd);
		close(outfd);
		program_fail("nothing arg");
	} else {
		int ret, count;
		static char buf[32];

		cabi_result(0, 1);

		while ( (count = read(infd, buf, 32)) > 0 ) {
			ret = write(outfd, buf, count);
			if (ret < 0) program_fail("write");
		}
		close(outfd);
		close(infd);

		if (count < 0) program_fail("read");
	}

	return 0;
}
