/*
 * This is sample program for CABI system.
 * create accounting object.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <cabi/cabi_error.h>
#include "common.h"

#define ERR_MSG "Usage: ctcreatebind "

int main (int argc, char **argv)
{
	int ret, c, index = 0;
	struct cabi_uaccount ucabi, *ucabip;
	pid_t pid;
	struct option *options;

	/* clear cabi_uaccount */
	memset(&ucabi, 0, sizeof(struct cabi_uaccount));
	ucabip = &ucabi;

	/* make option table */
	options = append_common_options(NULL, 0);
	options = append_ucabi_options(options, 1);
	options = append_pid_options(options, 1);

	c = 0;
	while( c != -1 ){
		c = getopt_long_only (argc, argv, "", options, &index);

		switch( c ){
		case -1:	// end of argument
			break;
		default:
			if ( !check_common(c, options, index) ){
				// accept argument : NOP
			} else if ( !check_ucabi(c, options, index, &ucabip) ){
				// accept argument : NOP
			} else if ( !check_pid(c, options, index, &pid) ){
				// accept argument : NOP
			} else {
				unknown_option(index, c, optarg);
			}
		}
	}

	if ( ucabip == &ucabi ){
		dump_ucabi(&ucabi);
	}
	cabi_information("pid [%lu(0x%lx)]\n", pid, pid);
	ret = cabi_create_bind(ucabip, pid);
	cabi_information("object_id [%lu(0x%lx)]\n", ucabi.cabi_id, ucabi.cabi_id);
	if (ret != CABI_SUCCESS) {
		/* check necessary arguments */
		if ( ucabip == &ucabi ){
			check_setarg_ucabi_cpu_time  (0, ERR_MSG "--cpu_time=x");
			check_setarg_ucabi_cpu_period(0, ERR_MSG "--cpu_period=x");
			check_setarg_pid             (0, ERR_MSG "--pid=x");
		}
	}
	cabi_result(ret, 1);

	cabi_export_int(ENV_CT_CABI_ID, ucabi.cabi_id);

	cabi_information("account create and bind. object_id [%lu(0x%lx)]\n", ucabi.cabi_id, ucabi.cabi_id);

	return 0;	
}


