#!/bin/sh
source cs00_common.sh
PFX="${LOGDIR}/cs01"
TASK="--fifo=MAX"

if [ ! -e /proc/cabi/cabi_status ] ; then
    echo "ERROR cabi disable!"
    exit 1
fi

TEST="4_bindpgid"
echo "[ TEST ] ${TEST} START"

PSCOUNT=100
COUNT=5
for (( i=0 ; i<${COUNT} ; i=i+1  )) ; do
    # make proccess
    NOWCOUNT=$( expr ${i} \* ${PSCOUNT} )
    if [ $NOWCOUNT == 0 ] ; then
        NOWCOUNT="001"
    fi
    exec_ctfork ${NOWCOUNT}
    echo "make process group ${i} pgid ${CT_PGID}"

    # bind pgid test
    LOGNAME="${PFX}_${TEST}_PS${NOWCOUNT}_${LOGNAMEBASE}"
    RESULT="${LOGNAME}.result"
    CSV="${LOGNAME}.csv"
    echo "bind pgid count ${NOWCOUNT}"
    cstest ${TASK} --csv=${CSV} --count=10000 --TERM_SIGNAL --sig=0 --cpu_time=1 --cpu_period=2 --pgid=${CT_PGID} --bind_pgid > ${RESULT}
    if [ $? != 0 ] ; then
        echo "[ TEST ] ${TEST} fail"
        killall ctfork
        exit 1
    fi
    killall ctfork
    sleep 1
done

# print logfilename
for (( i=0 ; i<4 ; i=i+1  )) ; do
    NOWCOUNT=$( expr ${i} \* ${PSCOUNT} )
    if [ $NOWCOUNT == 0 ] ; then
        NOWCOUNT="001"
    fi
    LOGNAME="${PFX}_${TEST}_PS${NOWCOUNT}_${LOGNAMEBASE}"
    RESULT="${LOGNAME}.result"
    CSV="${LOGNAME}.csv"
    echo "output result ${result}"
    echo "output csv ${CSV}"
done
echo "[ TEST ] ${TEST} SUCCESS"
echo ""
echo ""

ctdestroy `cabiid`
