#ifndef __CT_COMMON_H__
#define __CT_COMMON_H__
#include <getopt.h>
#include <cabi/cabi.h>

/*
 * command line option code
 *
 * 0x00ff ʲΥɤϡƥץѤͽ󤵤Ƥޤ
 * common.h  OPT_CODE_xxx ϡ0x0100 ʾ
 * ͤѤƤ
 */

/* export */
#define OPT_CODE_EXPORT			0x0101
#define OPT_CODE_NOEXPORT		0x0102

/* verbose */
#define OPT_CODE_VERBOSE		0x0105
#define OPT_CODE_NOVERBOSE		0x0106

/* help */
#define OPT_CODE_HELP			0x0109

/* display control */
#define OPT_CODE_SIGTIME		0x0110
#define OPT_CODE_NOSIGTIME		0x0111


/* ucabi */
#define OPT_CODE_UCABI_CABI_ID		0x0201
#define OPT_CODE_UCABI_TERM_NONE	0x0211
#define OPT_CODE_UCABI_TERM_BLOCK	0x0212
#define OPT_CODE_UCABI_TERM_SIGNAL	0x0213
#define OPT_CODE_UCABI_TERM_UNKNOWN	0x0214
#define OPT_CODE_UCABI_TERM_ACT		0x0215
#define OPT_CODE_UCABI_PID		0x0221
#define OPT_CODE_UCABI_SIG		0x0222
#define OPT_CODE_UCABI_FLAG		0x0223
#define OPT_CODE_UCABI_BIND_NORMAL_PROC	0x0231
#define OPT_CODE_UCABI_BIND_IDLE_PROC	0x0232
#define OPT_CODE_UCABI_BIND_PROC_TYPE	0x0233
#define OPT_CODE_UCABI_CPU_TIME		0x0241
#define OPT_CODE_UCABI_CPU_TIME_X	0x0242
#define OPT_CODE_UCABI_CPU_PERIOD	0x0251
#define OPT_CODE_UCABI_CPU_PERIOD_X	0x0252
#define OPT_CODE_UCABI_ADRS		0x0262

/*  */
#define OPT_CODE_CABI_ID		0x0301
#define OPT_CODE_PID			0x0310
#define OPT_CODE_PGID			0x0320


/*
 * environment variable name
 */
#define ENV_CT_CABI_ID		"CT_CABI_ID"
#define ENV_CT_PID		"CT_PID"
#define ENV_CT_PGID		"CT_PGID"
#define ENV_CT_PREV_PGID	"CT_PREV_PGID"	/* system callȯpgid */
#define ENV_CT_POST_PGID	"CT_POST_PGID"	/* system callȯԸpgid */


/*
 * 
 */
#define RESULT_FORMAT	"RESULT=%s"
#define RESULT_OK	"RESULT=OK "
#define RESULT_NG	"RESULT=NG : "


void program_fail(char *fmt, ...);
void cabi_fail(char *fmt, ...);
void unknown_option(int index, int c, char *optarg);
void cabi_result(int code, int cr);
void cabi_information(char *fmt, ...);
void cabi_information_flush(void);
int cabi_verbose(void); /* check verbose */
int cabi_export(void);  /* check export  */
void cabi_export_int(const char *name, long long value);
void cabi_file_export_int(char *path, int flag, const char *name, long long value);


struct option *append_options(struct option *table, const struct option *custom, int free_flag);
struct option *append_common_options(struct option *table, int free_flag);
struct option *append_ucabi_options(struct option *table, int free_flag);
struct option *append_cabiid_options(struct option *table, int free_flag);
struct option *append_pid_options(struct option *table, int free_flag);
struct option *append_pgid_options(struct option *table, int free_flag);

unsigned long parse_cabi_id(const char *name, const char *arg);
int parse_int(const char *name, const char *arg);
int parse_pid_t(const char *name, const char *arg);
void parse_time(const char *name, struct timespec *timespec, const char *arg);
void parse_time_x(const char *name, struct timespec *timespec, const char *arg);
int parse_signal(const char *name, const char *arg);


/* check parameter */
int check_common(int c, const struct option *table, int index);
int check_ucabi(int c, const struct option *options, int index, struct cabi_uaccount **ucabi);
int check_cabiid(int c, const struct option *options, int index, unsigned long *cabiid);
int check_pid(int c, const struct option *options, int index, pid_t *pid);
int check_pgid(int c, const struct option *options, int index, pid_t *pgid);


void dump_ucabi(const struct cabi_uaccount *ucabi);

extern int exort_result;


/* check set argument */
typedef struct{
	int cabiid;
	int term_act;
	int pid;
	int sig;
	int flag;
	int bind_proc;
	int cpu_time;
	int cpu_period;
}setarg_ucabi_t;
extern int setarg_cabiid;
extern int setarg_pid;
extern int setarg_pgid;
extern setarg_ucabi_t setarg_ucabi;
/* set */
#define set_setarg_cabiid() {setarg_cabiid=1;}
#define set_setarg_pid() {setarg_pid=1;}
#define set_setarg_pgid() {setarg_pgid=1;}
#define set_setarg_ucabi_cabiid() {setarg_ucabi.cabiid=1;}
#define set_setarg_ucabi_term_act() {setarg_ucabi.term_act=1;}
#define set_setarg_ucabi_pid() {setarg_ucabi.pid=1;}
#define set_setarg_ucabi_sig() {setarg_ucabi.sig=1;}
#define set_setarg_ucabi_flag() {setarg_ucabi.flag=1;}
#define set_setarg_ucabi_bind_proc() {setarg_ucabi.bind_proc=1;}
#define set_setarg_ucabi_cpu_time() {setarg_ucabi.cpu_time=1;}
#define set_setarg_ucabi_cpu_period() {setarg_ucabi.cpu_period=1;}
/* check */
void check_setarg_cabiid(int end, char *str);
void check_setarg_pid(int end, char *str);
void check_setarg_pgid(int end, char *str);
void check_setarg_ucabi_cabiid(int end, char *str);
void check_setarg_ucabi_term_act(int end, char *str);
void check_setarg_ucabi_pid(int end, char *str);
void check_setarg_ucabi_sig(int end, char *str);
void check_setarg_ucabi_flag(int end, char *str);
void check_setarg_ucabi_bind_proc(int end, char *str);
void check_setarg_ucabi_cpu_time(int end, char *str);
void check_setarg_ucabi_cpu_period(int end, char *str);

/* signal */
/* default busy signal handler */
void cabi_busysighandler(int sig);
void cabi_busyendsighandler(int sig);
void cabi_nullsighandler(int sig);
extern int cabi_signal(int signum, void (*sighandler)(int));
extern int get_signal_code(const char *name);
extern const char* get_signal_name(int code, int nofail);

/* proc */
typedef struct procinfo {
        struct timeval tv;
        pid_t pid;
        char command[64];
        char state;
        pid_t ppid, pgrp;
        unsigned long utime, stime, cutime, starttime;
} procInfo_t;

extern int get_proc_info(pid_t pidno, struct procinfo *pi);
extern int get_cpu_time(struct procinfo *pi);
extern long long get_time_diff(struct procinfo *pi1, struct procinfo *pi2);
extern long long timeval_diff(struct timeval *t1, struct timeval *t2);

#endif /* __CT_COMMON_H__ */
