//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		JunitXml.cs
 * @brief		Junit XmlHelper t@C
 *
 * @author		t.sirayanagi
*/
//-----------------------------------------------------------------------
//======================================================================

//======================================================================
// using
using System;
using System.Xml;
using System.Collections.Generic;

namespace junit
{
    class JunitXmlDocument : XmlDocument
    {
        #region FailureResult
        public class FailureResult
        {
            string m_message;
            string m_file = null;
            int m_line;

            public string Message
            {
                get { return m_message; }
                set { m_message = value; }
            }
            public string File
            {
                get { return m_file; }
                set { m_file = value; }
            }
            public int Line
            {
                get { return m_line; }
                set { m_line = value; }
            }
        }
        #endregion

        public XmlNode AppendTestSuites(string name, int test_count, int failure_count, int disable_const, TimeSpan elapsed_time)
        {
            XmlNode node = CreateElement("testsuites");
            XmlAttribute attrTests = CreateAttribute("tests");
            XmlAttribute attrFailures = CreateAttribute("failures");
            XmlAttribute attrDisabled = CreateAttribute("disabled");
            XmlAttribute attrTime = CreateAttribute("time");
            XmlAttribute attrName = CreateAttribute("name");
            attrTests.Value = test_count.ToString();
            attrFailures.Value = failure_count.ToString();
            attrDisabled.Value = disable_const.ToString();
            attrTime.Value = elapsed_time.TotalSeconds.ToString();
            attrName.Value = name;
            node.Attributes.Append(attrTests);
            node.Attributes.Append(attrFailures);
            node.Attributes.Append(attrDisabled);
            node.Attributes.Append(attrTime);
            node.Attributes.Append(attrName);

            return AppendChild(node);
        }

        public XmlNode AppendTestSuite(string name, int test_count, int failure_count, int disable_const, TimeSpan elapsed_time)
        {
            XmlNode node = CreateElement("testsuite");
            XmlAttribute attrName = CreateAttribute("name");
            XmlAttribute attrTests = CreateAttribute("tests");
            XmlAttribute attrFailures = CreateAttribute("failures");
            XmlAttribute attrDisabled = CreateAttribute("disabled");
            XmlAttribute attrTime = CreateAttribute("time");
            XmlAttribute attrErrors = CreateAttribute("errors");
            attrName.Value = name;
            attrTests.Value = test_count.ToString();
            attrFailures.Value = failure_count.ToString();
            attrDisabled.Value = disable_const.ToString();
            attrTime.Value = elapsed_time.TotalSeconds.ToString();
            attrErrors.Value = "0";
            node.Attributes.Append(attrName);
            node.Attributes.Append(attrTests);
            node.Attributes.Append(attrFailures);
            node.Attributes.Append(attrDisabled);
            node.Attributes.Append(attrTime);
            node.Attributes.Append(attrErrors);

            XmlNode parent = SelectSingleNode("testsuites");
            if (parent == null) return null;
            return parent.AppendChild(node);
        }

        public XmlNode AppendTestCase(XmlNode testsuite, string name, bool is_run, TimeSpan elapsed_time, List<FailureResult> results)
        {
            if (testsuite == null) return null;
            XmlNode node = CreateElement("testcase");
            XmlAttribute attrName = CreateAttribute("name");
            XmlAttribute attrStatus = CreateAttribute("status");
            XmlAttribute attrClassName = CreateAttribute("classname");
            XmlAttribute attrTime = CreateAttribute("time");
            attrName.Value = name;
            attrStatus.Value = is_run ? "run" : "notrun";
            attrClassName.Value = testsuite.Attributes["name"].Value;
            attrTime.Value = elapsed_time.TotalSeconds.ToString();

            node.Attributes.Append(attrName);
            node.Attributes.Append(attrStatus);
            node.Attributes.Append(attrClassName);
            node.Attributes.Append(attrTime);

            if (results != null)
            {
                foreach (FailureResult r in results)
                {
                    XmlNode failure = CreateElement("failure");
                    XmlAttribute attrMessage = CreateAttribute("message");
                    XmlAttribute attrType = CreateAttribute("type");
                    string data = r.File + ":" + r.Line + "\n" + r.Message;
                    XmlCDataSection cdata = CreateCDataSection(data);

                    attrMessage.Value = r.Message;
                    attrType.Value = "";

                    failure.AppendChild(cdata);
                    failure.Attributes.Append(attrMessage);
                    failure.Attributes.Append(attrType);

                    node.AppendChild(failure);
                }
            }
            return testsuite.AppendChild(node);
        }
    }

}	// end of namespace crisp


#region UNITTEST
#if CRISP_UNITTEST

namespace crisp
{


}

#endif
#endregion

