// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/genomics/v1/annotations.proto

/*
Package genomics is a generated protocol buffer package.

It is generated from these files:
	google/genomics/v1/annotations.proto
	google/genomics/v1/cigar.proto
	google/genomics/v1/datasets.proto
	google/genomics/v1/operations.proto
	google/genomics/v1/position.proto
	google/genomics/v1/range.proto
	google/genomics/v1/readalignment.proto
	google/genomics/v1/readgroup.proto
	google/genomics/v1/readgroupset.proto
	google/genomics/v1/reads.proto
	google/genomics/v1/references.proto
	google/genomics/v1/variants.proto

It has these top-level messages:
	AnnotationSet
	Annotation
	VariantAnnotation
	Transcript
	ExternalId
	CreateAnnotationSetRequest
	GetAnnotationSetRequest
	UpdateAnnotationSetRequest
	DeleteAnnotationSetRequest
	SearchAnnotationSetsRequest
	SearchAnnotationSetsResponse
	CreateAnnotationRequest
	BatchCreateAnnotationsRequest
	BatchCreateAnnotationsResponse
	GetAnnotationRequest
	UpdateAnnotationRequest
	DeleteAnnotationRequest
	SearchAnnotationsRequest
	SearchAnnotationsResponse
	CigarUnit
	Dataset
	ListDatasetsRequest
	ListDatasetsResponse
	CreateDatasetRequest
	UpdateDatasetRequest
	DeleteDatasetRequest
	UndeleteDatasetRequest
	GetDatasetRequest
	OperationMetadata
	OperationEvent
	Position
	Range
	LinearAlignment
	Read
	ReadGroup
	ReadGroupSet
	SearchReadGroupSetsRequest
	SearchReadGroupSetsResponse
	ImportReadGroupSetsRequest
	ImportReadGroupSetsResponse
	ExportReadGroupSetRequest
	UpdateReadGroupSetRequest
	DeleteReadGroupSetRequest
	GetReadGroupSetRequest
	ListCoverageBucketsRequest
	CoverageBucket
	ListCoverageBucketsResponse
	SearchReadsRequest
	SearchReadsResponse
	StreamReadsRequest
	StreamReadsResponse
	Reference
	ReferenceSet
	SearchReferenceSetsRequest
	SearchReferenceSetsResponse
	GetReferenceSetRequest
	SearchReferencesRequest
	SearchReferencesResponse
	GetReferenceRequest
	ListBasesRequest
	ListBasesResponse
	VariantSetMetadata
	VariantSet
	Variant
	VariantCall
	CallSet
	ReferenceBound
	ImportVariantsRequest
	ImportVariantsResponse
	CreateVariantSetRequest
	ExportVariantSetRequest
	GetVariantSetRequest
	SearchVariantSetsRequest
	SearchVariantSetsResponse
	DeleteVariantSetRequest
	UpdateVariantSetRequest
	SearchVariantsRequest
	SearchVariantsResponse
	CreateVariantRequest
	UpdateVariantRequest
	DeleteVariantRequest
	GetVariantRequest
	MergeVariantsRequest
	SearchCallSetsRequest
	SearchCallSetsResponse
	CreateCallSetRequest
	UpdateCallSetRequest
	DeleteCallSetRequest
	GetCallSetRequest
	StreamVariantsRequest
	StreamVariantsResponse
*/
package genomics

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import google_protobuf1 "github.com/golang/protobuf/ptypes/empty"
import google_protobuf2 "google.golang.org/genproto/protobuf/field_mask"
import google_protobuf3 "github.com/golang/protobuf/ptypes/struct"
import google_protobuf4 "github.com/golang/protobuf/ptypes/wrappers"
import google_rpc "google.golang.org/genproto/googleapis/rpc/status"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// When an [Annotation][google.genomics.v1.Annotation] or
// [AnnotationSet][google.genomics.v1.AnnotationSet] is created, if `type` is
// not specified it will be set to `GENERIC`.
type AnnotationType int32

const (
	AnnotationType_ANNOTATION_TYPE_UNSPECIFIED AnnotationType = 0
	// A `GENERIC` annotation type should be used when no other annotation
	// type will suffice. This represents an untyped annotation of the reference
	// genome.
	AnnotationType_GENERIC AnnotationType = 1
	// A `VARIANT` annotation type.
	AnnotationType_VARIANT AnnotationType = 2
	// A `GENE` annotation type represents the existence of a gene at the
	// associated reference coordinates. The start coordinate is typically the
	// gene's transcription start site and the end is typically the end of the
	// gene's last exon.
	AnnotationType_GENE AnnotationType = 3
	// A `TRANSCRIPT` annotation type represents the assertion that a
	// particular region of the reference genome may be transcribed as RNA.
	AnnotationType_TRANSCRIPT AnnotationType = 4
)

var AnnotationType_name = map[int32]string{
	0: "ANNOTATION_TYPE_UNSPECIFIED",
	1: "GENERIC",
	2: "VARIANT",
	3: "GENE",
	4: "TRANSCRIPT",
}
var AnnotationType_value = map[string]int32{
	"ANNOTATION_TYPE_UNSPECIFIED": 0,
	"GENERIC":                     1,
	"VARIANT":                     2,
	"GENE":                        3,
	"TRANSCRIPT":                  4,
}

func (x AnnotationType) String() string {
	return proto.EnumName(AnnotationType_name, int32(x))
}
func (AnnotationType) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

type VariantAnnotation_Type int32

const (
	VariantAnnotation_TYPE_UNSPECIFIED VariantAnnotation_Type = 0
	// `TYPE_OTHER` should be used when no other Type will suffice.
	// Further explanation of the variant type may be included in the
	// [info][google.genomics.v1.Annotation.info] field.
	VariantAnnotation_TYPE_OTHER VariantAnnotation_Type = 1
	// `INSERTION` indicates an insertion.
	VariantAnnotation_INSERTION VariantAnnotation_Type = 2
	// `DELETION` indicates a deletion.
	VariantAnnotation_DELETION VariantAnnotation_Type = 3
	// `SUBSTITUTION` indicates a block substitution of
	// two or more nucleotides.
	VariantAnnotation_SUBSTITUTION VariantAnnotation_Type = 4
	// `SNP` indicates a single nucleotide polymorphism.
	VariantAnnotation_SNP VariantAnnotation_Type = 5
	// `STRUCTURAL` indicates a large structural variant,
	// including chromosomal fusions, inversions, etc.
	VariantAnnotation_STRUCTURAL VariantAnnotation_Type = 6
	// `CNV` indicates a variation in copy number.
	VariantAnnotation_CNV VariantAnnotation_Type = 7
)

var VariantAnnotation_Type_name = map[int32]string{
	0: "TYPE_UNSPECIFIED",
	1: "TYPE_OTHER",
	2: "INSERTION",
	3: "DELETION",
	4: "SUBSTITUTION",
	5: "SNP",
	6: "STRUCTURAL",
	7: "CNV",
}
var VariantAnnotation_Type_value = map[string]int32{
	"TYPE_UNSPECIFIED": 0,
	"TYPE_OTHER":       1,
	"INSERTION":        2,
	"DELETION":         3,
	"SUBSTITUTION":     4,
	"SNP":              5,
	"STRUCTURAL":       6,
	"CNV":              7,
}

func (x VariantAnnotation_Type) String() string {
	return proto.EnumName(VariantAnnotation_Type_name, int32(x))
}
func (VariantAnnotation_Type) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{2, 0} }

type VariantAnnotation_Effect int32

const (
	VariantAnnotation_EFFECT_UNSPECIFIED VariantAnnotation_Effect = 0
	// `EFFECT_OTHER` should be used when no other Effect
	// will suffice.
	VariantAnnotation_EFFECT_OTHER VariantAnnotation_Effect = 1
	// `FRAMESHIFT` indicates a mutation in which the insertion or
	// deletion of nucleotides resulted in a frameshift change.
	VariantAnnotation_FRAMESHIFT VariantAnnotation_Effect = 2
	// `FRAME_PRESERVING_INDEL` indicates a mutation in which a
	// multiple of three nucleotides has been inserted or deleted, resulting
	// in no change to the reading frame of the coding sequence.
	VariantAnnotation_FRAME_PRESERVING_INDEL VariantAnnotation_Effect = 3
	// `SYNONYMOUS_SNP` indicates a single nucleotide polymorphism
	// mutation that results in no amino acid change.
	VariantAnnotation_SYNONYMOUS_SNP VariantAnnotation_Effect = 4
	// `NONSYNONYMOUS_SNP` indicates a single nucleotide
	// polymorphism mutation that results in an amino acid change.
	VariantAnnotation_NONSYNONYMOUS_SNP VariantAnnotation_Effect = 5
	// `STOP_GAIN` indicates a mutation that leads to the creation
	// of a stop codon at the variant site. Frameshift mutations creating
	// downstream stop codons do not count as `STOP_GAIN`.
	VariantAnnotation_STOP_GAIN VariantAnnotation_Effect = 6
	// `STOP_LOSS` indicates a mutation that eliminates a
	// stop codon at the variant site.
	VariantAnnotation_STOP_LOSS VariantAnnotation_Effect = 7
	// `SPLICE_SITE_DISRUPTION` indicates that this variant is
	// found in a splice site for the associated transcript, and alters the
	// normal splicing pattern.
	VariantAnnotation_SPLICE_SITE_DISRUPTION VariantAnnotation_Effect = 8
)

var VariantAnnotation_Effect_name = map[int32]string{
	0: "EFFECT_UNSPECIFIED",
	1: "EFFECT_OTHER",
	2: "FRAMESHIFT",
	3: "FRAME_PRESERVING_INDEL",
	4: "SYNONYMOUS_SNP",
	5: "NONSYNONYMOUS_SNP",
	6: "STOP_GAIN",
	7: "STOP_LOSS",
	8: "SPLICE_SITE_DISRUPTION",
}
var VariantAnnotation_Effect_value = map[string]int32{
	"EFFECT_UNSPECIFIED":     0,
	"EFFECT_OTHER":           1,
	"FRAMESHIFT":             2,
	"FRAME_PRESERVING_INDEL": 3,
	"SYNONYMOUS_SNP":         4,
	"NONSYNONYMOUS_SNP":      5,
	"STOP_GAIN":              6,
	"STOP_LOSS":              7,
	"SPLICE_SITE_DISRUPTION": 8,
}

func (x VariantAnnotation_Effect) String() string {
	return proto.EnumName(VariantAnnotation_Effect_name, int32(x))
}
func (VariantAnnotation_Effect) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{2, 1} }

type VariantAnnotation_ClinicalSignificance int32

const (
	VariantAnnotation_CLINICAL_SIGNIFICANCE_UNSPECIFIED VariantAnnotation_ClinicalSignificance = 0
	// `OTHER` should be used when no other clinical significance
	// value will suffice.
	VariantAnnotation_CLINICAL_SIGNIFICANCE_OTHER VariantAnnotation_ClinicalSignificance = 1
	VariantAnnotation_UNCERTAIN                   VariantAnnotation_ClinicalSignificance = 2
	VariantAnnotation_BENIGN                      VariantAnnotation_ClinicalSignificance = 3
	VariantAnnotation_LIKELY_BENIGN               VariantAnnotation_ClinicalSignificance = 4
	VariantAnnotation_LIKELY_PATHOGENIC           VariantAnnotation_ClinicalSignificance = 5
	VariantAnnotation_PATHOGENIC                  VariantAnnotation_ClinicalSignificance = 6
	VariantAnnotation_DRUG_RESPONSE               VariantAnnotation_ClinicalSignificance = 7
	VariantAnnotation_HISTOCOMPATIBILITY          VariantAnnotation_ClinicalSignificance = 8
	VariantAnnotation_CONFERS_SENSITIVITY         VariantAnnotation_ClinicalSignificance = 9
	VariantAnnotation_RISK_FACTOR                 VariantAnnotation_ClinicalSignificance = 10
	VariantAnnotation_ASSOCIATION                 VariantAnnotation_ClinicalSignificance = 11
	VariantAnnotation_PROTECTIVE                  VariantAnnotation_ClinicalSignificance = 12
	// `MULTIPLE_REPORTED` should be used when multiple clinical
	// signficances are reported for a variant. The original clinical
	// significance values may be provided in the `info` field.
	VariantAnnotation_MULTIPLE_REPORTED VariantAnnotation_ClinicalSignificance = 13
)

var VariantAnnotation_ClinicalSignificance_name = map[int32]string{
	0:  "CLINICAL_SIGNIFICANCE_UNSPECIFIED",
	1:  "CLINICAL_SIGNIFICANCE_OTHER",
	2:  "UNCERTAIN",
	3:  "BENIGN",
	4:  "LIKELY_BENIGN",
	5:  "LIKELY_PATHOGENIC",
	6:  "PATHOGENIC",
	7:  "DRUG_RESPONSE",
	8:  "HISTOCOMPATIBILITY",
	9:  "CONFERS_SENSITIVITY",
	10: "RISK_FACTOR",
	11: "ASSOCIATION",
	12: "PROTECTIVE",
	13: "MULTIPLE_REPORTED",
}
var VariantAnnotation_ClinicalSignificance_value = map[string]int32{
	"CLINICAL_SIGNIFICANCE_UNSPECIFIED": 0,
	"CLINICAL_SIGNIFICANCE_OTHER":       1,
	"UNCERTAIN":                         2,
	"BENIGN":                            3,
	"LIKELY_BENIGN":                     4,
	"LIKELY_PATHOGENIC":                 5,
	"PATHOGENIC":                        6,
	"DRUG_RESPONSE":                     7,
	"HISTOCOMPATIBILITY":                8,
	"CONFERS_SENSITIVITY":               9,
	"RISK_FACTOR":                       10,
	"ASSOCIATION":                       11,
	"PROTECTIVE":                        12,
	"MULTIPLE_REPORTED":                 13,
}

func (x VariantAnnotation_ClinicalSignificance) String() string {
	return proto.EnumName(VariantAnnotation_ClinicalSignificance_name, int32(x))
}
func (VariantAnnotation_ClinicalSignificance) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor0, []int{2, 2}
}

// An annotation set is a logical grouping of annotations that share consistent
// type information and provenance. Examples of annotation sets include 'all
// genes from refseq', and 'all variant annotations from ClinVar'.
type AnnotationSet struct {
	// The server-generated annotation set ID, unique across all annotation sets.
	Id string `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	// The dataset to which this annotation set belongs.
	DatasetId string `protobuf:"bytes,2,opt,name=dataset_id,json=datasetId" json:"dataset_id,omitempty"`
	// The ID of the reference set that defines the coordinate space for this
	// set's annotations.
	ReferenceSetId string `protobuf:"bytes,3,opt,name=reference_set_id,json=referenceSetId" json:"reference_set_id,omitempty"`
	// The display name for this annotation set.
	Name string `protobuf:"bytes,4,opt,name=name" json:"name,omitempty"`
	// The source URI describing the file from which this annotation set was
	// generated, if any.
	SourceUri string `protobuf:"bytes,5,opt,name=source_uri,json=sourceUri" json:"source_uri,omitempty"`
	// The type of annotations contained within this set.
	Type AnnotationType `protobuf:"varint,6,opt,name=type,enum=google.genomics.v1.AnnotationType" json:"type,omitempty"`
	// A map of additional read alignment information. This must be of the form
	// map<string, string[]> (string key mapping to a list of string values).
	Info map[string]*google_protobuf3.ListValue `protobuf:"bytes,17,rep,name=info" json:"info,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *AnnotationSet) Reset()                    { *m = AnnotationSet{} }
func (m *AnnotationSet) String() string            { return proto.CompactTextString(m) }
func (*AnnotationSet) ProtoMessage()               {}
func (*AnnotationSet) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *AnnotationSet) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *AnnotationSet) GetDatasetId() string {
	if m != nil {
		return m.DatasetId
	}
	return ""
}

func (m *AnnotationSet) GetReferenceSetId() string {
	if m != nil {
		return m.ReferenceSetId
	}
	return ""
}

func (m *AnnotationSet) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *AnnotationSet) GetSourceUri() string {
	if m != nil {
		return m.SourceUri
	}
	return ""
}

func (m *AnnotationSet) GetType() AnnotationType {
	if m != nil {
		return m.Type
	}
	return AnnotationType_ANNOTATION_TYPE_UNSPECIFIED
}

func (m *AnnotationSet) GetInfo() map[string]*google_protobuf3.ListValue {
	if m != nil {
		return m.Info
	}
	return nil
}

// An annotation describes a region of reference genome. The value of an
// annotation may be one of several canonical types, supplemented by arbitrary
// info tags. An annotation is not inherently associated with a specific
// sample or individual (though a client could choose to use annotations in
// this way). Example canonical annotation types are `GENE` and
// `VARIANT`.
type Annotation struct {
	// The server-generated annotation ID, unique across all annotations.
	Id string `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	// The annotation set to which this annotation belongs.
	AnnotationSetId string `protobuf:"bytes,2,opt,name=annotation_set_id,json=annotationSetId" json:"annotation_set_id,omitempty"`
	// The display name of this annotation.
	Name string `protobuf:"bytes,3,opt,name=name" json:"name,omitempty"`
	// The ID of the Google Genomics reference associated with this range.
	ReferenceId string `protobuf:"bytes,4,opt,name=reference_id,json=referenceId" json:"reference_id,omitempty"`
	// The display name corresponding to the reference specified by
	// `referenceId`, for example `chr1`, `1`, or `chrX`.
	ReferenceName string `protobuf:"bytes,5,opt,name=reference_name,json=referenceName" json:"reference_name,omitempty"`
	// The start position of the range on the reference, 0-based inclusive.
	Start int64 `protobuf:"varint,6,opt,name=start" json:"start,omitempty"`
	// The end position of the range on the reference, 0-based exclusive.
	End int64 `protobuf:"varint,7,opt,name=end" json:"end,omitempty"`
	// Whether this range refers to the reverse strand, as opposed to the forward
	// strand. Note that regardless of this field, the start/end position of the
	// range always refer to the forward strand.
	ReverseStrand bool `protobuf:"varint,8,opt,name=reverse_strand,json=reverseStrand" json:"reverse_strand,omitempty"`
	// The data type for this annotation. Must match the containing annotation
	// set's type.
	Type AnnotationType `protobuf:"varint,9,opt,name=type,enum=google.genomics.v1.AnnotationType" json:"type,omitempty"`
	// Types that are valid to be assigned to Value:
	//	*Annotation_Variant
	//	*Annotation_Transcript
	Value isAnnotation_Value `protobuf_oneof:"value"`
	// A map of additional read alignment information. This must be of the form
	// map<string, string[]> (string key mapping to a list of string values).
	Info map[string]*google_protobuf3.ListValue `protobuf:"bytes,12,rep,name=info" json:"info,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *Annotation) Reset()                    { *m = Annotation{} }
func (m *Annotation) String() string            { return proto.CompactTextString(m) }
func (*Annotation) ProtoMessage()               {}
func (*Annotation) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

type isAnnotation_Value interface {
	isAnnotation_Value()
}

type Annotation_Variant struct {
	Variant *VariantAnnotation `protobuf:"bytes,10,opt,name=variant,oneof"`
}
type Annotation_Transcript struct {
	Transcript *Transcript `protobuf:"bytes,11,opt,name=transcript,oneof"`
}

func (*Annotation_Variant) isAnnotation_Value()    {}
func (*Annotation_Transcript) isAnnotation_Value() {}

func (m *Annotation) GetValue() isAnnotation_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *Annotation) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Annotation) GetAnnotationSetId() string {
	if m != nil {
		return m.AnnotationSetId
	}
	return ""
}

func (m *Annotation) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Annotation) GetReferenceId() string {
	if m != nil {
		return m.ReferenceId
	}
	return ""
}

func (m *Annotation) GetReferenceName() string {
	if m != nil {
		return m.ReferenceName
	}
	return ""
}

func (m *Annotation) GetStart() int64 {
	if m != nil {
		return m.Start
	}
	return 0
}

func (m *Annotation) GetEnd() int64 {
	if m != nil {
		return m.End
	}
	return 0
}

func (m *Annotation) GetReverseStrand() bool {
	if m != nil {
		return m.ReverseStrand
	}
	return false
}

func (m *Annotation) GetType() AnnotationType {
	if m != nil {
		return m.Type
	}
	return AnnotationType_ANNOTATION_TYPE_UNSPECIFIED
}

func (m *Annotation) GetVariant() *VariantAnnotation {
	if x, ok := m.GetValue().(*Annotation_Variant); ok {
		return x.Variant
	}
	return nil
}

func (m *Annotation) GetTranscript() *Transcript {
	if x, ok := m.GetValue().(*Annotation_Transcript); ok {
		return x.Transcript
	}
	return nil
}

func (m *Annotation) GetInfo() map[string]*google_protobuf3.ListValue {
	if m != nil {
		return m.Info
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Annotation) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Annotation_OneofMarshaler, _Annotation_OneofUnmarshaler, _Annotation_OneofSizer, []interface{}{
		(*Annotation_Variant)(nil),
		(*Annotation_Transcript)(nil),
	}
}

func _Annotation_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Annotation)
	// value
	switch x := m.Value.(type) {
	case *Annotation_Variant:
		b.EncodeVarint(10<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Variant); err != nil {
			return err
		}
	case *Annotation_Transcript:
		b.EncodeVarint(11<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Transcript); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Annotation.Value has unexpected type %T", x)
	}
	return nil
}

func _Annotation_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Annotation)
	switch tag {
	case 10: // value.variant
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(VariantAnnotation)
		err := b.DecodeMessage(msg)
		m.Value = &Annotation_Variant{msg}
		return true, err
	case 11: // value.transcript
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Transcript)
		err := b.DecodeMessage(msg)
		m.Value = &Annotation_Transcript{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Annotation_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Annotation)
	// value
	switch x := m.Value.(type) {
	case *Annotation_Variant:
		s := proto.Size(x.Variant)
		n += proto.SizeVarint(10<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Annotation_Transcript:
		s := proto.Size(x.Transcript)
		n += proto.SizeVarint(11<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type VariantAnnotation struct {
	// Type has been adapted from ClinVar's list of variant types.
	Type VariantAnnotation_Type `protobuf:"varint,1,opt,name=type,enum=google.genomics.v1.VariantAnnotation_Type" json:"type,omitempty"`
	// Effect of the variant on the coding sequence.
	Effect VariantAnnotation_Effect `protobuf:"varint,2,opt,name=effect,enum=google.genomics.v1.VariantAnnotation_Effect" json:"effect,omitempty"`
	// The alternate allele for this variant. If multiple alternate alleles
	// exist at this location, create a separate variant for each one, as they
	// may represent distinct conditions.
	AlternateBases string `protobuf:"bytes,3,opt,name=alternate_bases,json=alternateBases" json:"alternate_bases,omitempty"`
	// Google annotation ID of the gene affected by this variant. This should
	// be provided when the variant is created.
	GeneId string `protobuf:"bytes,4,opt,name=gene_id,json=geneId" json:"gene_id,omitempty"`
	// Google annotation IDs of the transcripts affected by this variant. These
	// should be provided when the variant is created.
	TranscriptIds []string `protobuf:"bytes,5,rep,name=transcript_ids,json=transcriptIds" json:"transcript_ids,omitempty"`
	// The set of conditions associated with this variant.
	// A condition describes the way a variant influences human health.
	Conditions []*VariantAnnotation_ClinicalCondition `protobuf:"bytes,6,rep,name=conditions" json:"conditions,omitempty"`
	// Describes the clinical significance of a variant.
	// It is adapted from the ClinVar controlled vocabulary for clinical
	// significance described at:
	// http://www.ncbi.nlm.nih.gov/clinvar/docs/clinsig/
	ClinicalSignificance VariantAnnotation_ClinicalSignificance `protobuf:"varint,7,opt,name=clinical_significance,json=clinicalSignificance,enum=google.genomics.v1.VariantAnnotation_ClinicalSignificance" json:"clinical_significance,omitempty"`
}

func (m *VariantAnnotation) Reset()                    { *m = VariantAnnotation{} }
func (m *VariantAnnotation) String() string            { return proto.CompactTextString(m) }
func (*VariantAnnotation) ProtoMessage()               {}
func (*VariantAnnotation) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *VariantAnnotation) GetType() VariantAnnotation_Type {
	if m != nil {
		return m.Type
	}
	return VariantAnnotation_TYPE_UNSPECIFIED
}

func (m *VariantAnnotation) GetEffect() VariantAnnotation_Effect {
	if m != nil {
		return m.Effect
	}
	return VariantAnnotation_EFFECT_UNSPECIFIED
}

func (m *VariantAnnotation) GetAlternateBases() string {
	if m != nil {
		return m.AlternateBases
	}
	return ""
}

func (m *VariantAnnotation) GetGeneId() string {
	if m != nil {
		return m.GeneId
	}
	return ""
}

func (m *VariantAnnotation) GetTranscriptIds() []string {
	if m != nil {
		return m.TranscriptIds
	}
	return nil
}

func (m *VariantAnnotation) GetConditions() []*VariantAnnotation_ClinicalCondition {
	if m != nil {
		return m.Conditions
	}
	return nil
}

func (m *VariantAnnotation) GetClinicalSignificance() VariantAnnotation_ClinicalSignificance {
	if m != nil {
		return m.ClinicalSignificance
	}
	return VariantAnnotation_CLINICAL_SIGNIFICANCE_UNSPECIFIED
}

type VariantAnnotation_ClinicalCondition struct {
	// A set of names for the condition.
	Names []string `protobuf:"bytes,1,rep,name=names" json:"names,omitempty"`
	// The set of external IDs for this condition.
	ExternalIds []*ExternalId `protobuf:"bytes,2,rep,name=external_ids,json=externalIds" json:"external_ids,omitempty"`
	// The MedGen concept id associated with this gene.
	// Search for these IDs at http://www.ncbi.nlm.nih.gov/medgen/
	ConceptId string `protobuf:"bytes,3,opt,name=concept_id,json=conceptId" json:"concept_id,omitempty"`
	// The OMIM id for this condition.
	// Search for these IDs at http://omim.org/
	OmimId string `protobuf:"bytes,4,opt,name=omim_id,json=omimId" json:"omim_id,omitempty"`
}

func (m *VariantAnnotation_ClinicalCondition) Reset()         { *m = VariantAnnotation_ClinicalCondition{} }
func (m *VariantAnnotation_ClinicalCondition) String() string { return proto.CompactTextString(m) }
func (*VariantAnnotation_ClinicalCondition) ProtoMessage()    {}
func (*VariantAnnotation_ClinicalCondition) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{2, 0}
}

func (m *VariantAnnotation_ClinicalCondition) GetNames() []string {
	if m != nil {
		return m.Names
	}
	return nil
}

func (m *VariantAnnotation_ClinicalCondition) GetExternalIds() []*ExternalId {
	if m != nil {
		return m.ExternalIds
	}
	return nil
}

func (m *VariantAnnotation_ClinicalCondition) GetConceptId() string {
	if m != nil {
		return m.ConceptId
	}
	return ""
}

func (m *VariantAnnotation_ClinicalCondition) GetOmimId() string {
	if m != nil {
		return m.OmimId
	}
	return ""
}

// A transcript represents the assertion that a particular region of the
// reference genome may be transcribed as RNA.
type Transcript struct {
	// The annotation ID of the gene from which this transcript is transcribed.
	GeneId string `protobuf:"bytes,1,opt,name=gene_id,json=geneId" json:"gene_id,omitempty"`
	// The <a href="http://en.wikipedia.org/wiki/Exon">exons</a> that compose
	// this transcript. This field should be unset for genomes where transcript
	// splicing does not occur, for example prokaryotes.
	//
	// Introns are regions of the transcript that are not included in the
	// spliced RNA product. Though not explicitly modeled here, intron ranges can
	// be deduced; all regions of this transcript that are not exons are introns.
	//
	// Exonic sequences do not necessarily code for a translational product
	// (amino acids). Only the regions of exons bounded by the
	// [codingSequence][google.genomics.v1.Transcript.coding_sequence] correspond
	// to coding DNA sequence.
	//
	// Exons are ordered by start position and may not overlap.
	Exons []*Transcript_Exon `protobuf:"bytes,2,rep,name=exons" json:"exons,omitempty"`
	// The range of the coding sequence for this transcript, if any. To determine
	// the exact ranges of coding sequence, intersect this range with those of the
	// [exons][google.genomics.v1.Transcript.exons], if any. If there are any
	// [exons][google.genomics.v1.Transcript.exons], the
	// [codingSequence][google.genomics.v1.Transcript.coding_sequence] must start
	// and end within them.
	//
	// Note that in some cases, the reference genome will not exactly match the
	// observed mRNA transcript e.g. due to variance in the source genome from
	// reference. In these cases,
	// [exon.frame][google.genomics.v1.Transcript.Exon.frame] will not necessarily
	// match the expected reference reading frame and coding exon reference bases
	// cannot necessarily be concatenated to produce the original transcript mRNA.
	CodingSequence *Transcript_CodingSequence `protobuf:"bytes,3,opt,name=coding_sequence,json=codingSequence" json:"coding_sequence,omitempty"`
}

func (m *Transcript) Reset()                    { *m = Transcript{} }
func (m *Transcript) String() string            { return proto.CompactTextString(m) }
func (*Transcript) ProtoMessage()               {}
func (*Transcript) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *Transcript) GetGeneId() string {
	if m != nil {
		return m.GeneId
	}
	return ""
}

func (m *Transcript) GetExons() []*Transcript_Exon {
	if m != nil {
		return m.Exons
	}
	return nil
}

func (m *Transcript) GetCodingSequence() *Transcript_CodingSequence {
	if m != nil {
		return m.CodingSequence
	}
	return nil
}

type Transcript_Exon struct {
	// The start position of the exon on this annotation's reference sequence,
	// 0-based inclusive. Note that this is relative to the reference start, and
	// **not** the containing annotation start.
	Start int64 `protobuf:"varint,1,opt,name=start" json:"start,omitempty"`
	// The end position of the exon on this annotation's reference sequence,
	// 0-based exclusive. Note that this is relative to the reference start, and
	// *not* the containing annotation start.
	End int64 `protobuf:"varint,2,opt,name=end" json:"end,omitempty"`
	// The frame of this exon. Contains a value of 0, 1, or 2, which indicates
	// the offset of the first coding base of the exon within the reading frame
	// of the coding DNA sequence, if any. This field is dependent on the
	// strandedness of this annotation (see
	// [Annotation.reverse_strand][google.genomics.v1.Annotation.reverse_strand]).
	// For forward stranded annotations, this offset is relative to the
	// [exon.start][google.genomics.v1.Transcript.Exon.start]. For reverse
	// strand annotations, this offset is relative to the
	// [exon.end][google.genomics.v1.Transcript.Exon.end] `- 1`.
	//
	// Unset if this exon does not intersect the coding sequence. Upon creation
	// of a transcript, the frame must be populated for all or none of the
	// coding exons.
	Frame *google_protobuf4.Int32Value `protobuf:"bytes,3,opt,name=frame" json:"frame,omitempty"`
}

func (m *Transcript_Exon) Reset()                    { *m = Transcript_Exon{} }
func (m *Transcript_Exon) String() string            { return proto.CompactTextString(m) }
func (*Transcript_Exon) ProtoMessage()               {}
func (*Transcript_Exon) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3, 0} }

func (m *Transcript_Exon) GetStart() int64 {
	if m != nil {
		return m.Start
	}
	return 0
}

func (m *Transcript_Exon) GetEnd() int64 {
	if m != nil {
		return m.End
	}
	return 0
}

func (m *Transcript_Exon) GetFrame() *google_protobuf4.Int32Value {
	if m != nil {
		return m.Frame
	}
	return nil
}

type Transcript_CodingSequence struct {
	// The start of the coding sequence on this annotation's reference sequence,
	// 0-based inclusive. Note that this position is relative to the reference
	// start, and *not* the containing annotation start.
	Start int64 `protobuf:"varint,1,opt,name=start" json:"start,omitempty"`
	// The end of the coding sequence on this annotation's reference sequence,
	// 0-based exclusive. Note that this position is relative to the reference
	// start, and *not* the containing annotation start.
	End int64 `protobuf:"varint,2,opt,name=end" json:"end,omitempty"`
}

func (m *Transcript_CodingSequence) Reset()                    { *m = Transcript_CodingSequence{} }
func (m *Transcript_CodingSequence) String() string            { return proto.CompactTextString(m) }
func (*Transcript_CodingSequence) ProtoMessage()               {}
func (*Transcript_CodingSequence) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3, 1} }

func (m *Transcript_CodingSequence) GetStart() int64 {
	if m != nil {
		return m.Start
	}
	return 0
}

func (m *Transcript_CodingSequence) GetEnd() int64 {
	if m != nil {
		return m.End
	}
	return 0
}

type ExternalId struct {
	// The name of the source of this data.
	SourceName string `protobuf:"bytes,1,opt,name=source_name,json=sourceName" json:"source_name,omitempty"`
	// The id used by the source of this data.
	Id string `protobuf:"bytes,2,opt,name=id" json:"id,omitempty"`
}

func (m *ExternalId) Reset()                    { *m = ExternalId{} }
func (m *ExternalId) String() string            { return proto.CompactTextString(m) }
func (*ExternalId) ProtoMessage()               {}
func (*ExternalId) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *ExternalId) GetSourceName() string {
	if m != nil {
		return m.SourceName
	}
	return ""
}

func (m *ExternalId) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

type CreateAnnotationSetRequest struct {
	// The annotation set to create.
	AnnotationSet *AnnotationSet `protobuf:"bytes,1,opt,name=annotation_set,json=annotationSet" json:"annotation_set,omitempty"`
}

func (m *CreateAnnotationSetRequest) Reset()                    { *m = CreateAnnotationSetRequest{} }
func (m *CreateAnnotationSetRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateAnnotationSetRequest) ProtoMessage()               {}
func (*CreateAnnotationSetRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

func (m *CreateAnnotationSetRequest) GetAnnotationSet() *AnnotationSet {
	if m != nil {
		return m.AnnotationSet
	}
	return nil
}

type GetAnnotationSetRequest struct {
	// The ID of the annotation set to be retrieved.
	AnnotationSetId string `protobuf:"bytes,1,opt,name=annotation_set_id,json=annotationSetId" json:"annotation_set_id,omitempty"`
}

func (m *GetAnnotationSetRequest) Reset()                    { *m = GetAnnotationSetRequest{} }
func (m *GetAnnotationSetRequest) String() string            { return proto.CompactTextString(m) }
func (*GetAnnotationSetRequest) ProtoMessage()               {}
func (*GetAnnotationSetRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *GetAnnotationSetRequest) GetAnnotationSetId() string {
	if m != nil {
		return m.AnnotationSetId
	}
	return ""
}

type UpdateAnnotationSetRequest struct {
	// The ID of the annotation set to be updated.
	AnnotationSetId string `protobuf:"bytes,1,opt,name=annotation_set_id,json=annotationSetId" json:"annotation_set_id,omitempty"`
	// The new annotation set.
	AnnotationSet *AnnotationSet `protobuf:"bytes,2,opt,name=annotation_set,json=annotationSet" json:"annotation_set,omitempty"`
	// An optional mask specifying which fields to update. Mutable fields are
	// [name][google.genomics.v1.AnnotationSet.name],
	// [source_uri][google.genomics.v1.AnnotationSet.source_uri], and
	// [info][google.genomics.v1.AnnotationSet.info]. If unspecified, all
	// mutable fields will be updated.
	UpdateMask *google_protobuf2.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask" json:"update_mask,omitempty"`
}

func (m *UpdateAnnotationSetRequest) Reset()                    { *m = UpdateAnnotationSetRequest{} }
func (m *UpdateAnnotationSetRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateAnnotationSetRequest) ProtoMessage()               {}
func (*UpdateAnnotationSetRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

func (m *UpdateAnnotationSetRequest) GetAnnotationSetId() string {
	if m != nil {
		return m.AnnotationSetId
	}
	return ""
}

func (m *UpdateAnnotationSetRequest) GetAnnotationSet() *AnnotationSet {
	if m != nil {
		return m.AnnotationSet
	}
	return nil
}

func (m *UpdateAnnotationSetRequest) GetUpdateMask() *google_protobuf2.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

type DeleteAnnotationSetRequest struct {
	// The ID of the annotation set to be deleted.
	AnnotationSetId string `protobuf:"bytes,1,opt,name=annotation_set_id,json=annotationSetId" json:"annotation_set_id,omitempty"`
}

func (m *DeleteAnnotationSetRequest) Reset()                    { *m = DeleteAnnotationSetRequest{} }
func (m *DeleteAnnotationSetRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteAnnotationSetRequest) ProtoMessage()               {}
func (*DeleteAnnotationSetRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

func (m *DeleteAnnotationSetRequest) GetAnnotationSetId() string {
	if m != nil {
		return m.AnnotationSetId
	}
	return ""
}

type SearchAnnotationSetsRequest struct {
	// Required. The dataset IDs to search within. Caller must have `READ` access
	// to these datasets.
	DatasetIds []string `protobuf:"bytes,1,rep,name=dataset_ids,json=datasetIds" json:"dataset_ids,omitempty"`
	// If specified, only annotation sets associated with the given reference set
	// are returned.
	ReferenceSetId string `protobuf:"bytes,2,opt,name=reference_set_id,json=referenceSetId" json:"reference_set_id,omitempty"`
	// Only return annotations sets for which a substring of the name matches this
	// string (case insensitive).
	Name string `protobuf:"bytes,3,opt,name=name" json:"name,omitempty"`
	// If specified, only annotation sets that have any of these types are
	// returned.
	Types []AnnotationType `protobuf:"varint,4,rep,packed,name=types,enum=google.genomics.v1.AnnotationType" json:"types,omitempty"`
	// The continuation token, which is used to page through large result sets.
	// To get the next page of results, set this parameter to the value of
	// `nextPageToken` from the previous response.
	PageToken string `protobuf:"bytes,5,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
	// The maximum number of results to return in a single page. If unspecified,
	// defaults to 128. The maximum value is 1024.
	PageSize int32 `protobuf:"varint,6,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
}

func (m *SearchAnnotationSetsRequest) Reset()                    { *m = SearchAnnotationSetsRequest{} }
func (m *SearchAnnotationSetsRequest) String() string            { return proto.CompactTextString(m) }
func (*SearchAnnotationSetsRequest) ProtoMessage()               {}
func (*SearchAnnotationSetsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

func (m *SearchAnnotationSetsRequest) GetDatasetIds() []string {
	if m != nil {
		return m.DatasetIds
	}
	return nil
}

func (m *SearchAnnotationSetsRequest) GetReferenceSetId() string {
	if m != nil {
		return m.ReferenceSetId
	}
	return ""
}

func (m *SearchAnnotationSetsRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *SearchAnnotationSetsRequest) GetTypes() []AnnotationType {
	if m != nil {
		return m.Types
	}
	return nil
}

func (m *SearchAnnotationSetsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *SearchAnnotationSetsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

type SearchAnnotationSetsResponse struct {
	// The matching annotation sets.
	AnnotationSets []*AnnotationSet `protobuf:"bytes,1,rep,name=annotation_sets,json=annotationSets" json:"annotation_sets,omitempty"`
	// The continuation token, which is used to page through large result sets.
	// Provide this value in a subsequent request to return the next page of
	// results. This field will be empty if there aren't any additional results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *SearchAnnotationSetsResponse) Reset()                    { *m = SearchAnnotationSetsResponse{} }
func (m *SearchAnnotationSetsResponse) String() string            { return proto.CompactTextString(m) }
func (*SearchAnnotationSetsResponse) ProtoMessage()               {}
func (*SearchAnnotationSetsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

func (m *SearchAnnotationSetsResponse) GetAnnotationSets() []*AnnotationSet {
	if m != nil {
		return m.AnnotationSets
	}
	return nil
}

func (m *SearchAnnotationSetsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

type CreateAnnotationRequest struct {
	// The annotation to be created.
	Annotation *Annotation `protobuf:"bytes,1,opt,name=annotation" json:"annotation,omitempty"`
}

func (m *CreateAnnotationRequest) Reset()                    { *m = CreateAnnotationRequest{} }
func (m *CreateAnnotationRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateAnnotationRequest) ProtoMessage()               {}
func (*CreateAnnotationRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

func (m *CreateAnnotationRequest) GetAnnotation() *Annotation {
	if m != nil {
		return m.Annotation
	}
	return nil
}

type BatchCreateAnnotationsRequest struct {
	// The annotations to be created. At most 4096 can be specified in a single
	// request.
	Annotations []*Annotation `protobuf:"bytes,1,rep,name=annotations" json:"annotations,omitempty"`
	// A unique request ID which enables the server to detect duplicated requests.
	// If provided, duplicated requests will result in the same response; if not
	// provided, duplicated requests may result in duplicated data. For a given
	// annotation set, callers should not reuse `request_id`s when writing
	// different batches of annotations - behavior in this case is undefined.
	// A common approach is to use a UUID. For batch jobs where worker crashes are
	// a possibility, consider using some unique variant of a worker or run ID.
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId" json:"request_id,omitempty"`
}

func (m *BatchCreateAnnotationsRequest) Reset()                    { *m = BatchCreateAnnotationsRequest{} }
func (m *BatchCreateAnnotationsRequest) String() string            { return proto.CompactTextString(m) }
func (*BatchCreateAnnotationsRequest) ProtoMessage()               {}
func (*BatchCreateAnnotationsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{12} }

func (m *BatchCreateAnnotationsRequest) GetAnnotations() []*Annotation {
	if m != nil {
		return m.Annotations
	}
	return nil
}

func (m *BatchCreateAnnotationsRequest) GetRequestId() string {
	if m != nil {
		return m.RequestId
	}
	return ""
}

type BatchCreateAnnotationsResponse struct {
	// The resulting per-annotation entries, ordered consistently with the
	// original request.
	Entries []*BatchCreateAnnotationsResponse_Entry `protobuf:"bytes,1,rep,name=entries" json:"entries,omitempty"`
}

func (m *BatchCreateAnnotationsResponse) Reset()                    { *m = BatchCreateAnnotationsResponse{} }
func (m *BatchCreateAnnotationsResponse) String() string            { return proto.CompactTextString(m) }
func (*BatchCreateAnnotationsResponse) ProtoMessage()               {}
func (*BatchCreateAnnotationsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{13} }

func (m *BatchCreateAnnotationsResponse) GetEntries() []*BatchCreateAnnotationsResponse_Entry {
	if m != nil {
		return m.Entries
	}
	return nil
}

type BatchCreateAnnotationsResponse_Entry struct {
	// The creation status.
	Status *google_rpc.Status `protobuf:"bytes,1,opt,name=status" json:"status,omitempty"`
	// The created annotation, if creation was successful.
	Annotation *Annotation `protobuf:"bytes,2,opt,name=annotation" json:"annotation,omitempty"`
}

func (m *BatchCreateAnnotationsResponse_Entry) Reset()         { *m = BatchCreateAnnotationsResponse_Entry{} }
func (m *BatchCreateAnnotationsResponse_Entry) String() string { return proto.CompactTextString(m) }
func (*BatchCreateAnnotationsResponse_Entry) ProtoMessage()    {}
func (*BatchCreateAnnotationsResponse_Entry) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{13, 0}
}

func (m *BatchCreateAnnotationsResponse_Entry) GetStatus() *google_rpc.Status {
	if m != nil {
		return m.Status
	}
	return nil
}

func (m *BatchCreateAnnotationsResponse_Entry) GetAnnotation() *Annotation {
	if m != nil {
		return m.Annotation
	}
	return nil
}

type GetAnnotationRequest struct {
	// The ID of the annotation to be retrieved.
	AnnotationId string `protobuf:"bytes,1,opt,name=annotation_id,json=annotationId" json:"annotation_id,omitempty"`
}

func (m *GetAnnotationRequest) Reset()                    { *m = GetAnnotationRequest{} }
func (m *GetAnnotationRequest) String() string            { return proto.CompactTextString(m) }
func (*GetAnnotationRequest) ProtoMessage()               {}
func (*GetAnnotationRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{14} }

func (m *GetAnnotationRequest) GetAnnotationId() string {
	if m != nil {
		return m.AnnotationId
	}
	return ""
}

type UpdateAnnotationRequest struct {
	// The ID of the annotation to be updated.
	AnnotationId string `protobuf:"bytes,1,opt,name=annotation_id,json=annotationId" json:"annotation_id,omitempty"`
	// The new annotation.
	Annotation *Annotation `protobuf:"bytes,2,opt,name=annotation" json:"annotation,omitempty"`
	// An optional mask specifying which fields to update. Mutable fields are
	// [name][google.genomics.v1.Annotation.name],
	// [variant][google.genomics.v1.Annotation.variant],
	// [transcript][google.genomics.v1.Annotation.transcript], and
	// [info][google.genomics.v1.Annotation.info]. If unspecified, all mutable
	// fields will be updated.
	UpdateMask *google_protobuf2.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask" json:"update_mask,omitempty"`
}

func (m *UpdateAnnotationRequest) Reset()                    { *m = UpdateAnnotationRequest{} }
func (m *UpdateAnnotationRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateAnnotationRequest) ProtoMessage()               {}
func (*UpdateAnnotationRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{15} }

func (m *UpdateAnnotationRequest) GetAnnotationId() string {
	if m != nil {
		return m.AnnotationId
	}
	return ""
}

func (m *UpdateAnnotationRequest) GetAnnotation() *Annotation {
	if m != nil {
		return m.Annotation
	}
	return nil
}

func (m *UpdateAnnotationRequest) GetUpdateMask() *google_protobuf2.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

type DeleteAnnotationRequest struct {
	// The ID of the annotation to be deleted.
	AnnotationId string `protobuf:"bytes,1,opt,name=annotation_id,json=annotationId" json:"annotation_id,omitempty"`
}

func (m *DeleteAnnotationRequest) Reset()                    { *m = DeleteAnnotationRequest{} }
func (m *DeleteAnnotationRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteAnnotationRequest) ProtoMessage()               {}
func (*DeleteAnnotationRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{16} }

func (m *DeleteAnnotationRequest) GetAnnotationId() string {
	if m != nil {
		return m.AnnotationId
	}
	return ""
}

type SearchAnnotationsRequest struct {
	// Required. The annotation sets to search within. The caller must have
	// `READ` access to these annotation sets.
	// All queried annotation sets must have the same type.
	AnnotationSetIds []string `protobuf:"bytes,1,rep,name=annotation_set_ids,json=annotationSetIds" json:"annotation_set_ids,omitempty"`
	// Required. `reference_id` or `reference_name` must be set.
	//
	// Types that are valid to be assigned to Reference:
	//	*SearchAnnotationsRequest_ReferenceId
	//	*SearchAnnotationsRequest_ReferenceName
	Reference isSearchAnnotationsRequest_Reference `protobuf_oneof:"reference"`
	// The start position of the range on the reference, 0-based inclusive. If
	// specified,
	// [referenceId][google.genomics.v1.SearchAnnotationsRequest.reference_id] or
	// [referenceName][google.genomics.v1.SearchAnnotationsRequest.reference_name]
	// must be specified. Defaults to 0.
	Start int64 `protobuf:"varint,4,opt,name=start" json:"start,omitempty"`
	// The end position of the range on the reference, 0-based exclusive. If
	// [referenceId][google.genomics.v1.SearchAnnotationsRequest.reference_id] or
	// [referenceName][google.genomics.v1.SearchAnnotationsRequest.reference_name]
	// must be specified, Defaults to the length of the reference.
	End int64 `protobuf:"varint,5,opt,name=end" json:"end,omitempty"`
	// The continuation token, which is used to page through large result sets.
	// To get the next page of results, set this parameter to the value of
	// `nextPageToken` from the previous response.
	PageToken string `protobuf:"bytes,6,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
	// The maximum number of results to return in a single page. If unspecified,
	// defaults to 256. The maximum value is 2048.
	PageSize int32 `protobuf:"varint,7,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
}

func (m *SearchAnnotationsRequest) Reset()                    { *m = SearchAnnotationsRequest{} }
func (m *SearchAnnotationsRequest) String() string            { return proto.CompactTextString(m) }
func (*SearchAnnotationsRequest) ProtoMessage()               {}
func (*SearchAnnotationsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{17} }

type isSearchAnnotationsRequest_Reference interface {
	isSearchAnnotationsRequest_Reference()
}

type SearchAnnotationsRequest_ReferenceId struct {
	ReferenceId string `protobuf:"bytes,2,opt,name=reference_id,json=referenceId,oneof"`
}
type SearchAnnotationsRequest_ReferenceName struct {
	ReferenceName string `protobuf:"bytes,3,opt,name=reference_name,json=referenceName,oneof"`
}

func (*SearchAnnotationsRequest_ReferenceId) isSearchAnnotationsRequest_Reference()   {}
func (*SearchAnnotationsRequest_ReferenceName) isSearchAnnotationsRequest_Reference() {}

func (m *SearchAnnotationsRequest) GetReference() isSearchAnnotationsRequest_Reference {
	if m != nil {
		return m.Reference
	}
	return nil
}

func (m *SearchAnnotationsRequest) GetAnnotationSetIds() []string {
	if m != nil {
		return m.AnnotationSetIds
	}
	return nil
}

func (m *SearchAnnotationsRequest) GetReferenceId() string {
	if x, ok := m.GetReference().(*SearchAnnotationsRequest_ReferenceId); ok {
		return x.ReferenceId
	}
	return ""
}

func (m *SearchAnnotationsRequest) GetReferenceName() string {
	if x, ok := m.GetReference().(*SearchAnnotationsRequest_ReferenceName); ok {
		return x.ReferenceName
	}
	return ""
}

func (m *SearchAnnotationsRequest) GetStart() int64 {
	if m != nil {
		return m.Start
	}
	return 0
}

func (m *SearchAnnotationsRequest) GetEnd() int64 {
	if m != nil {
		return m.End
	}
	return 0
}

func (m *SearchAnnotationsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *SearchAnnotationsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*SearchAnnotationsRequest) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _SearchAnnotationsRequest_OneofMarshaler, _SearchAnnotationsRequest_OneofUnmarshaler, _SearchAnnotationsRequest_OneofSizer, []interface{}{
		(*SearchAnnotationsRequest_ReferenceId)(nil),
		(*SearchAnnotationsRequest_ReferenceName)(nil),
	}
}

func _SearchAnnotationsRequest_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*SearchAnnotationsRequest)
	// reference
	switch x := m.Reference.(type) {
	case *SearchAnnotationsRequest_ReferenceId:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.ReferenceId)
	case *SearchAnnotationsRequest_ReferenceName:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.ReferenceName)
	case nil:
	default:
		return fmt.Errorf("SearchAnnotationsRequest.Reference has unexpected type %T", x)
	}
	return nil
}

func _SearchAnnotationsRequest_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*SearchAnnotationsRequest)
	switch tag {
	case 2: // reference.reference_id
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Reference = &SearchAnnotationsRequest_ReferenceId{x}
		return true, err
	case 3: // reference.reference_name
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Reference = &SearchAnnotationsRequest_ReferenceName{x}
		return true, err
	default:
		return false, nil
	}
}

func _SearchAnnotationsRequest_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*SearchAnnotationsRequest)
	// reference
	switch x := m.Reference.(type) {
	case *SearchAnnotationsRequest_ReferenceId:
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.ReferenceId)))
		n += len(x.ReferenceId)
	case *SearchAnnotationsRequest_ReferenceName:
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.ReferenceName)))
		n += len(x.ReferenceName)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type SearchAnnotationsResponse struct {
	// The matching annotations.
	Annotations []*Annotation `protobuf:"bytes,1,rep,name=annotations" json:"annotations,omitempty"`
	// The continuation token, which is used to page through large result sets.
	// Provide this value in a subsequent request to return the next page of
	// results. This field will be empty if there aren't any additional results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *SearchAnnotationsResponse) Reset()                    { *m = SearchAnnotationsResponse{} }
func (m *SearchAnnotationsResponse) String() string            { return proto.CompactTextString(m) }
func (*SearchAnnotationsResponse) ProtoMessage()               {}
func (*SearchAnnotationsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{18} }

func (m *SearchAnnotationsResponse) GetAnnotations() []*Annotation {
	if m != nil {
		return m.Annotations
	}
	return nil
}

func (m *SearchAnnotationsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func init() {
	proto.RegisterType((*AnnotationSet)(nil), "google.genomics.v1.AnnotationSet")
	proto.RegisterType((*Annotation)(nil), "google.genomics.v1.Annotation")
	proto.RegisterType((*VariantAnnotation)(nil), "google.genomics.v1.VariantAnnotation")
	proto.RegisterType((*VariantAnnotation_ClinicalCondition)(nil), "google.genomics.v1.VariantAnnotation.ClinicalCondition")
	proto.RegisterType((*Transcript)(nil), "google.genomics.v1.Transcript")
	proto.RegisterType((*Transcript_Exon)(nil), "google.genomics.v1.Transcript.Exon")
	proto.RegisterType((*Transcript_CodingSequence)(nil), "google.genomics.v1.Transcript.CodingSequence")
	proto.RegisterType((*ExternalId)(nil), "google.genomics.v1.ExternalId")
	proto.RegisterType((*CreateAnnotationSetRequest)(nil), "google.genomics.v1.CreateAnnotationSetRequest")
	proto.RegisterType((*GetAnnotationSetRequest)(nil), "google.genomics.v1.GetAnnotationSetRequest")
	proto.RegisterType((*UpdateAnnotationSetRequest)(nil), "google.genomics.v1.UpdateAnnotationSetRequest")
	proto.RegisterType((*DeleteAnnotationSetRequest)(nil), "google.genomics.v1.DeleteAnnotationSetRequest")
	proto.RegisterType((*SearchAnnotationSetsRequest)(nil), "google.genomics.v1.SearchAnnotationSetsRequest")
	proto.RegisterType((*SearchAnnotationSetsResponse)(nil), "google.genomics.v1.SearchAnnotationSetsResponse")
	proto.RegisterType((*CreateAnnotationRequest)(nil), "google.genomics.v1.CreateAnnotationRequest")
	proto.RegisterType((*BatchCreateAnnotationsRequest)(nil), "google.genomics.v1.BatchCreateAnnotationsRequest")
	proto.RegisterType((*BatchCreateAnnotationsResponse)(nil), "google.genomics.v1.BatchCreateAnnotationsResponse")
	proto.RegisterType((*BatchCreateAnnotationsResponse_Entry)(nil), "google.genomics.v1.BatchCreateAnnotationsResponse.Entry")
	proto.RegisterType((*GetAnnotationRequest)(nil), "google.genomics.v1.GetAnnotationRequest")
	proto.RegisterType((*UpdateAnnotationRequest)(nil), "google.genomics.v1.UpdateAnnotationRequest")
	proto.RegisterType((*DeleteAnnotationRequest)(nil), "google.genomics.v1.DeleteAnnotationRequest")
	proto.RegisterType((*SearchAnnotationsRequest)(nil), "google.genomics.v1.SearchAnnotationsRequest")
	proto.RegisterType((*SearchAnnotationsResponse)(nil), "google.genomics.v1.SearchAnnotationsResponse")
	proto.RegisterEnum("google.genomics.v1.AnnotationType", AnnotationType_name, AnnotationType_value)
	proto.RegisterEnum("google.genomics.v1.VariantAnnotation_Type", VariantAnnotation_Type_name, VariantAnnotation_Type_value)
	proto.RegisterEnum("google.genomics.v1.VariantAnnotation_Effect", VariantAnnotation_Effect_name, VariantAnnotation_Effect_value)
	proto.RegisterEnum("google.genomics.v1.VariantAnnotation_ClinicalSignificance", VariantAnnotation_ClinicalSignificance_name, VariantAnnotation_ClinicalSignificance_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for AnnotationServiceV1 service

type AnnotationServiceV1Client interface {
	// Creates a new annotation set. Caller must have WRITE permission for the
	// associated dataset.
	//
	// The following fields are required:
	//
	//   * [datasetId][google.genomics.v1.AnnotationSet.dataset_id]
	//   * [referenceSetId][google.genomics.v1.AnnotationSet.reference_set_id]
	//
	// All other fields may be optionally specified, unless documented as being
	// server-generated (for example, the `id` field).
	CreateAnnotationSet(ctx context.Context, in *CreateAnnotationSetRequest, opts ...grpc.CallOption) (*AnnotationSet, error)
	// Gets an annotation set. Caller must have READ permission for
	// the associated dataset.
	GetAnnotationSet(ctx context.Context, in *GetAnnotationSetRequest, opts ...grpc.CallOption) (*AnnotationSet, error)
	// Updates an annotation set. The update must respect all mutability
	// restrictions and other invariants described on the annotation set resource.
	// Caller must have WRITE permission for the associated dataset.
	UpdateAnnotationSet(ctx context.Context, in *UpdateAnnotationSetRequest, opts ...grpc.CallOption) (*AnnotationSet, error)
	// Deletes an annotation set. Caller must have WRITE permission
	// for the associated annotation set.
	DeleteAnnotationSet(ctx context.Context, in *DeleteAnnotationSetRequest, opts ...grpc.CallOption) (*google_protobuf1.Empty, error)
	// Searches for annotation sets that match the given criteria. Annotation sets
	// are returned in an unspecified order. This order is consistent, such that
	// two queries for the same content (regardless of page size) yield annotation
	// sets in the same order across their respective streams of paginated
	// responses. Caller must have READ permission for the queried datasets.
	SearchAnnotationSets(ctx context.Context, in *SearchAnnotationSetsRequest, opts ...grpc.CallOption) (*SearchAnnotationSetsResponse, error)
	// Creates a new annotation. Caller must have WRITE permission
	// for the associated annotation set.
	//
	// The following fields are required:
	//
	// * [annotationSetId][google.genomics.v1.Annotation.annotation_set_id]
	// * [referenceName][google.genomics.v1.Annotation.reference_name] or
	//   [referenceId][google.genomics.v1.Annotation.reference_id]
	//
	// ### Transcripts
	//
	// For annotations of type TRANSCRIPT, the following fields of
	// [transcript][google.genomics.v1.Annotation.transcript] must be provided:
	//
	// * [exons.start][google.genomics.v1.Transcript.Exon.start]
	// * [exons.end][google.genomics.v1.Transcript.Exon.end]
	//
	// All other fields may be optionally specified, unless documented as being
	// server-generated (for example, the `id` field). The annotated
	// range must be no longer than 100Mbp (mega base pairs). See the
	// [Annotation resource][google.genomics.v1.Annotation]
	// for additional restrictions on each field.
	CreateAnnotation(ctx context.Context, in *CreateAnnotationRequest, opts ...grpc.CallOption) (*Annotation, error)
	// Creates one or more new annotations atomically. All annotations must
	// belong to the same annotation set. Caller must have WRITE
	// permission for this annotation set. For optimal performance, batch
	// positionally adjacent annotations together.
	//
	// If the request has a systemic issue, such as an attempt to write to
	// an inaccessible annotation set, the entire RPC will fail accordingly. For
	// lesser data issues, when possible an error will be isolated to the
	// corresponding batch entry in the response; the remaining well formed
	// annotations will be created normally.
	//
	// For details on the requirements for each individual annotation resource,
	// see
	// [CreateAnnotation][google.genomics.v1.AnnotationServiceV1.CreateAnnotation].
	BatchCreateAnnotations(ctx context.Context, in *BatchCreateAnnotationsRequest, opts ...grpc.CallOption) (*BatchCreateAnnotationsResponse, error)
	// Gets an annotation. Caller must have READ permission
	// for the associated annotation set.
	GetAnnotation(ctx context.Context, in *GetAnnotationRequest, opts ...grpc.CallOption) (*Annotation, error)
	// Updates an annotation. Caller must have
	// WRITE permission for the associated dataset.
	UpdateAnnotation(ctx context.Context, in *UpdateAnnotationRequest, opts ...grpc.CallOption) (*Annotation, error)
	// Deletes an annotation. Caller must have WRITE permission for
	// the associated annotation set.
	DeleteAnnotation(ctx context.Context, in *DeleteAnnotationRequest, opts ...grpc.CallOption) (*google_protobuf1.Empty, error)
	// Searches for annotations that match the given criteria. Results are
	// ordered by genomic coordinate (by reference sequence, then position).
	// Annotations with equivalent genomic coordinates are returned in an
	// unspecified order. This order is consistent, such that two queries for the
	// same content (regardless of page size) yield annotations in the same order
	// across their respective streams of paginated responses. Caller must have
	// READ permission for the queried annotation sets.
	SearchAnnotations(ctx context.Context, in *SearchAnnotationsRequest, opts ...grpc.CallOption) (*SearchAnnotationsResponse, error)
}

type annotationServiceV1Client struct {
	cc *grpc.ClientConn
}

func NewAnnotationServiceV1Client(cc *grpc.ClientConn) AnnotationServiceV1Client {
	return &annotationServiceV1Client{cc}
}

func (c *annotationServiceV1Client) CreateAnnotationSet(ctx context.Context, in *CreateAnnotationSetRequest, opts ...grpc.CallOption) (*AnnotationSet, error) {
	out := new(AnnotationSet)
	err := grpc.Invoke(ctx, "/google.genomics.v1.AnnotationServiceV1/CreateAnnotationSet", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *annotationServiceV1Client) GetAnnotationSet(ctx context.Context, in *GetAnnotationSetRequest, opts ...grpc.CallOption) (*AnnotationSet, error) {
	out := new(AnnotationSet)
	err := grpc.Invoke(ctx, "/google.genomics.v1.AnnotationServiceV1/GetAnnotationSet", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *annotationServiceV1Client) UpdateAnnotationSet(ctx context.Context, in *UpdateAnnotationSetRequest, opts ...grpc.CallOption) (*AnnotationSet, error) {
	out := new(AnnotationSet)
	err := grpc.Invoke(ctx, "/google.genomics.v1.AnnotationServiceV1/UpdateAnnotationSet", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *annotationServiceV1Client) DeleteAnnotationSet(ctx context.Context, in *DeleteAnnotationSetRequest, opts ...grpc.CallOption) (*google_protobuf1.Empty, error) {
	out := new(google_protobuf1.Empty)
	err := grpc.Invoke(ctx, "/google.genomics.v1.AnnotationServiceV1/DeleteAnnotationSet", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *annotationServiceV1Client) SearchAnnotationSets(ctx context.Context, in *SearchAnnotationSetsRequest, opts ...grpc.CallOption) (*SearchAnnotationSetsResponse, error) {
	out := new(SearchAnnotationSetsResponse)
	err := grpc.Invoke(ctx, "/google.genomics.v1.AnnotationServiceV1/SearchAnnotationSets", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *annotationServiceV1Client) CreateAnnotation(ctx context.Context, in *CreateAnnotationRequest, opts ...grpc.CallOption) (*Annotation, error) {
	out := new(Annotation)
	err := grpc.Invoke(ctx, "/google.genomics.v1.AnnotationServiceV1/CreateAnnotation", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *annotationServiceV1Client) BatchCreateAnnotations(ctx context.Context, in *BatchCreateAnnotationsRequest, opts ...grpc.CallOption) (*BatchCreateAnnotationsResponse, error) {
	out := new(BatchCreateAnnotationsResponse)
	err := grpc.Invoke(ctx, "/google.genomics.v1.AnnotationServiceV1/BatchCreateAnnotations", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *annotationServiceV1Client) GetAnnotation(ctx context.Context, in *GetAnnotationRequest, opts ...grpc.CallOption) (*Annotation, error) {
	out := new(Annotation)
	err := grpc.Invoke(ctx, "/google.genomics.v1.AnnotationServiceV1/GetAnnotation", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *annotationServiceV1Client) UpdateAnnotation(ctx context.Context, in *UpdateAnnotationRequest, opts ...grpc.CallOption) (*Annotation, error) {
	out := new(Annotation)
	err := grpc.Invoke(ctx, "/google.genomics.v1.AnnotationServiceV1/UpdateAnnotation", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *annotationServiceV1Client) DeleteAnnotation(ctx context.Context, in *DeleteAnnotationRequest, opts ...grpc.CallOption) (*google_protobuf1.Empty, error) {
	out := new(google_protobuf1.Empty)
	err := grpc.Invoke(ctx, "/google.genomics.v1.AnnotationServiceV1/DeleteAnnotation", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *annotationServiceV1Client) SearchAnnotations(ctx context.Context, in *SearchAnnotationsRequest, opts ...grpc.CallOption) (*SearchAnnotationsResponse, error) {
	out := new(SearchAnnotationsResponse)
	err := grpc.Invoke(ctx, "/google.genomics.v1.AnnotationServiceV1/SearchAnnotations", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for AnnotationServiceV1 service

type AnnotationServiceV1Server interface {
	// Creates a new annotation set. Caller must have WRITE permission for the
	// associated dataset.
	//
	// The following fields are required:
	//
	//   * [datasetId][google.genomics.v1.AnnotationSet.dataset_id]
	//   * [referenceSetId][google.genomics.v1.AnnotationSet.reference_set_id]
	//
	// All other fields may be optionally specified, unless documented as being
	// server-generated (for example, the `id` field).
	CreateAnnotationSet(context.Context, *CreateAnnotationSetRequest) (*AnnotationSet, error)
	// Gets an annotation set. Caller must have READ permission for
	// the associated dataset.
	GetAnnotationSet(context.Context, *GetAnnotationSetRequest) (*AnnotationSet, error)
	// Updates an annotation set. The update must respect all mutability
	// restrictions and other invariants described on the annotation set resource.
	// Caller must have WRITE permission for the associated dataset.
	UpdateAnnotationSet(context.Context, *UpdateAnnotationSetRequest) (*AnnotationSet, error)
	// Deletes an annotation set. Caller must have WRITE permission
	// for the associated annotation set.
	DeleteAnnotationSet(context.Context, *DeleteAnnotationSetRequest) (*google_protobuf1.Empty, error)
	// Searches for annotation sets that match the given criteria. Annotation sets
	// are returned in an unspecified order. This order is consistent, such that
	// two queries for the same content (regardless of page size) yield annotation
	// sets in the same order across their respective streams of paginated
	// responses. Caller must have READ permission for the queried datasets.
	SearchAnnotationSets(context.Context, *SearchAnnotationSetsRequest) (*SearchAnnotationSetsResponse, error)
	// Creates a new annotation. Caller must have WRITE permission
	// for the associated annotation set.
	//
	// The following fields are required:
	//
	// * [annotationSetId][google.genomics.v1.Annotation.annotation_set_id]
	// * [referenceName][google.genomics.v1.Annotation.reference_name] or
	//   [referenceId][google.genomics.v1.Annotation.reference_id]
	//
	// ### Transcripts
	//
	// For annotations of type TRANSCRIPT, the following fields of
	// [transcript][google.genomics.v1.Annotation.transcript] must be provided:
	//
	// * [exons.start][google.genomics.v1.Transcript.Exon.start]
	// * [exons.end][google.genomics.v1.Transcript.Exon.end]
	//
	// All other fields may be optionally specified, unless documented as being
	// server-generated (for example, the `id` field). The annotated
	// range must be no longer than 100Mbp (mega base pairs). See the
	// [Annotation resource][google.genomics.v1.Annotation]
	// for additional restrictions on each field.
	CreateAnnotation(context.Context, *CreateAnnotationRequest) (*Annotation, error)
	// Creates one or more new annotations atomically. All annotations must
	// belong to the same annotation set. Caller must have WRITE
	// permission for this annotation set. For optimal performance, batch
	// positionally adjacent annotations together.
	//
	// If the request has a systemic issue, such as an attempt to write to
	// an inaccessible annotation set, the entire RPC will fail accordingly. For
	// lesser data issues, when possible an error will be isolated to the
	// corresponding batch entry in the response; the remaining well formed
	// annotations will be created normally.
	//
	// For details on the requirements for each individual annotation resource,
	// see
	// [CreateAnnotation][google.genomics.v1.AnnotationServiceV1.CreateAnnotation].
	BatchCreateAnnotations(context.Context, *BatchCreateAnnotationsRequest) (*BatchCreateAnnotationsResponse, error)
	// Gets an annotation. Caller must have READ permission
	// for the associated annotation set.
	GetAnnotation(context.Context, *GetAnnotationRequest) (*Annotation, error)
	// Updates an annotation. Caller must have
	// WRITE permission for the associated dataset.
	UpdateAnnotation(context.Context, *UpdateAnnotationRequest) (*Annotation, error)
	// Deletes an annotation. Caller must have WRITE permission for
	// the associated annotation set.
	DeleteAnnotation(context.Context, *DeleteAnnotationRequest) (*google_protobuf1.Empty, error)
	// Searches for annotations that match the given criteria. Results are
	// ordered by genomic coordinate (by reference sequence, then position).
	// Annotations with equivalent genomic coordinates are returned in an
	// unspecified order. This order is consistent, such that two queries for the
	// same content (regardless of page size) yield annotations in the same order
	// across their respective streams of paginated responses. Caller must have
	// READ permission for the queried annotation sets.
	SearchAnnotations(context.Context, *SearchAnnotationsRequest) (*SearchAnnotationsResponse, error)
}

func RegisterAnnotationServiceV1Server(s *grpc.Server, srv AnnotationServiceV1Server) {
	s.RegisterService(&_AnnotationServiceV1_serviceDesc, srv)
}

func _AnnotationServiceV1_CreateAnnotationSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAnnotationSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnnotationServiceV1Server).CreateAnnotationSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.AnnotationServiceV1/CreateAnnotationSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnnotationServiceV1Server).CreateAnnotationSet(ctx, req.(*CreateAnnotationSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnnotationServiceV1_GetAnnotationSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAnnotationSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnnotationServiceV1Server).GetAnnotationSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.AnnotationServiceV1/GetAnnotationSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnnotationServiceV1Server).GetAnnotationSet(ctx, req.(*GetAnnotationSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnnotationServiceV1_UpdateAnnotationSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateAnnotationSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnnotationServiceV1Server).UpdateAnnotationSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.AnnotationServiceV1/UpdateAnnotationSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnnotationServiceV1Server).UpdateAnnotationSet(ctx, req.(*UpdateAnnotationSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnnotationServiceV1_DeleteAnnotationSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAnnotationSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnnotationServiceV1Server).DeleteAnnotationSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.AnnotationServiceV1/DeleteAnnotationSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnnotationServiceV1Server).DeleteAnnotationSet(ctx, req.(*DeleteAnnotationSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnnotationServiceV1_SearchAnnotationSets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchAnnotationSetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnnotationServiceV1Server).SearchAnnotationSets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.AnnotationServiceV1/SearchAnnotationSets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnnotationServiceV1Server).SearchAnnotationSets(ctx, req.(*SearchAnnotationSetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnnotationServiceV1_CreateAnnotation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAnnotationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnnotationServiceV1Server).CreateAnnotation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.AnnotationServiceV1/CreateAnnotation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnnotationServiceV1Server).CreateAnnotation(ctx, req.(*CreateAnnotationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnnotationServiceV1_BatchCreateAnnotations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchCreateAnnotationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnnotationServiceV1Server).BatchCreateAnnotations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.AnnotationServiceV1/BatchCreateAnnotations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnnotationServiceV1Server).BatchCreateAnnotations(ctx, req.(*BatchCreateAnnotationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnnotationServiceV1_GetAnnotation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAnnotationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnnotationServiceV1Server).GetAnnotation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.AnnotationServiceV1/GetAnnotation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnnotationServiceV1Server).GetAnnotation(ctx, req.(*GetAnnotationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnnotationServiceV1_UpdateAnnotation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateAnnotationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnnotationServiceV1Server).UpdateAnnotation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.AnnotationServiceV1/UpdateAnnotation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnnotationServiceV1Server).UpdateAnnotation(ctx, req.(*UpdateAnnotationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnnotationServiceV1_DeleteAnnotation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAnnotationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnnotationServiceV1Server).DeleteAnnotation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.AnnotationServiceV1/DeleteAnnotation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnnotationServiceV1Server).DeleteAnnotation(ctx, req.(*DeleteAnnotationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnnotationServiceV1_SearchAnnotations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchAnnotationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnnotationServiceV1Server).SearchAnnotations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.AnnotationServiceV1/SearchAnnotations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnnotationServiceV1Server).SearchAnnotations(ctx, req.(*SearchAnnotationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _AnnotationServiceV1_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.genomics.v1.AnnotationServiceV1",
	HandlerType: (*AnnotationServiceV1Server)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateAnnotationSet",
			Handler:    _AnnotationServiceV1_CreateAnnotationSet_Handler,
		},
		{
			MethodName: "GetAnnotationSet",
			Handler:    _AnnotationServiceV1_GetAnnotationSet_Handler,
		},
		{
			MethodName: "UpdateAnnotationSet",
			Handler:    _AnnotationServiceV1_UpdateAnnotationSet_Handler,
		},
		{
			MethodName: "DeleteAnnotationSet",
			Handler:    _AnnotationServiceV1_DeleteAnnotationSet_Handler,
		},
		{
			MethodName: "SearchAnnotationSets",
			Handler:    _AnnotationServiceV1_SearchAnnotationSets_Handler,
		},
		{
			MethodName: "CreateAnnotation",
			Handler:    _AnnotationServiceV1_CreateAnnotation_Handler,
		},
		{
			MethodName: "BatchCreateAnnotations",
			Handler:    _AnnotationServiceV1_BatchCreateAnnotations_Handler,
		},
		{
			MethodName: "GetAnnotation",
			Handler:    _AnnotationServiceV1_GetAnnotation_Handler,
		},
		{
			MethodName: "UpdateAnnotation",
			Handler:    _AnnotationServiceV1_UpdateAnnotation_Handler,
		},
		{
			MethodName: "DeleteAnnotation",
			Handler:    _AnnotationServiceV1_DeleteAnnotation_Handler,
		},
		{
			MethodName: "SearchAnnotations",
			Handler:    _AnnotationServiceV1_SearchAnnotations_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/genomics/v1/annotations.proto",
}

func init() { proto.RegisterFile("google/genomics/v1/annotations.proto", fileDescriptor0) }

var fileDescriptor0 = []byte{
	// 2188 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x59, 0xcd, 0x6f, 0xdb, 0xc8,
	0x15, 0x0f, 0xf5, 0x69, 0x3f, 0xd9, 0x32, 0x3d, 0xf1, 0xda, 0x5a, 0x39, 0x1f, 0x0e, 0xf3, 0x65,
	0xb8, 0x89, 0xbc, 0x51, 0x80, 0x36, 0x75, 0xda, 0x74, 0x65, 0x9a, 0xb6, 0xa7, 0xab, 0x50, 0xc2,
	0x90, 0x72, 0xe1, 0x5e, 0x08, 0x86, 0x1a, 0x7b, 0x89, 0xd8, 0x94, 0x4a, 0xd2, 0x6e, 0xbc, 0xc5,
	0x02, 0x8b, 0xc5, 0x16, 0x3d, 0xf5, 0xb2, 0xbb, 0xf7, 0x5e, 0x0a, 0xb4, 0xff, 0x43, 0x2f, 0x05,
	0x7a, 0x6f, 0x0f, 0x45, 0xff, 0x83, 0x5e, 0xf6, 0xda, 0x53, 0x81, 0x5e, 0x8a, 0x19, 0x92, 0x12,
	0x45, 0x51, 0xb6, 0xdc, 0x00, 0xbd, 0x71, 0xde, 0xbc, 0xf7, 0xe6, 0x37, 0xbf, 0x99, 0xf7, 0x31,
	0x12, 0x3c, 0x38, 0xee, 0xf5, 0x8e, 0x4f, 0xe8, 0xe6, 0x31, 0x75, 0x7a, 0xa7, 0xb6, 0xe5, 0x6d,
	0x9e, 0x3f, 0xdb, 0x34, 0x1d, 0xa7, 0xe7, 0x9b, 0xbe, 0xdd, 0x73, 0xbc, 0x5a, 0xdf, 0xed, 0xf9,
	0x3d, 0x84, 0x02, 0xad, 0x5a, 0xa4, 0x55, 0x3b, 0x7f, 0x56, 0xbd, 0x15, 0x5a, 0x9a, 0x7d, 0x7b,
	0xdc, 0xa2, 0xba, 0x1a, 0xce, 0xf2, 0xd1, 0x9b, 0xb3, 0xa3, 0x4d, 0x7a, 0xda, 0xf7, 0x2f, 0xc2,
	0xc9, 0xb5, 0xe4, 0xe4, 0x91, 0x4d, 0x4f, 0xba, 0xc6, 0xa9, 0xe9, 0xbd, 0x0d, 0x35, 0x6e, 0x25,
	0x35, 0x3c, 0xdf, 0x3d, 0xb3, 0xfc, 0x70, 0xf6, 0x4e, 0x72, 0xf6, 0x97, 0xae, 0xd9, 0xef, 0x53,
	0x37, 0x5a, 0x7c, 0x25, 0x9c, 0x77, 0xfb, 0xd6, 0xa6, 0xe7, 0x9b, 0xfe, 0x59, 0x38, 0x21, 0x7d,
	0x97, 0x81, 0xf9, 0xc6, 0x00, 0xab, 0x46, 0x7d, 0x54, 0x86, 0x8c, 0xdd, 0xad, 0x08, 0x6b, 0xc2,
	0xfa, 0x2c, 0xc9, 0xd8, 0x5d, 0x74, 0x1b, 0xa0, 0x6b, 0xfa, 0xa6, 0x47, 0x7d, 0xc3, 0xee, 0x56,
	0x32, 0x5c, 0x3e, 0x1b, 0x4a, 0x70, 0x17, 0xad, 0x83, 0xe8, 0xd2, 0x23, 0xea, 0x52, 0xc7, 0xa2,
	0x46, 0xa8, 0x94, 0xe5, 0x4a, 0xe5, 0x81, 0x5c, 0xe3, 0x9a, 0x08, 0x72, 0x8e, 0x79, 0x4a, 0x2b,
	0x39, 0x3e, 0xcb, 0xbf, 0x99, 0x73, 0xaf, 0x77, 0xe6, 0x5a, 0xd4, 0x38, 0x73, 0xed, 0x4a, 0x3e,
	0x70, 0x1e, 0x48, 0x3a, 0xae, 0x8d, 0xbe, 0x0f, 0x39, 0xff, 0xa2, 0x4f, 0x2b, 0x85, 0x35, 0x61,
	0xbd, 0x5c, 0x97, 0x6a, 0xe3, 0xa4, 0xd7, 0x86, 0xe0, 0xf5, 0x8b, 0x3e, 0x25, 0x5c, 0x1f, 0xfd,
	0x04, 0x72, 0xb6, 0x73, 0xd4, 0xab, 0x2c, 0xae, 0x65, 0xd7, 0x4b, 0xf5, 0xef, 0x5d, 0x6e, 0xa7,
	0x51, 0xbf, 0x86, 0x9d, 0xa3, 0x9e, 0xe2, 0xf8, 0xee, 0x05, 0xe1, 0x86, 0x55, 0x0d, 0x66, 0x07,
	0x22, 0x24, 0x42, 0xf6, 0x2d, 0xbd, 0x08, 0x29, 0x61, 0x9f, 0xe8, 0x23, 0xc8, 0x9f, 0x9b, 0x27,
	0x67, 0x94, 0xd3, 0x51, 0xaa, 0x57, 0xa3, 0x05, 0x22, 0xfa, 0x6b, 0x4d, 0xdb, 0xf3, 0x0f, 0x98,
	0x06, 0x09, 0x14, 0xb7, 0x32, 0x2f, 0x04, 0xe9, 0xaf, 0x39, 0x80, 0xe1, 0xb2, 0x63, 0x44, 0x6f,
	0xc0, 0xe2, 0xf0, 0xd6, 0x18, 0x23, 0x7c, 0x2f, 0x98, 0x71, 0xb4, 0x31, 0x2e, 0xb3, 0x31, 0x2e,
	0xef, 0xc1, 0xdc, 0xf0, 0x24, 0xec, 0x6e, 0xc8, 0x73, 0x69, 0x20, 0xc3, 0x5d, 0xf4, 0x10, 0x86,
	0x87, 0x62, 0x70, 0x07, 0x01, 0xe5, 0xf3, 0x03, 0xa9, 0xca, 0x3c, 0x2d, 0x41, 0xde, 0xf3, 0x4d,
	0xd7, 0xe7, 0xbc, 0x67, 0x49, 0x30, 0x60, 0x34, 0x50, 0xa7, 0x5b, 0x29, 0x72, 0x19, 0xfb, 0x0c,
	0xdc, 0x9d, 0x53, 0xd7, 0xa3, 0x86, 0xe7, 0xbb, 0xa6, 0xd3, 0xad, 0xcc, 0xac, 0x09, 0xeb, 0x33,
	0xcc, 0x1d, 0x97, 0x6a, 0x5c, 0x38, 0x38, 0xc5, 0xd9, 0x6b, 0x9e, 0x62, 0x03, 0x8a, 0xe7, 0xa6,
	0x6b, 0x9b, 0x8e, 0x5f, 0x01, 0xce, 0xf3, 0xc3, 0x34, 0xd3, 0x83, 0x40, 0x65, 0xe8, 0x61, 0xff,
	0x06, 0x89, 0xec, 0xd0, 0xc7, 0x00, 0x0c, 0x83, 0x67, 0xb9, 0x76, 0xdf, 0xaf, 0x94, 0xb8, 0x97,
	0x3b, 0x69, 0x5e, 0xf4, 0x81, 0xd6, 0xfe, 0x0d, 0x12, 0xb3, 0x41, 0x3f, 0x0a, 0xaf, 0xd2, 0x1c,
	0xbf, 0x4a, 0xeb, 0x97, 0x83, 0xff, 0xbf, 0xdc, 0xa3, 0xed, 0x62, 0x68, 0x25, 0xfd, 0x67, 0x16,
	0x16, 0xc7, 0xb6, 0x8f, 0x5e, 0x85, 0x74, 0x0b, 0x9c, 0xee, 0x8d, 0xa9, 0x38, 0xab, 0xc5, 0x68,
	0xdf, 0x81, 0x02, 0x3d, 0x3a, 0xa2, 0x96, 0xcf, 0x51, 0x95, 0xeb, 0x4f, 0xa6, 0xf3, 0xa0, 0x70,
	0x1b, 0x12, 0xda, 0xa2, 0xc7, 0xb0, 0x60, 0x9e, 0xf8, 0xd4, 0x75, 0x4c, 0x9f, 0x1a, 0x6f, 0x4c,
	0x8f, 0x7a, 0x51, 0x5a, 0x18, 0x88, 0xb7, 0x99, 0x14, 0xad, 0x40, 0xf1, 0x98, 0x3a, 0xb1, 0x1b,
	0x5b, 0x60, 0xc3, 0xe0, 0xb2, 0x0e, 0xcf, 0xc1, 0xb0, 0xbb, 0x5e, 0x25, 0xbf, 0x96, 0x65, 0x97,
	0x75, 0x28, 0xc5, 0x5d, 0x0f, 0xfd, 0x0c, 0xc0, 0xea, 0x39, 0x5d, 0x9b, 0xe7, 0xda, 0x4a, 0x81,
	0x1f, 0xd3, 0x0f, 0xa6, 0x83, 0x2c, 0x9f, 0xd8, 0x8e, 0x6d, 0x99, 0x27, 0x72, 0x64, 0x4f, 0x62,
	0xae, 0x50, 0x0f, 0x3e, 0xb0, 0x42, 0x05, 0xc3, 0xb3, 0x8f, 0x1d, 0xfb, 0xc8, 0xb6, 0x4c, 0xc7,
	0xa2, 0x3c, 0x02, 0xca, 0xf5, 0xad, 0xeb, 0xad, 0xa1, 0xc5, 0x3c, 0x90, 0x25, 0x2b, 0x45, 0x5a,
	0xfd, 0xbd, 0x00, 0x8b, 0x63, 0x90, 0x58, 0x30, 0xb2, 0x48, 0xf5, 0x2a, 0x02, 0xdf, 0x7d, 0x30,
	0x40, 0x0d, 0x98, 0xa3, 0xef, 0x38, 0x8f, 0x27, 0x9c, 0x9a, 0x0c, 0xdf, 0x77, 0xea, 0xd5, 0x56,
	0x42, 0x3d, 0xdc, 0x25, 0x25, 0x3a, 0xf8, 0xf6, 0x58, 0xee, 0xb5, 0x7a, 0x8e, 0x45, 0xfb, 0xb1,
	0x9c, 0x3d, 0x1b, 0x4a, 0x70, 0x97, 0x9d, 0x4b, 0xef, 0xd4, 0x3e, 0x8d, 0x9d, 0x0b, 0x1b, 0xe2,
	0xae, 0xf4, 0x39, 0xe4, 0xd8, 0x6d, 0x41, 0x4b, 0x20, 0xea, 0x87, 0x6d, 0xc5, 0xe8, 0xa8, 0x5a,
	0x5b, 0x91, 0xf1, 0x2e, 0x56, 0x76, 0xc4, 0x1b, 0xa8, 0x0c, 0xc0, 0xa5, 0x2d, 0x7d, 0x5f, 0x21,
	0xa2, 0x80, 0xe6, 0x61, 0x16, 0xab, 0x9a, 0x42, 0x74, 0xdc, 0x52, 0xc5, 0x0c, 0x9a, 0x83, 0x99,
	0x1d, 0xa5, 0xa9, 0xf0, 0x51, 0x16, 0x89, 0x30, 0xa7, 0x75, 0xb6, 0x35, 0x1d, 0xeb, 0x1d, 0x2e,
	0xc9, 0xa1, 0x22, 0x64, 0x35, 0xb5, 0x2d, 0xe6, 0x99, 0x1f, 0x4d, 0x27, 0x1d, 0x59, 0xef, 0x90,
	0x46, 0x53, 0x2c, 0xb0, 0x09, 0x59, 0x3d, 0x10, 0x8b, 0xd2, 0x5f, 0x04, 0x28, 0x04, 0x77, 0x0d,
	0x2d, 0x03, 0x52, 0x76, 0x77, 0x15, 0x59, 0x4f, 0x60, 0x10, 0x61, 0x2e, 0x94, 0x47, 0x28, 0xca,
	0x00, 0xbb, 0xa4, 0xf1, 0x5a, 0xd1, 0xf6, 0xf1, 0xae, 0x2e, 0x66, 0x50, 0x15, 0x96, 0xf9, 0xd8,
	0x68, 0x13, 0x45, 0x53, 0xc8, 0x01, 0x56, 0xf7, 0x0c, 0xac, 0xee, 0x28, 0x4d, 0x31, 0x8b, 0x10,
	0x94, 0xb5, 0x43, 0xb5, 0xa5, 0x1e, 0xbe, 0x6e, 0x75, 0x34, 0x83, 0xa1, 0xc9, 0xa1, 0x0f, 0x60,
	0x51, 0x6d, 0xa9, 0x09, 0x71, 0x9e, 0x6d, 0x4e, 0xd3, 0x5b, 0x6d, 0x63, 0xaf, 0x81, 0x55, 0xb1,
	0x30, 0x18, 0x36, 0x5b, 0x9a, 0x26, 0x16, 0xd9, 0x22, 0x5a, 0xbb, 0x89, 0x65, 0xc5, 0xd0, 0xb0,
	0xae, 0x18, 0x3b, 0x58, 0x23, 0x9d, 0x36, 0xdf, 0xe7, 0x8c, 0xf4, 0xe7, 0x0c, 0x2c, 0xa5, 0x5d,
	0x0d, 0xf4, 0x10, 0xee, 0xc9, 0x4d, 0xac, 0x62, 0xb9, 0xd1, 0x34, 0x34, 0xbc, 0xa7, 0xe2, 0x5d,
	0x2c, 0x37, 0x54, 0x39, 0x49, 0xf3, 0x5d, 0x58, 0x4d, 0x57, 0x8b, 0xf1, 0xde, 0x51, 0x65, 0x85,
	0xe8, 0x0c, 0x5a, 0x06, 0x01, 0x14, 0xb6, 0x15, 0x15, 0xef, 0x31, 0xd6, 0x17, 0x61, 0xbe, 0x89,
	0x3f, 0x51, 0x9a, 0x87, 0x46, 0x28, 0xe2, 0xfb, 0x0b, 0x45, 0xed, 0x86, 0xbe, 0xdf, 0xda, 0x53,
	0x54, 0x2c, 0x07, 0x87, 0x10, 0x1b, 0x17, 0x98, 0xe5, 0x0e, 0xe9, 0xec, 0x19, 0x44, 0xd1, 0xda,
	0x2d, 0x55, 0x53, 0xc4, 0x22, 0x3b, 0x83, 0x7d, 0xac, 0xe9, 0x2d, 0xb9, 0xf5, 0xba, 0xdd, 0xd0,
	0xf1, 0x36, 0x6e, 0x62, 0xfd, 0x50, 0x9c, 0x41, 0x2b, 0x70, 0x53, 0x6e, 0xa9, 0xbb, 0x0a, 0xd1,
	0x0c, 0x4d, 0x51, 0x35, 0xac, 0xe3, 0x03, 0x36, 0x31, 0x8b, 0x16, 0xa0, 0x44, 0xb0, 0xf6, 0x89,
	0xb1, 0xdb, 0x90, 0xf5, 0x16, 0x11, 0x81, 0x09, 0x1a, 0x9a, 0xd6, 0x92, 0x71, 0x83, 0x73, 0x53,
	0xe2, 0xab, 0x92, 0x96, 0xae, 0xc8, 0x3a, 0x3e, 0x50, 0xc4, 0x39, 0x06, 0xee, 0x75, 0xa7, 0xa9,
	0xe3, 0x76, 0x53, 0x31, 0x88, 0xd2, 0x6e, 0x11, 0x5d, 0xd9, 0x11, 0xe7, 0xa5, 0x7f, 0x64, 0x00,
	0x86, 0x69, 0x3b, 0x9e, 0x47, 0x84, 0x91, 0x3c, 0xf2, 0x43, 0xc8, 0xd3, 0x77, 0x2c, 0x37, 0x04,
	0x31, 0x72, 0xff, 0xf2, 0xf4, 0x5f, 0x53, 0xde, 0xf5, 0x1c, 0x12, 0x58, 0xa0, 0x03, 0x58, 0xb0,
	0x7a, 0x5d, 0xdb, 0x39, 0x36, 0x3c, 0xfa, 0x8b, 0x33, 0x56, 0x1f, 0x79, 0x9c, 0x94, 0xea, 0x4f,
	0xaf, 0x70, 0x22, 0x73, 0x2b, 0x2d, 0x34, 0x22, 0x65, 0x6b, 0x64, 0x5c, 0x35, 0x21, 0xc7, 0x96,
	0x19, 0x16, 0x5a, 0x21, 0xa5, 0xd0, 0x66, 0x86, 0x85, 0xf6, 0x19, 0xe4, 0x8f, 0xdc, 0xa8, 0xde,
	0x97, 0xea, 0xab, 0x63, 0x75, 0x02, 0x3b, 0xfe, 0xf3, 0x7a, 0x58, 0x28, 0xb8, 0x66, 0xf5, 0x05,
	0x94, 0x47, 0x41, 0x4c, 0xbb, 0x98, 0xf4, 0x63, 0x80, 0x61, 0xca, 0x40, 0x77, 0xa1, 0x14, 0x76,
	0x68, 0xbc, 0x5f, 0x08, 0xa8, 0x0d, 0x9b, 0x36, 0xde, 0x2c, 0x04, 0x6d, 0x4c, 0x26, 0x6a, 0x63,
	0xa4, 0x23, 0xa8, 0xca, 0x2e, 0x35, 0x7d, 0x3a, 0xd2, 0x61, 0x11, 0x86, 0xc2, 0xf3, 0xd1, 0x3e,
	0x94, 0x47, 0x9b, 0x1c, 0xee, 0xb1, 0x54, 0xbf, 0x77, 0x65, 0x8f, 0x46, 0xe6, 0x47, 0x9a, 0x20,
	0x49, 0x81, 0x95, 0x3d, 0xea, 0xa7, 0x2e, 0x92, 0xda, 0x49, 0x09, 0xa9, 0x9d, 0x94, 0xf4, 0x37,
	0x01, 0xaa, 0x9d, 0x7e, 0x77, 0x12, 0xde, 0x6b, 0xb8, 0x4a, 0xd9, 0x5b, 0xe6, 0x7f, 0xdb, 0x1b,
	0x7a, 0x09, 0xa5, 0x33, 0x8e, 0x89, 0xbf, 0x00, 0xc2, 0x53, 0x1f, 0xef, 0x0e, 0x76, 0xd9, 0x23,
	0xe1, 0xb5, 0xe9, 0xbd, 0x25, 0x10, 0xa8, 0xb3, 0x6f, 0x69, 0x1f, 0xaa, 0x3b, 0xf4, 0x84, 0xbe,
	0xff, 0x86, 0xa4, 0x7f, 0x09, 0xb0, 0xaa, 0x51, 0xd3, 0xb5, 0x3e, 0x1d, 0x71, 0xe5, 0x45, 0xbe,
	0xee, 0x42, 0x69, 0xf8, 0x34, 0x88, 0x0a, 0x14, 0x0c, 0xde, 0x06, 0x5e, 0xea, 0xe3, 0x20, 0x73,
	0xe9, 0xe3, 0x20, 0xde, 0xd0, 0xbe, 0x80, 0x3c, 0x6b, 0x48, 0xbc, 0x4a, 0x6e, 0x2d, 0x3b, 0x65,
	0xe3, 0x18, 0x18, 0xb0, 0xd2, 0xd6, 0x37, 0x8f, 0xa9, 0xe1, 0xf7, 0xde, 0x52, 0x27, 0x7a, 0x56,
	0x30, 0x89, 0xce, 0x04, 0x68, 0x15, 0xf8, 0xc0, 0xf0, 0xec, 0xcf, 0x82, 0xb7, 0x45, 0x9e, 0xcc,
	0x30, 0x81, 0x66, 0x7f, 0x46, 0xa5, 0xaf, 0x05, 0xb8, 0x95, 0xbe, 0x69, 0xaf, 0xdf, 0x73, 0x3c,
	0x8a, 0x7e, 0x0a, 0x0b, 0xa3, 0x0c, 0x06, 0x3b, 0x9f, 0xea, 0x9c, 0xcb, 0x23, 0x14, 0x7b, 0xe8,
	0x11, 0x2c, 0x38, 0xf4, 0x9d, 0x6f, 0xc4, 0xd0, 0x06, 0xfc, 0xcc, 0x33, 0x71, 0x3b, 0x42, 0x2c,
	0x1d, 0xc2, 0x4a, 0x32, 0xa8, 0xa2, 0x43, 0x78, 0x05, 0x30, 0x74, 0x1a, 0x46, 0xd3, 0x9d, 0xcb,
	0x91, 0x90, 0x98, 0x85, 0xf4, 0x85, 0x00, 0xb7, 0xb7, 0x4d, 0xdf, 0xfa, 0x34, 0xb9, 0xc0, 0xe0,
	0x98, 0x3f, 0x86, 0x52, 0xec, 0x39, 0x1b, 0x6e, 0xf6, 0xaa, 0x25, 0xe2, 0x26, 0xec, 0x3c, 0xdc,
	0xc0, 0x59, 0xec, 0x0d, 0x19, 0x4a, 0x70, 0x57, 0xfa, 0x4e, 0x80, 0x3b, 0x93, 0x20, 0x84, 0xa4,
	0x13, 0x28, 0x52, 0xc7, 0x77, 0x6d, 0x1a, 0xad, 0xff, 0x22, 0x6d, 0xfd, 0xcb, 0x9d, 0xd4, 0x82,
	0xce, 0x3c, 0x72, 0x54, 0xf5, 0x20, 0x1f, 0x34, 0xe6, 0x1b, 0x50, 0x08, 0x1e, 0xc5, 0x21, 0x7d,
	0x28, 0xf2, 0xed, 0xf6, 0xad, 0x9a, 0xc6, 0x67, 0x48, 0xa8, 0x91, 0xa0, 0x3b, 0x73, 0x6d, 0xba,
	0x5f, 0xc2, 0xd2, 0x48, 0xda, 0x8a, 0x48, 0xbe, 0x0f, 0xb1, 0x1c, 0x30, 0x8c, 0xc9, 0xb9, 0xa1,
	0x10, 0x77, 0xa5, 0x3f, 0x09, 0xb0, 0x92, 0x4c, 0x56, 0xd7, 0x71, 0xf0, 0xbe, 0xe8, 0xdf, 0x2f,
	0x31, 0xbd, 0x82, 0x95, 0x64, 0x62, 0xba, 0xd6, 0xee, 0x7f, 0x93, 0x81, 0x4a, 0x32, 0x32, 0x07,
	0x97, 0xf4, 0x09, 0xa0, 0xb1, 0xbc, 0x16, 0xa5, 0x24, 0x31, 0x91, 0xd8, 0x3c, 0x74, 0x3f, 0xf1,
	0x56, 0xe6, 0x57, 0x72, 0xff, 0xc6, 0xe8, 0x6b, 0xf9, 0xf1, 0xd8, 0x6b, 0x39, 0x1b, 0xaa, 0x4d,
	0x7a, 0x2f, 0xe7, 0x52, 0x2a, 0x6b, 0x7e, 0x58, 0xc6, 0x47, 0xd3, 0x52, 0xe1, 0xd2, 0xb4, 0x54,
	0x1c, 0x4d, 0x4b, 0xdb, 0x25, 0x98, 0x1d, 0x2c, 0x2a, 0xfd, 0x5a, 0x80, 0x0f, 0x53, 0x98, 0x08,
	0x63, 0xe5, 0xfd, 0xe3, 0x75, 0xca, 0xb4, 0xb4, 0x41, 0xa1, 0x3c, 0x9a, 0x80, 0x59, 0x5f, 0xda,
	0x50, 0xd5, 0x96, 0xce, 0x7b, 0x39, 0x23, 0xe5, 0x7d, 0x50, 0x82, 0xe2, 0x9e, 0xa2, 0x2a, 0x04,
	0xcb, 0xa2, 0xc0, 0x06, 0x07, 0x0d, 0x82, 0x1b, 0x2a, 0xeb, 0xc9, 0x67, 0x20, 0xc7, 0x66, 0xc4,
	0x2c, 0x7f, 0x43, 0x90, 0x86, 0xaa, 0xc9, 0x04, 0xb7, 0x75, 0x31, 0x57, 0xff, 0x6a, 0x1e, 0x6e,
	0xc6, 0xf3, 0xa8, 0x7b, 0x6e, 0x5b, 0xf4, 0xe0, 0x19, 0xfa, 0x56, 0x80, 0x9b, 0x29, 0xbd, 0x06,
	0xaa, 0xa5, 0xed, 0x75, 0x72, 0x53, 0x52, 0xbd, 0x3a, 0x71, 0x4b, 0x1b, 0x5f, 0xfe, 0xfd, 0x9f,
	0xdf, 0x64, 0x1e, 0x48, 0x28, 0xf1, 0x73, 0x20, 0xf5, 0xbd, 0xad, 0x44, 0xd5, 0x47, 0x5f, 0x0b,
	0x20, 0x26, 0x5b, 0x13, 0x94, 0xfa, 0x23, 0xd4, 0x84, 0x06, 0x66, 0x1a, 0x40, 0x35, 0x0e, 0x68,
	0x1d, 0x3d, 0x1a, 0x07, 0xb4, 0xf9, 0xab, 0xb1, 0x48, 0xf8, 0x1c, 0xfd, 0x51, 0x80, 0x9b, 0x29,
	0x7d, 0x4e, 0x3a, 0x57, 0x93, 0x1b, 0xa2, 0x69, 0xa0, 0xbd, 0xe2, 0xd0, 0x5e, 0x54, 0xa7, 0x84,
	0x36, 0xc6, 0xdf, 0x6f, 0x05, 0xb8, 0x99, 0xd2, 0xc1, 0xa4, 0x43, 0x9d, 0xdc, 0xea, 0x54, 0x97,
	0xc7, 0xf2, 0x92, 0x72, 0xda, 0xf7, 0x2f, 0x22, 0xea, 0x36, 0xa6, 0xa5, 0xee, 0x77, 0x02, 0x2c,
	0xa5, 0x75, 0x04, 0x68, 0x33, 0x0d, 0xd0, 0x25, 0x0d, 0x53, 0xf5, 0xa3, 0xe9, 0x0d, 0x82, 0x58,
	0x96, 0x1e, 0x70, 0xac, 0x77, 0xa4, 0x0f, 0x53, 0xb0, 0x7a, 0xdc, 0x70, 0x4b, 0xd8, 0x40, 0x5f,
	0x09, 0x20, 0x26, 0xef, 0x77, 0xfa, 0x8d, 0x9b, 0xd0, 0x45, 0x54, 0xaf, 0x48, 0x0f, 0xd2, 0x7d,
	0x8e, 0xe3, 0xb6, 0xb4, 0x90, 0xc0, 0xb1, 0x15, 0xaf, 0x0e, 0x7f, 0x10, 0x60, 0x39, 0xbd, 0x04,
	0xa3, 0x67, 0xd7, 0x29, 0xd7, 0x01, 0xa4, 0xfa, 0xf5, 0x2b, 0xbc, 0xf4, 0x88, 0xc3, 0x5c, 0x93,
	0x56, 0x93, 0x30, 0xdf, 0x0c, 0xed, 0x18, 0x61, 0x5f, 0x0a, 0x30, 0x3f, 0x12, 0x7c, 0x68, 0xfd,
	0xca, 0xf8, 0x9c, 0x96, 0xaa, 0xc7, 0x1c, 0xc3, 0x3d, 0x74, 0x37, 0x81, 0x61, 0xe4, 0x6e, 0xb1,
	0x7b, 0xf5, 0xad, 0x00, 0x62, 0x32, 0xd2, 0xd2, 0x4f, 0x6d, 0x42, 0xcd, 0xbf, 0x12, 0xca, 0x73,
	0x0e, 0xe5, 0x69, 0xf5, 0x2a, 0x28, 0x23, 0xa7, 0xf8, 0x85, 0x00, 0x62, 0x32, 0xaa, 0xd2, 0x61,
	0x4d, 0xa8, 0xe6, 0x13, 0x03, 0x2f, 0x64, 0x66, 0xe3, 0x4a, 0x66, 0xbe, 0x11, 0x60, 0x71, 0xac,
	0xbe, 0xa1, 0x27, 0xd3, 0x44, 0xcf, 0xe0, 0xfa, 0x3c, 0x9d, 0x52, 0x3b, 0xbc, 0x39, 0xf7, 0x38,
	0xb6, 0x55, 0x69, 0x39, 0x89, 0x6d, 0x10, 0x65, 0xdb, 0x6f, 0x61, 0xd9, 0xea, 0x9d, 0xa6, 0xb8,
	0xdd, 0x16, 0x63, 0x1e, 0xdb, 0x6c, 0xcf, 0x6d, 0xe1, 0xe7, 0x5b, 0x91, 0x5e, 0xef, 0xc4, 0x74,
	0x8e, 0x6b, 0x3d, 0xf7, 0x78, 0xf3, 0x98, 0x3a, 0x9c, 0x91, 0xcd, 0x60, 0xca, 0xec, 0xdb, 0x5e,
	0xfc, 0x6f, 0xa6, 0x97, 0xd1, 0xf7, 0xbf, 0x05, 0xe1, 0x4d, 0x81, 0x6b, 0x3e, 0xff, 0x6f, 0x00,
	0x00, 0x00, 0xff, 0xff, 0xf4, 0x94, 0x75, 0x44, 0x8f, 0x1a, 0x00, 0x00,
}
