// Code generated by "go generate gonum.org/v1/gonum/blas/gonum”; DO NOT EDIT.

// Copyright ©2014 The Gonum Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

package gonum

import (
	math "gonum.org/v1/gonum/internal/math32"
)

type general32 struct {
	data       []float32
	rows, cols int
	stride     int
}

func (g general32) clone() general32 {
	data := make([]float32, len(g.data))
	copy(data, g.data)
	return general32{
		data:   data,
		rows:   g.rows,
		cols:   g.cols,
		stride: g.stride,
	}
}

func (g general32) equal(a general32) bool {
	if g.rows != a.rows || g.cols != a.cols || g.stride != a.stride {
		return false
	}
	for i, v := range g.data {
		if a.data[i] != v {
			return false
		}
	}
	return true
}

func (g general32) equalWithinAbs(a general32, tol float32) bool {
	if g.rows != a.rows || g.cols != a.cols || g.stride != a.stride {
		return false
	}
	for i, v := range g.data {
		if math.Abs(a.data[i]-v) > tol {
			return false
		}
	}
	return true
}
