package txbuilder

import "testing"

func BenchmarkUnmarshalSigningInstruction(b *testing.B) {
	const exampleJSON = `{"asset_id":"580b3aeee65682854e0b9e68a8ed2061ee39b63c0ce99ad27b4e5255e8e08069","amount":200,"position":6,"witness_components":[{"type":"signature","quorum":1,"keys":[{"xpub":"55dbba57aa1b5b861ff943ee7b99bed180fbf65fb14adb380297a5a359afa2fe686b49ff2fad14bb058a50eb5fae66983e8940a00d27641741ca74bb12faed40","derivation_path":["01d700000000000000","0900000000000000"]},{"xpub":"e372b90d7725bf9cc7b78297cf8ba0b6d1a1378f8b336d0ee3ffd81f777b67f1bb77acd04210a90a1f32817cc4019860ed5da13aee7153e10d86954774bf024c","derivation_path":["01d700000000000000","0900000000000000"]},{"xpub":"5aece801cf5b891f099ddab8e6c17c2f5bbcaf8cd9416b239748d7183a0fd5068f30787b4fc3a8a2514a4f4385d00eb55479e71e6d73964e63bb59340235ef78","derivation_path":["01d700000000000000","0900000000000000"]}],"signatures":["f1536ac79a27d5429fee18a6457baaabecc7ac0cdde728eb80304ce72211f6b709b9d4e397076b71a7cbb7f11e5d0a86e1cf3cfae5e67df811a77e8ff84ed60b","c9dcb0fae61bdbb524118b03b46273253ad347acc9a538ce41ece49b4ad8ffba7f4161a1421c714fbdb749d208d992d4332938c1ca8fdecf2b4493ab21cf2600","e53152ae79ec1a8c77c096250047aeb3d8dff7f6b61c70888fe42375e602a34516ba761302b7299dd5ecb5250d7efa25fe5d20fc305a3c726cec6089468e470b"]},{"type":"signature","quorum":1,"keys":[{"xpub":"55dbba57aa1b5b861ff943ee7b99bed180fbf65fb14adb380297a5a359afa2fe686b49ff2fad14bb058a50eb5fae66983e8940a00d27641741ca74bb12faed40","derivation_path":["01d700000000000000","0900000000000000"]},{"xpub":"e372b90d7725bf9cc7b78297cf8ba0b6d1a1378f8b336d0ee3ffd81f777b67f1bb77acd04210a90a1f32817cc4019860ed5da13aee7153e10d86954774bf024c","derivation_path":["01d700000000000000","0900000000000000"]},{"xpub":"5aece801cf5b891f099ddab8e6c17c2f5bbcaf8cd9416b239748d7183a0fd5068f30787b4fc3a8a2514a4f4385d00eb55479e71e6d73964e63bb59340235ef78","derivation_path":["01d700000000000000","0900000000000000"]}],"signatures":["f1536ac79a27d5429fee18a6457baaabecc7ac0cdde728eb80304ce72211f6b709b9d4e397076b71a7cbb7f11e5d0a86e1cf3cfae5e67df811a77e8ff84ed60b","c9dcb0fae61bdbb524118b03b46273253ad347acc9a538ce41ece49b4ad8ffba7f4161a1421c714fbdb749d208d992d4332938c1ca8fdecf2b4493ab21cf2600","e53152ae79ec1a8c77c096250047aeb3d8dff7f6b61c70888fe42375e602a34516ba761302b7299dd5ecb5250d7efa25fe5d20fc305a3c726cec6089468e470b"]}]}`
	var instruction SigningInstruction
	for i := 0; i < b.N; i++ {
		err := instruction.UnmarshalJSON([]byte(exampleJSON))
		if err != nil {
			b.Fatal(err)
		}
	}
}
