// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/datastore/v1/datastore.proto

/*
Package datastore is a generated protocol buffer package.

It is generated from these files:
	google/datastore/v1/datastore.proto
	google/datastore/v1/entity.proto
	google/datastore/v1/query.proto

It has these top-level messages:
	LookupRequest
	LookupResponse
	RunQueryRequest
	RunQueryResponse
	BeginTransactionRequest
	BeginTransactionResponse
	RollbackRequest
	RollbackResponse
	CommitRequest
	CommitResponse
	AllocateIdsRequest
	AllocateIdsResponse
	Mutation
	MutationResult
	ReadOptions
	TransactionOptions
	PartitionId
	Key
	ArrayValue
	Value
	Entity
	EntityResult
	Query
	KindExpression
	PropertyReference
	Projection
	PropertyOrder
	Filter
	CompositeFilter
	PropertyFilter
	GqlQuery
	GqlQueryParameter
	QueryResultBatch
*/
package datastore

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/annotations"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// The modes available for commits.
type CommitRequest_Mode int32

const (
	// Unspecified. This value must not be used.
	CommitRequest_MODE_UNSPECIFIED CommitRequest_Mode = 0
	// Transactional: The mutations are either all applied, or none are applied.
	// Learn about transactions [here](https://cloud.google.com/datastore/docs/concepts/transactions).
	CommitRequest_TRANSACTIONAL CommitRequest_Mode = 1
	// Non-transactional: The mutations may not apply as all or none.
	CommitRequest_NON_TRANSACTIONAL CommitRequest_Mode = 2
)

var CommitRequest_Mode_name = map[int32]string{
	0: "MODE_UNSPECIFIED",
	1: "TRANSACTIONAL",
	2: "NON_TRANSACTIONAL",
}
var CommitRequest_Mode_value = map[string]int32{
	"MODE_UNSPECIFIED":  0,
	"TRANSACTIONAL":     1,
	"NON_TRANSACTIONAL": 2,
}

func (x CommitRequest_Mode) String() string {
	return proto.EnumName(CommitRequest_Mode_name, int32(x))
}
func (CommitRequest_Mode) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{8, 0} }

// The possible values for read consistencies.
type ReadOptions_ReadConsistency int32

const (
	// Unspecified. This value must not be used.
	ReadOptions_READ_CONSISTENCY_UNSPECIFIED ReadOptions_ReadConsistency = 0
	// Strong consistency.
	ReadOptions_STRONG ReadOptions_ReadConsistency = 1
	// Eventual consistency.
	ReadOptions_EVENTUAL ReadOptions_ReadConsistency = 2
)

var ReadOptions_ReadConsistency_name = map[int32]string{
	0: "READ_CONSISTENCY_UNSPECIFIED",
	1: "STRONG",
	2: "EVENTUAL",
}
var ReadOptions_ReadConsistency_value = map[string]int32{
	"READ_CONSISTENCY_UNSPECIFIED": 0,
	"STRONG":                       1,
	"EVENTUAL":                     2,
}

func (x ReadOptions_ReadConsistency) String() string {
	return proto.EnumName(ReadOptions_ReadConsistency_name, int32(x))
}
func (ReadOptions_ReadConsistency) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor0, []int{14, 0}
}

// The request for [Datastore.Lookup][google.datastore.v1.Datastore.Lookup].
type LookupRequest struct {
	// The ID of the project against which to make the request.
	ProjectId string `protobuf:"bytes,8,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// The options for this lookup request.
	ReadOptions *ReadOptions `protobuf:"bytes,1,opt,name=read_options,json=readOptions" json:"read_options,omitempty"`
	// Keys of entities to look up.
	Keys []*Key `protobuf:"bytes,3,rep,name=keys" json:"keys,omitempty"`
}

func (m *LookupRequest) Reset()                    { *m = LookupRequest{} }
func (m *LookupRequest) String() string            { return proto.CompactTextString(m) }
func (*LookupRequest) ProtoMessage()               {}
func (*LookupRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *LookupRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *LookupRequest) GetReadOptions() *ReadOptions {
	if m != nil {
		return m.ReadOptions
	}
	return nil
}

func (m *LookupRequest) GetKeys() []*Key {
	if m != nil {
		return m.Keys
	}
	return nil
}

// The response for [Datastore.Lookup][google.datastore.v1.Datastore.Lookup].
type LookupResponse struct {
	// Entities found as `ResultType.FULL` entities. The order of results in this
	// field is undefined and has no relation to the order of the keys in the
	// input.
	Found []*EntityResult `protobuf:"bytes,1,rep,name=found" json:"found,omitempty"`
	// Entities not found as `ResultType.KEY_ONLY` entities. The order of results
	// in this field is undefined and has no relation to the order of the keys
	// in the input.
	Missing []*EntityResult `protobuf:"bytes,2,rep,name=missing" json:"missing,omitempty"`
	// A list of keys that were not looked up due to resource constraints. The
	// order of results in this field is undefined and has no relation to the
	// order of the keys in the input.
	Deferred []*Key `protobuf:"bytes,3,rep,name=deferred" json:"deferred,omitempty"`
}

func (m *LookupResponse) Reset()                    { *m = LookupResponse{} }
func (m *LookupResponse) String() string            { return proto.CompactTextString(m) }
func (*LookupResponse) ProtoMessage()               {}
func (*LookupResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *LookupResponse) GetFound() []*EntityResult {
	if m != nil {
		return m.Found
	}
	return nil
}

func (m *LookupResponse) GetMissing() []*EntityResult {
	if m != nil {
		return m.Missing
	}
	return nil
}

func (m *LookupResponse) GetDeferred() []*Key {
	if m != nil {
		return m.Deferred
	}
	return nil
}

// The request for [Datastore.RunQuery][google.datastore.v1.Datastore.RunQuery].
type RunQueryRequest struct {
	// The ID of the project against which to make the request.
	ProjectId string `protobuf:"bytes,8,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// Entities are partitioned into subsets, identified by a partition ID.
	// Queries are scoped to a single partition.
	// This partition ID is normalized with the standard default context
	// partition ID.
	PartitionId *PartitionId `protobuf:"bytes,2,opt,name=partition_id,json=partitionId" json:"partition_id,omitempty"`
	// The options for this query.
	ReadOptions *ReadOptions `protobuf:"bytes,1,opt,name=read_options,json=readOptions" json:"read_options,omitempty"`
	// The type of query.
	//
	// Types that are valid to be assigned to QueryType:
	//	*RunQueryRequest_Query
	//	*RunQueryRequest_GqlQuery
	QueryType isRunQueryRequest_QueryType `protobuf_oneof:"query_type"`
}

func (m *RunQueryRequest) Reset()                    { *m = RunQueryRequest{} }
func (m *RunQueryRequest) String() string            { return proto.CompactTextString(m) }
func (*RunQueryRequest) ProtoMessage()               {}
func (*RunQueryRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

type isRunQueryRequest_QueryType interface {
	isRunQueryRequest_QueryType()
}

type RunQueryRequest_Query struct {
	Query *Query `protobuf:"bytes,3,opt,name=query,oneof"`
}
type RunQueryRequest_GqlQuery struct {
	GqlQuery *GqlQuery `protobuf:"bytes,7,opt,name=gql_query,json=gqlQuery,oneof"`
}

func (*RunQueryRequest_Query) isRunQueryRequest_QueryType()    {}
func (*RunQueryRequest_GqlQuery) isRunQueryRequest_QueryType() {}

func (m *RunQueryRequest) GetQueryType() isRunQueryRequest_QueryType {
	if m != nil {
		return m.QueryType
	}
	return nil
}

func (m *RunQueryRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *RunQueryRequest) GetPartitionId() *PartitionId {
	if m != nil {
		return m.PartitionId
	}
	return nil
}

func (m *RunQueryRequest) GetReadOptions() *ReadOptions {
	if m != nil {
		return m.ReadOptions
	}
	return nil
}

func (m *RunQueryRequest) GetQuery() *Query {
	if x, ok := m.GetQueryType().(*RunQueryRequest_Query); ok {
		return x.Query
	}
	return nil
}

func (m *RunQueryRequest) GetGqlQuery() *GqlQuery {
	if x, ok := m.GetQueryType().(*RunQueryRequest_GqlQuery); ok {
		return x.GqlQuery
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*RunQueryRequest) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _RunQueryRequest_OneofMarshaler, _RunQueryRequest_OneofUnmarshaler, _RunQueryRequest_OneofSizer, []interface{}{
		(*RunQueryRequest_Query)(nil),
		(*RunQueryRequest_GqlQuery)(nil),
	}
}

func _RunQueryRequest_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*RunQueryRequest)
	// query_type
	switch x := m.QueryType.(type) {
	case *RunQueryRequest_Query:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Query); err != nil {
			return err
		}
	case *RunQueryRequest_GqlQuery:
		b.EncodeVarint(7<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.GqlQuery); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("RunQueryRequest.QueryType has unexpected type %T", x)
	}
	return nil
}

func _RunQueryRequest_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*RunQueryRequest)
	switch tag {
	case 3: // query_type.query
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Query)
		err := b.DecodeMessage(msg)
		m.QueryType = &RunQueryRequest_Query{msg}
		return true, err
	case 7: // query_type.gql_query
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(GqlQuery)
		err := b.DecodeMessage(msg)
		m.QueryType = &RunQueryRequest_GqlQuery{msg}
		return true, err
	default:
		return false, nil
	}
}

func _RunQueryRequest_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*RunQueryRequest)
	// query_type
	switch x := m.QueryType.(type) {
	case *RunQueryRequest_Query:
		s := proto.Size(x.Query)
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RunQueryRequest_GqlQuery:
		s := proto.Size(x.GqlQuery)
		n += proto.SizeVarint(7<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// The response for [Datastore.RunQuery][google.datastore.v1.Datastore.RunQuery].
type RunQueryResponse struct {
	// A batch of query results (always present).
	Batch *QueryResultBatch `protobuf:"bytes,1,opt,name=batch" json:"batch,omitempty"`
	// The parsed form of the `GqlQuery` from the request, if it was set.
	Query *Query `protobuf:"bytes,2,opt,name=query" json:"query,omitempty"`
}

func (m *RunQueryResponse) Reset()                    { *m = RunQueryResponse{} }
func (m *RunQueryResponse) String() string            { return proto.CompactTextString(m) }
func (*RunQueryResponse) ProtoMessage()               {}
func (*RunQueryResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *RunQueryResponse) GetBatch() *QueryResultBatch {
	if m != nil {
		return m.Batch
	}
	return nil
}

func (m *RunQueryResponse) GetQuery() *Query {
	if m != nil {
		return m.Query
	}
	return nil
}

// The request for [Datastore.BeginTransaction][google.datastore.v1.Datastore.BeginTransaction].
type BeginTransactionRequest struct {
	// The ID of the project against which to make the request.
	ProjectId string `protobuf:"bytes,8,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// Options for a new transaction.
	TransactionOptions *TransactionOptions `protobuf:"bytes,10,opt,name=transaction_options,json=transactionOptions" json:"transaction_options,omitempty"`
}

func (m *BeginTransactionRequest) Reset()                    { *m = BeginTransactionRequest{} }
func (m *BeginTransactionRequest) String() string            { return proto.CompactTextString(m) }
func (*BeginTransactionRequest) ProtoMessage()               {}
func (*BeginTransactionRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *BeginTransactionRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *BeginTransactionRequest) GetTransactionOptions() *TransactionOptions {
	if m != nil {
		return m.TransactionOptions
	}
	return nil
}

// The response for [Datastore.BeginTransaction][google.datastore.v1.Datastore.BeginTransaction].
type BeginTransactionResponse struct {
	// The transaction identifier (always present).
	Transaction []byte `protobuf:"bytes,1,opt,name=transaction,proto3" json:"transaction,omitempty"`
}

func (m *BeginTransactionResponse) Reset()                    { *m = BeginTransactionResponse{} }
func (m *BeginTransactionResponse) String() string            { return proto.CompactTextString(m) }
func (*BeginTransactionResponse) ProtoMessage()               {}
func (*BeginTransactionResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

func (m *BeginTransactionResponse) GetTransaction() []byte {
	if m != nil {
		return m.Transaction
	}
	return nil
}

// The request for [Datastore.Rollback][google.datastore.v1.Datastore.Rollback].
type RollbackRequest struct {
	// The ID of the project against which to make the request.
	ProjectId string `protobuf:"bytes,8,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// The transaction identifier, returned by a call to
	// [Datastore.BeginTransaction][google.datastore.v1.Datastore.BeginTransaction].
	Transaction []byte `protobuf:"bytes,1,opt,name=transaction,proto3" json:"transaction,omitempty"`
}

func (m *RollbackRequest) Reset()                    { *m = RollbackRequest{} }
func (m *RollbackRequest) String() string            { return proto.CompactTextString(m) }
func (*RollbackRequest) ProtoMessage()               {}
func (*RollbackRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *RollbackRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *RollbackRequest) GetTransaction() []byte {
	if m != nil {
		return m.Transaction
	}
	return nil
}

// The response for [Datastore.Rollback][google.datastore.v1.Datastore.Rollback].
// (an empty message).
type RollbackResponse struct {
}

func (m *RollbackResponse) Reset()                    { *m = RollbackResponse{} }
func (m *RollbackResponse) String() string            { return proto.CompactTextString(m) }
func (*RollbackResponse) ProtoMessage()               {}
func (*RollbackResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

// The request for [Datastore.Commit][google.datastore.v1.Datastore.Commit].
type CommitRequest struct {
	// The ID of the project against which to make the request.
	ProjectId string `protobuf:"bytes,8,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// The type of commit to perform. Defaults to `TRANSACTIONAL`.
	Mode CommitRequest_Mode `protobuf:"varint,5,opt,name=mode,enum=google.datastore.v1.CommitRequest_Mode" json:"mode,omitempty"`
	// Must be set when mode is `TRANSACTIONAL`.
	//
	// Types that are valid to be assigned to TransactionSelector:
	//	*CommitRequest_Transaction
	TransactionSelector isCommitRequest_TransactionSelector `protobuf_oneof:"transaction_selector"`
	// The mutations to perform.
	//
	// When mode is `TRANSACTIONAL`, mutations affecting a single entity are
	// applied in order. The following sequences of mutations affecting a single
	// entity are not permitted in a single `Commit` request:
	//
	// - `insert` followed by `insert`
	// - `update` followed by `insert`
	// - `upsert` followed by `insert`
	// - `delete` followed by `update`
	//
	// When mode is `NON_TRANSACTIONAL`, no two mutations may affect a single
	// entity.
	Mutations []*Mutation `protobuf:"bytes,6,rep,name=mutations" json:"mutations,omitempty"`
}

func (m *CommitRequest) Reset()                    { *m = CommitRequest{} }
func (m *CommitRequest) String() string            { return proto.CompactTextString(m) }
func (*CommitRequest) ProtoMessage()               {}
func (*CommitRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

type isCommitRequest_TransactionSelector interface {
	isCommitRequest_TransactionSelector()
}

type CommitRequest_Transaction struct {
	Transaction []byte `protobuf:"bytes,1,opt,name=transaction,proto3,oneof"`
}

func (*CommitRequest_Transaction) isCommitRequest_TransactionSelector() {}

func (m *CommitRequest) GetTransactionSelector() isCommitRequest_TransactionSelector {
	if m != nil {
		return m.TransactionSelector
	}
	return nil
}

func (m *CommitRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *CommitRequest) GetMode() CommitRequest_Mode {
	if m != nil {
		return m.Mode
	}
	return CommitRequest_MODE_UNSPECIFIED
}

func (m *CommitRequest) GetTransaction() []byte {
	if x, ok := m.GetTransactionSelector().(*CommitRequest_Transaction); ok {
		return x.Transaction
	}
	return nil
}

func (m *CommitRequest) GetMutations() []*Mutation {
	if m != nil {
		return m.Mutations
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*CommitRequest) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _CommitRequest_OneofMarshaler, _CommitRequest_OneofUnmarshaler, _CommitRequest_OneofSizer, []interface{}{
		(*CommitRequest_Transaction)(nil),
	}
}

func _CommitRequest_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*CommitRequest)
	// transaction_selector
	switch x := m.TransactionSelector.(type) {
	case *CommitRequest_Transaction:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.Transaction)
	case nil:
	default:
		return fmt.Errorf("CommitRequest.TransactionSelector has unexpected type %T", x)
	}
	return nil
}

func _CommitRequest_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*CommitRequest)
	switch tag {
	case 1: // transaction_selector.transaction
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.TransactionSelector = &CommitRequest_Transaction{x}
		return true, err
	default:
		return false, nil
	}
}

func _CommitRequest_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*CommitRequest)
	// transaction_selector
	switch x := m.TransactionSelector.(type) {
	case *CommitRequest_Transaction:
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.Transaction)))
		n += len(x.Transaction)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// The response for [Datastore.Commit][google.datastore.v1.Datastore.Commit].
type CommitResponse struct {
	// The result of performing the mutations.
	// The i-th mutation result corresponds to the i-th mutation in the request.
	MutationResults []*MutationResult `protobuf:"bytes,3,rep,name=mutation_results,json=mutationResults" json:"mutation_results,omitempty"`
	// The number of index entries updated during the commit, or zero if none were
	// updated.
	IndexUpdates int32 `protobuf:"varint,4,opt,name=index_updates,json=indexUpdates" json:"index_updates,omitempty"`
}

func (m *CommitResponse) Reset()                    { *m = CommitResponse{} }
func (m *CommitResponse) String() string            { return proto.CompactTextString(m) }
func (*CommitResponse) ProtoMessage()               {}
func (*CommitResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

func (m *CommitResponse) GetMutationResults() []*MutationResult {
	if m != nil {
		return m.MutationResults
	}
	return nil
}

func (m *CommitResponse) GetIndexUpdates() int32 {
	if m != nil {
		return m.IndexUpdates
	}
	return 0
}

// The request for [Datastore.AllocateIds][google.datastore.v1.Datastore.AllocateIds].
type AllocateIdsRequest struct {
	// The ID of the project against which to make the request.
	ProjectId string `protobuf:"bytes,8,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// A list of keys with incomplete key paths for which to allocate IDs.
	// No key may be reserved/read-only.
	Keys []*Key `protobuf:"bytes,1,rep,name=keys" json:"keys,omitempty"`
}

func (m *AllocateIdsRequest) Reset()                    { *m = AllocateIdsRequest{} }
func (m *AllocateIdsRequest) String() string            { return proto.CompactTextString(m) }
func (*AllocateIdsRequest) ProtoMessage()               {}
func (*AllocateIdsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

func (m *AllocateIdsRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *AllocateIdsRequest) GetKeys() []*Key {
	if m != nil {
		return m.Keys
	}
	return nil
}

// The response for [Datastore.AllocateIds][google.datastore.v1.Datastore.AllocateIds].
type AllocateIdsResponse struct {
	// The keys specified in the request (in the same order), each with
	// its key path completed with a newly allocated ID.
	Keys []*Key `protobuf:"bytes,1,rep,name=keys" json:"keys,omitempty"`
}

func (m *AllocateIdsResponse) Reset()                    { *m = AllocateIdsResponse{} }
func (m *AllocateIdsResponse) String() string            { return proto.CompactTextString(m) }
func (*AllocateIdsResponse) ProtoMessage()               {}
func (*AllocateIdsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

func (m *AllocateIdsResponse) GetKeys() []*Key {
	if m != nil {
		return m.Keys
	}
	return nil
}

// A mutation to apply to an entity.
type Mutation struct {
	// The mutation operation.
	//
	// For `insert`, `update`, and `upsert`:
	// - The entity's key must not be reserved/read-only.
	// - No property in the entity may have a reserved name,
	//   not even a property in an entity in a value.
	// - No value in the entity may have meaning 18,
	//   not even a value in an entity in another value.
	//
	// Types that are valid to be assigned to Operation:
	//	*Mutation_Insert
	//	*Mutation_Update
	//	*Mutation_Upsert
	//	*Mutation_Delete
	Operation isMutation_Operation `protobuf_oneof:"operation"`
	// When set, the server will detect whether or not this mutation conflicts
	// with the current version of the entity on the server. Conflicting mutations
	// are not applied, and are marked as such in MutationResult.
	//
	// Types that are valid to be assigned to ConflictDetectionStrategy:
	//	*Mutation_BaseVersion
	ConflictDetectionStrategy isMutation_ConflictDetectionStrategy `protobuf_oneof:"conflict_detection_strategy"`
}

func (m *Mutation) Reset()                    { *m = Mutation{} }
func (m *Mutation) String() string            { return proto.CompactTextString(m) }
func (*Mutation) ProtoMessage()               {}
func (*Mutation) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{12} }

type isMutation_Operation interface {
	isMutation_Operation()
}
type isMutation_ConflictDetectionStrategy interface {
	isMutation_ConflictDetectionStrategy()
}

type Mutation_Insert struct {
	Insert *Entity `protobuf:"bytes,4,opt,name=insert,oneof"`
}
type Mutation_Update struct {
	Update *Entity `protobuf:"bytes,5,opt,name=update,oneof"`
}
type Mutation_Upsert struct {
	Upsert *Entity `protobuf:"bytes,6,opt,name=upsert,oneof"`
}
type Mutation_Delete struct {
	Delete *Key `protobuf:"bytes,7,opt,name=delete,oneof"`
}
type Mutation_BaseVersion struct {
	BaseVersion int64 `protobuf:"varint,8,opt,name=base_version,json=baseVersion,oneof"`
}

func (*Mutation_Insert) isMutation_Operation()                      {}
func (*Mutation_Update) isMutation_Operation()                      {}
func (*Mutation_Upsert) isMutation_Operation()                      {}
func (*Mutation_Delete) isMutation_Operation()                      {}
func (*Mutation_BaseVersion) isMutation_ConflictDetectionStrategy() {}

func (m *Mutation) GetOperation() isMutation_Operation {
	if m != nil {
		return m.Operation
	}
	return nil
}
func (m *Mutation) GetConflictDetectionStrategy() isMutation_ConflictDetectionStrategy {
	if m != nil {
		return m.ConflictDetectionStrategy
	}
	return nil
}

func (m *Mutation) GetInsert() *Entity {
	if x, ok := m.GetOperation().(*Mutation_Insert); ok {
		return x.Insert
	}
	return nil
}

func (m *Mutation) GetUpdate() *Entity {
	if x, ok := m.GetOperation().(*Mutation_Update); ok {
		return x.Update
	}
	return nil
}

func (m *Mutation) GetUpsert() *Entity {
	if x, ok := m.GetOperation().(*Mutation_Upsert); ok {
		return x.Upsert
	}
	return nil
}

func (m *Mutation) GetDelete() *Key {
	if x, ok := m.GetOperation().(*Mutation_Delete); ok {
		return x.Delete
	}
	return nil
}

func (m *Mutation) GetBaseVersion() int64 {
	if x, ok := m.GetConflictDetectionStrategy().(*Mutation_BaseVersion); ok {
		return x.BaseVersion
	}
	return 0
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Mutation) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Mutation_OneofMarshaler, _Mutation_OneofUnmarshaler, _Mutation_OneofSizer, []interface{}{
		(*Mutation_Insert)(nil),
		(*Mutation_Update)(nil),
		(*Mutation_Upsert)(nil),
		(*Mutation_Delete)(nil),
		(*Mutation_BaseVersion)(nil),
	}
}

func _Mutation_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Mutation)
	// operation
	switch x := m.Operation.(type) {
	case *Mutation_Insert:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Insert); err != nil {
			return err
		}
	case *Mutation_Update:
		b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Update); err != nil {
			return err
		}
	case *Mutation_Upsert:
		b.EncodeVarint(6<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Upsert); err != nil {
			return err
		}
	case *Mutation_Delete:
		b.EncodeVarint(7<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Delete); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Mutation.Operation has unexpected type %T", x)
	}
	// conflict_detection_strategy
	switch x := m.ConflictDetectionStrategy.(type) {
	case *Mutation_BaseVersion:
		b.EncodeVarint(8<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.BaseVersion))
	case nil:
	default:
		return fmt.Errorf("Mutation.ConflictDetectionStrategy has unexpected type %T", x)
	}
	return nil
}

func _Mutation_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Mutation)
	switch tag {
	case 4: // operation.insert
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Entity)
		err := b.DecodeMessage(msg)
		m.Operation = &Mutation_Insert{msg}
		return true, err
	case 5: // operation.update
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Entity)
		err := b.DecodeMessage(msg)
		m.Operation = &Mutation_Update{msg}
		return true, err
	case 6: // operation.upsert
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Entity)
		err := b.DecodeMessage(msg)
		m.Operation = &Mutation_Upsert{msg}
		return true, err
	case 7: // operation.delete
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Key)
		err := b.DecodeMessage(msg)
		m.Operation = &Mutation_Delete{msg}
		return true, err
	case 8: // conflict_detection_strategy.base_version
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.ConflictDetectionStrategy = &Mutation_BaseVersion{int64(x)}
		return true, err
	default:
		return false, nil
	}
}

func _Mutation_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Mutation)
	// operation
	switch x := m.Operation.(type) {
	case *Mutation_Insert:
		s := proto.Size(x.Insert)
		n += proto.SizeVarint(4<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Mutation_Update:
		s := proto.Size(x.Update)
		n += proto.SizeVarint(5<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Mutation_Upsert:
		s := proto.Size(x.Upsert)
		n += proto.SizeVarint(6<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Mutation_Delete:
		s := proto.Size(x.Delete)
		n += proto.SizeVarint(7<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	// conflict_detection_strategy
	switch x := m.ConflictDetectionStrategy.(type) {
	case *Mutation_BaseVersion:
		n += proto.SizeVarint(8<<3 | proto.WireVarint)
		n += proto.SizeVarint(uint64(x.BaseVersion))
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// The result of applying a mutation.
type MutationResult struct {
	// The automatically allocated key.
	// Set only when the mutation allocated a key.
	Key *Key `protobuf:"bytes,3,opt,name=key" json:"key,omitempty"`
	// The version of the entity on the server after processing the mutation. If
	// the mutation doesn't change anything on the server, then the version will
	// be the version of the current entity or, if no entity is present, a version
	// that is strictly greater than the version of any previous entity and less
	// than the version of any possible future entity.
	Version int64 `protobuf:"varint,4,opt,name=version" json:"version,omitempty"`
	// Whether a conflict was detected for this mutation. Always false when a
	// conflict detection strategy field is not set in the mutation.
	ConflictDetected bool `protobuf:"varint,5,opt,name=conflict_detected,json=conflictDetected" json:"conflict_detected,omitempty"`
}

func (m *MutationResult) Reset()                    { *m = MutationResult{} }
func (m *MutationResult) String() string            { return proto.CompactTextString(m) }
func (*MutationResult) ProtoMessage()               {}
func (*MutationResult) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{13} }

func (m *MutationResult) GetKey() *Key {
	if m != nil {
		return m.Key
	}
	return nil
}

func (m *MutationResult) GetVersion() int64 {
	if m != nil {
		return m.Version
	}
	return 0
}

func (m *MutationResult) GetConflictDetected() bool {
	if m != nil {
		return m.ConflictDetected
	}
	return false
}

// The options shared by read requests.
type ReadOptions struct {
	// If not specified, lookups and ancestor queries default to
	// `read_consistency`=`STRONG`, global queries default to
	// `read_consistency`=`EVENTUAL`.
	//
	// Types that are valid to be assigned to ConsistencyType:
	//	*ReadOptions_ReadConsistency_
	//	*ReadOptions_Transaction
	ConsistencyType isReadOptions_ConsistencyType `protobuf_oneof:"consistency_type"`
}

func (m *ReadOptions) Reset()                    { *m = ReadOptions{} }
func (m *ReadOptions) String() string            { return proto.CompactTextString(m) }
func (*ReadOptions) ProtoMessage()               {}
func (*ReadOptions) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{14} }

type isReadOptions_ConsistencyType interface {
	isReadOptions_ConsistencyType()
}

type ReadOptions_ReadConsistency_ struct {
	ReadConsistency ReadOptions_ReadConsistency `protobuf:"varint,1,opt,name=read_consistency,json=readConsistency,enum=google.datastore.v1.ReadOptions_ReadConsistency,oneof"`
}
type ReadOptions_Transaction struct {
	Transaction []byte `protobuf:"bytes,2,opt,name=transaction,proto3,oneof"`
}

func (*ReadOptions_ReadConsistency_) isReadOptions_ConsistencyType() {}
func (*ReadOptions_Transaction) isReadOptions_ConsistencyType()      {}

func (m *ReadOptions) GetConsistencyType() isReadOptions_ConsistencyType {
	if m != nil {
		return m.ConsistencyType
	}
	return nil
}

func (m *ReadOptions) GetReadConsistency() ReadOptions_ReadConsistency {
	if x, ok := m.GetConsistencyType().(*ReadOptions_ReadConsistency_); ok {
		return x.ReadConsistency
	}
	return ReadOptions_READ_CONSISTENCY_UNSPECIFIED
}

func (m *ReadOptions) GetTransaction() []byte {
	if x, ok := m.GetConsistencyType().(*ReadOptions_Transaction); ok {
		return x.Transaction
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*ReadOptions) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _ReadOptions_OneofMarshaler, _ReadOptions_OneofUnmarshaler, _ReadOptions_OneofSizer, []interface{}{
		(*ReadOptions_ReadConsistency_)(nil),
		(*ReadOptions_Transaction)(nil),
	}
}

func _ReadOptions_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*ReadOptions)
	// consistency_type
	switch x := m.ConsistencyType.(type) {
	case *ReadOptions_ReadConsistency_:
		b.EncodeVarint(1<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.ReadConsistency))
	case *ReadOptions_Transaction:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.Transaction)
	case nil:
	default:
		return fmt.Errorf("ReadOptions.ConsistencyType has unexpected type %T", x)
	}
	return nil
}

func _ReadOptions_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*ReadOptions)
	switch tag {
	case 1: // consistency_type.read_consistency
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.ConsistencyType = &ReadOptions_ReadConsistency_{ReadOptions_ReadConsistency(x)}
		return true, err
	case 2: // consistency_type.transaction
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.ConsistencyType = &ReadOptions_Transaction{x}
		return true, err
	default:
		return false, nil
	}
}

func _ReadOptions_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*ReadOptions)
	// consistency_type
	switch x := m.ConsistencyType.(type) {
	case *ReadOptions_ReadConsistency_:
		n += proto.SizeVarint(1<<3 | proto.WireVarint)
		n += proto.SizeVarint(uint64(x.ReadConsistency))
	case *ReadOptions_Transaction:
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.Transaction)))
		n += len(x.Transaction)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Options for beginning a new transaction.
type TransactionOptions struct {
	// The `mode` of the transaction, indicating whether write operations are
	// supported.
	//
	// Types that are valid to be assigned to Mode:
	//	*TransactionOptions_ReadWrite_
	//	*TransactionOptions_ReadOnly_
	Mode isTransactionOptions_Mode `protobuf_oneof:"mode"`
}

func (m *TransactionOptions) Reset()                    { *m = TransactionOptions{} }
func (m *TransactionOptions) String() string            { return proto.CompactTextString(m) }
func (*TransactionOptions) ProtoMessage()               {}
func (*TransactionOptions) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{15} }

type isTransactionOptions_Mode interface {
	isTransactionOptions_Mode()
}

type TransactionOptions_ReadWrite_ struct {
	ReadWrite *TransactionOptions_ReadWrite `protobuf:"bytes,1,opt,name=read_write,json=readWrite,oneof"`
}
type TransactionOptions_ReadOnly_ struct {
	ReadOnly *TransactionOptions_ReadOnly `protobuf:"bytes,2,opt,name=read_only,json=readOnly,oneof"`
}

func (*TransactionOptions_ReadWrite_) isTransactionOptions_Mode() {}
func (*TransactionOptions_ReadOnly_) isTransactionOptions_Mode()  {}

func (m *TransactionOptions) GetMode() isTransactionOptions_Mode {
	if m != nil {
		return m.Mode
	}
	return nil
}

func (m *TransactionOptions) GetReadWrite() *TransactionOptions_ReadWrite {
	if x, ok := m.GetMode().(*TransactionOptions_ReadWrite_); ok {
		return x.ReadWrite
	}
	return nil
}

func (m *TransactionOptions) GetReadOnly() *TransactionOptions_ReadOnly {
	if x, ok := m.GetMode().(*TransactionOptions_ReadOnly_); ok {
		return x.ReadOnly
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*TransactionOptions) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _TransactionOptions_OneofMarshaler, _TransactionOptions_OneofUnmarshaler, _TransactionOptions_OneofSizer, []interface{}{
		(*TransactionOptions_ReadWrite_)(nil),
		(*TransactionOptions_ReadOnly_)(nil),
	}
}

func _TransactionOptions_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*TransactionOptions)
	// mode
	switch x := m.Mode.(type) {
	case *TransactionOptions_ReadWrite_:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ReadWrite); err != nil {
			return err
		}
	case *TransactionOptions_ReadOnly_:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ReadOnly); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("TransactionOptions.Mode has unexpected type %T", x)
	}
	return nil
}

func _TransactionOptions_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*TransactionOptions)
	switch tag {
	case 1: // mode.read_write
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(TransactionOptions_ReadWrite)
		err := b.DecodeMessage(msg)
		m.Mode = &TransactionOptions_ReadWrite_{msg}
		return true, err
	case 2: // mode.read_only
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(TransactionOptions_ReadOnly)
		err := b.DecodeMessage(msg)
		m.Mode = &TransactionOptions_ReadOnly_{msg}
		return true, err
	default:
		return false, nil
	}
}

func _TransactionOptions_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*TransactionOptions)
	// mode
	switch x := m.Mode.(type) {
	case *TransactionOptions_ReadWrite_:
		s := proto.Size(x.ReadWrite)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *TransactionOptions_ReadOnly_:
		s := proto.Size(x.ReadOnly)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Options specific to read / write transactions.
type TransactionOptions_ReadWrite struct {
	// The transaction identifier of the transaction being retried.
	PreviousTransaction []byte `protobuf:"bytes,1,opt,name=previous_transaction,json=previousTransaction,proto3" json:"previous_transaction,omitempty"`
}

func (m *TransactionOptions_ReadWrite) Reset()         { *m = TransactionOptions_ReadWrite{} }
func (m *TransactionOptions_ReadWrite) String() string { return proto.CompactTextString(m) }
func (*TransactionOptions_ReadWrite) ProtoMessage()    {}
func (*TransactionOptions_ReadWrite) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{15, 0}
}

func (m *TransactionOptions_ReadWrite) GetPreviousTransaction() []byte {
	if m != nil {
		return m.PreviousTransaction
	}
	return nil
}

// Options specific to read-only transactions.
type TransactionOptions_ReadOnly struct {
}

func (m *TransactionOptions_ReadOnly) Reset()                    { *m = TransactionOptions_ReadOnly{} }
func (m *TransactionOptions_ReadOnly) String() string            { return proto.CompactTextString(m) }
func (*TransactionOptions_ReadOnly) ProtoMessage()               {}
func (*TransactionOptions_ReadOnly) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{15, 1} }

func init() {
	proto.RegisterType((*LookupRequest)(nil), "google.datastore.v1.LookupRequest")
	proto.RegisterType((*LookupResponse)(nil), "google.datastore.v1.LookupResponse")
	proto.RegisterType((*RunQueryRequest)(nil), "google.datastore.v1.RunQueryRequest")
	proto.RegisterType((*RunQueryResponse)(nil), "google.datastore.v1.RunQueryResponse")
	proto.RegisterType((*BeginTransactionRequest)(nil), "google.datastore.v1.BeginTransactionRequest")
	proto.RegisterType((*BeginTransactionResponse)(nil), "google.datastore.v1.BeginTransactionResponse")
	proto.RegisterType((*RollbackRequest)(nil), "google.datastore.v1.RollbackRequest")
	proto.RegisterType((*RollbackResponse)(nil), "google.datastore.v1.RollbackResponse")
	proto.RegisterType((*CommitRequest)(nil), "google.datastore.v1.CommitRequest")
	proto.RegisterType((*CommitResponse)(nil), "google.datastore.v1.CommitResponse")
	proto.RegisterType((*AllocateIdsRequest)(nil), "google.datastore.v1.AllocateIdsRequest")
	proto.RegisterType((*AllocateIdsResponse)(nil), "google.datastore.v1.AllocateIdsResponse")
	proto.RegisterType((*Mutation)(nil), "google.datastore.v1.Mutation")
	proto.RegisterType((*MutationResult)(nil), "google.datastore.v1.MutationResult")
	proto.RegisterType((*ReadOptions)(nil), "google.datastore.v1.ReadOptions")
	proto.RegisterType((*TransactionOptions)(nil), "google.datastore.v1.TransactionOptions")
	proto.RegisterType((*TransactionOptions_ReadWrite)(nil), "google.datastore.v1.TransactionOptions.ReadWrite")
	proto.RegisterType((*TransactionOptions_ReadOnly)(nil), "google.datastore.v1.TransactionOptions.ReadOnly")
	proto.RegisterEnum("google.datastore.v1.CommitRequest_Mode", CommitRequest_Mode_name, CommitRequest_Mode_value)
	proto.RegisterEnum("google.datastore.v1.ReadOptions_ReadConsistency", ReadOptions_ReadConsistency_name, ReadOptions_ReadConsistency_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for Datastore service

type DatastoreClient interface {
	// Looks up entities by key.
	Lookup(ctx context.Context, in *LookupRequest, opts ...grpc.CallOption) (*LookupResponse, error)
	// Queries for entities.
	RunQuery(ctx context.Context, in *RunQueryRequest, opts ...grpc.CallOption) (*RunQueryResponse, error)
	// Begins a new transaction.
	BeginTransaction(ctx context.Context, in *BeginTransactionRequest, opts ...grpc.CallOption) (*BeginTransactionResponse, error)
	// Commits a transaction, optionally creating, deleting or modifying some
	// entities.
	Commit(ctx context.Context, in *CommitRequest, opts ...grpc.CallOption) (*CommitResponse, error)
	// Rolls back a transaction.
	Rollback(ctx context.Context, in *RollbackRequest, opts ...grpc.CallOption) (*RollbackResponse, error)
	// Allocates IDs for the given keys, which is useful for referencing an entity
	// before it is inserted.
	AllocateIds(ctx context.Context, in *AllocateIdsRequest, opts ...grpc.CallOption) (*AllocateIdsResponse, error)
}

type datastoreClient struct {
	cc *grpc.ClientConn
}

func NewDatastoreClient(cc *grpc.ClientConn) DatastoreClient {
	return &datastoreClient{cc}
}

func (c *datastoreClient) Lookup(ctx context.Context, in *LookupRequest, opts ...grpc.CallOption) (*LookupResponse, error) {
	out := new(LookupResponse)
	err := grpc.Invoke(ctx, "/google.datastore.v1.Datastore/Lookup", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datastoreClient) RunQuery(ctx context.Context, in *RunQueryRequest, opts ...grpc.CallOption) (*RunQueryResponse, error) {
	out := new(RunQueryResponse)
	err := grpc.Invoke(ctx, "/google.datastore.v1.Datastore/RunQuery", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datastoreClient) BeginTransaction(ctx context.Context, in *BeginTransactionRequest, opts ...grpc.CallOption) (*BeginTransactionResponse, error) {
	out := new(BeginTransactionResponse)
	err := grpc.Invoke(ctx, "/google.datastore.v1.Datastore/BeginTransaction", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datastoreClient) Commit(ctx context.Context, in *CommitRequest, opts ...grpc.CallOption) (*CommitResponse, error) {
	out := new(CommitResponse)
	err := grpc.Invoke(ctx, "/google.datastore.v1.Datastore/Commit", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datastoreClient) Rollback(ctx context.Context, in *RollbackRequest, opts ...grpc.CallOption) (*RollbackResponse, error) {
	out := new(RollbackResponse)
	err := grpc.Invoke(ctx, "/google.datastore.v1.Datastore/Rollback", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datastoreClient) AllocateIds(ctx context.Context, in *AllocateIdsRequest, opts ...grpc.CallOption) (*AllocateIdsResponse, error) {
	out := new(AllocateIdsResponse)
	err := grpc.Invoke(ctx, "/google.datastore.v1.Datastore/AllocateIds", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for Datastore service

type DatastoreServer interface {
	// Looks up entities by key.
	Lookup(context.Context, *LookupRequest) (*LookupResponse, error)
	// Queries for entities.
	RunQuery(context.Context, *RunQueryRequest) (*RunQueryResponse, error)
	// Begins a new transaction.
	BeginTransaction(context.Context, *BeginTransactionRequest) (*BeginTransactionResponse, error)
	// Commits a transaction, optionally creating, deleting or modifying some
	// entities.
	Commit(context.Context, *CommitRequest) (*CommitResponse, error)
	// Rolls back a transaction.
	Rollback(context.Context, *RollbackRequest) (*RollbackResponse, error)
	// Allocates IDs for the given keys, which is useful for referencing an entity
	// before it is inserted.
	AllocateIds(context.Context, *AllocateIdsRequest) (*AllocateIdsResponse, error)
}

func RegisterDatastoreServer(s *grpc.Server, srv DatastoreServer) {
	s.RegisterService(&_Datastore_serviceDesc, srv)
}

func _Datastore_Lookup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LookupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatastoreServer).Lookup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.datastore.v1.Datastore/Lookup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatastoreServer).Lookup(ctx, req.(*LookupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Datastore_RunQuery_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RunQueryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatastoreServer).RunQuery(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.datastore.v1.Datastore/RunQuery",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatastoreServer).RunQuery(ctx, req.(*RunQueryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Datastore_BeginTransaction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BeginTransactionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatastoreServer).BeginTransaction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.datastore.v1.Datastore/BeginTransaction",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatastoreServer).BeginTransaction(ctx, req.(*BeginTransactionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Datastore_Commit_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CommitRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatastoreServer).Commit(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.datastore.v1.Datastore/Commit",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatastoreServer).Commit(ctx, req.(*CommitRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Datastore_Rollback_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RollbackRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatastoreServer).Rollback(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.datastore.v1.Datastore/Rollback",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatastoreServer).Rollback(ctx, req.(*RollbackRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Datastore_AllocateIds_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AllocateIdsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatastoreServer).AllocateIds(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.datastore.v1.Datastore/AllocateIds",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatastoreServer).AllocateIds(ctx, req.(*AllocateIdsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Datastore_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.datastore.v1.Datastore",
	HandlerType: (*DatastoreServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Lookup",
			Handler:    _Datastore_Lookup_Handler,
		},
		{
			MethodName: "RunQuery",
			Handler:    _Datastore_RunQuery_Handler,
		},
		{
			MethodName: "BeginTransaction",
			Handler:    _Datastore_BeginTransaction_Handler,
		},
		{
			MethodName: "Commit",
			Handler:    _Datastore_Commit_Handler,
		},
		{
			MethodName: "Rollback",
			Handler:    _Datastore_Rollback_Handler,
		},
		{
			MethodName: "AllocateIds",
			Handler:    _Datastore_AllocateIds_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/datastore/v1/datastore.proto",
}

func init() { proto.RegisterFile("google/datastore/v1/datastore.proto", fileDescriptor0) }

var fileDescriptor0 = []byte{
	// 1312 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x57, 0x5f, 0x6f, 0xdb, 0x54,
	0x14, 0xef, 0x4d, 0xdb, 0x2c, 0x39, 0xe9, 0x9f, 0xec, 0x76, 0xb0, 0x90, 0x6d, 0x22, 0xb8, 0x54,
	0xab, 0xba, 0x2d, 0x69, 0x03, 0x13, 0xd2, 0x3a, 0x21, 0x35, 0x69, 0xb6, 0x46, 0xac, 0x49, 0xb9,
	0xed, 0xc6, 0x1f, 0x09, 0x45, 0xae, 0x7d, 0x1b, 0x4c, 0x1d, 0x5f, 0xd7, 0xbe, 0x29, 0x44, 0x88,
	0x49, 0x80, 0xc6, 0x1b, 0x2f, 0xe3, 0x13, 0xf0, 0xc2, 0x03, 0xe2, 0x91, 0x27, 0xc4, 0xb7, 0xe0,
	0x91, 0x57, 0xbe, 0x01, 0x5f, 0x00, 0xf9, 0xfa, 0x3a, 0x89, 0x53, 0xbb, 0xf1, 0x24, 0xde, 0x7c,
	0xaf, 0x7f, 0xbf, 0x73, 0x7e, 0xe7, 0x9c, 0xeb, 0x73, 0xae, 0x61, 0xb5, 0xcb, 0x58, 0xd7, 0xa4,
	0x15, 0x5d, 0xe5, 0xaa, 0xcb, 0x99, 0x43, 0x2b, 0xe7, 0x5b, 0xa3, 0x45, 0xd9, 0x76, 0x18, 0x67,
	0x78, 0xc5, 0x07, 0x95, 0x47, 0xfb, 0xe7, 0x5b, 0xc5, 0x9b, 0x92, 0xa9, 0xda, 0x46, 0x45, 0xb5,
	0x2c, 0xc6, 0x55, 0x6e, 0x30, 0xcb, 0xf5, 0x29, 0xc5, 0x52, 0x94, 0x5d, 0x6a, 0x71, 0x83, 0x0f,
	0x24, 0xe2, 0xcd, 0x28, 0xc4, 0x59, 0x9f, 0x3a, 0x12, 0xa0, 0xfc, 0x8c, 0x60, 0xf1, 0x09, 0x63,
	0xa7, 0x7d, 0x9b, 0xd0, 0xb3, 0x3e, 0x75, 0x39, 0xbe, 0x05, 0x60, 0x3b, 0xec, 0x0b, 0xaa, 0xf1,
	0x8e, 0xa1, 0x17, 0x32, 0x25, 0xb4, 0x9e, 0x25, 0x59, 0xb9, 0xd3, 0xd4, 0x71, 0x1d, 0x16, 0x1c,
	0xaa, 0xea, 0x1d, 0x66, 0x0b, 0x25, 0x05, 0x54, 0x42, 0xeb, 0xb9, 0x6a, 0xa9, 0x1c, 0xa1, 0xbe,
	0x4c, 0xa8, 0xaa, 0xb7, 0x7d, 0x1c, 0xc9, 0x39, 0xa3, 0x05, 0xbe, 0x0b, 0x73, 0xa7, 0x74, 0xe0,
	0x16, 0x66, 0x4b, 0xb3, 0xeb, 0xb9, 0x6a, 0x21, 0x92, 0xfc, 0x01, 0x1d, 0x10, 0x81, 0x52, 0xfe,
	0x44, 0xb0, 0x14, 0x68, 0x74, 0x6d, 0x66, 0xb9, 0x14, 0xbf, 0x07, 0xf3, 0x27, 0xac, 0x6f, 0xe9,
	0x05, 0x24, 0x2c, 0xbc, 0x15, 0x69, 0xa1, 0x21, 0x32, 0x41, 0xa8, 0xdb, 0x37, 0x39, 0xf1, 0xf1,
	0x78, 0x1b, 0xae, 0xf4, 0x0c, 0xd7, 0x35, 0xac, 0x6e, 0x21, 0x95, 0x94, 0x1a, 0x30, 0xf0, 0xbb,
	0x90, 0xd1, 0xe9, 0x09, 0x75, 0x1c, 0xaa, 0x4f, 0x95, 0x3e, 0x44, 0x2a, 0x7f, 0xa4, 0x60, 0x99,
	0xf4, 0xad, 0x0f, 0xbd, 0xac, 0x27, 0x4f, 0xb2, 0xad, 0x3a, 0xdc, 0xf0, 0xb2, 0xe5, 0x01, 0x52,
	0x97, 0x24, 0xf9, 0x20, 0x00, 0x36, 0x75, 0x92, 0xb3, 0x47, 0x8b, 0xff, 0xa7, 0x52, 0x55, 0x98,
	0x17, 0xc7, 0xa5, 0x30, 0x2b, 0xd8, 0xc5, 0x48, 0xb6, 0x08, 0x6d, 0x6f, 0x86, 0xf8, 0x50, 0xfc,
	0x10, 0xb2, 0xdd, 0x33, 0xb3, 0xe3, 0xf3, 0xae, 0x08, 0xde, 0xad, 0x48, 0xde, 0xe3, 0x33, 0x33,
	0xa0, 0x66, 0xba, 0xf2, 0xb9, 0xb6, 0x00, 0x20, 0x98, 0x1d, 0x3e, 0xb0, 0xa9, 0xf2, 0x2d, 0x82,
	0xfc, 0x28, 0x79, 0xb2, 0xfa, 0xdb, 0x30, 0x7f, 0xac, 0x72, 0xed, 0x73, 0x19, 0xd2, 0x5a, 0xbc,
	0x28, 0xbf, 0x82, 0x35, 0x0f, 0x4c, 0x7c, 0x0e, 0xde, 0x0c, 0x22, 0x4a, 0x4d, 0x8b, 0x48, 0xc6,
	0xa3, 0xbc, 0x44, 0x70, 0xbd, 0x46, 0xbb, 0x86, 0x75, 0xe4, 0xa8, 0x96, 0xab, 0x6a, 0x5e, 0x66,
	0x12, 0x16, 0xf2, 0x63, 0x58, 0xe1, 0x23, 0xd2, 0xb0, 0x14, 0x20, 0x5c, 0xdf, 0x8e, 0x74, 0x3d,
	0xe6, 0x24, 0xa8, 0x08, 0xe6, 0x17, 0xf6, 0x94, 0x87, 0x50, 0xb8, 0xa8, 0x49, 0xe6, 0xa7, 0x04,
	0xb9, 0x31, 0x86, 0xc8, 0xd2, 0x02, 0x19, 0xdf, 0x52, 0x08, 0x2c, 0x13, 0x66, 0x9a, 0xc7, 0xaa,
	0x76, 0x9a, 0x30, 0x92, 0xe9, 0x36, 0x31, 0xe4, 0x47, 0x36, 0x7d, 0x25, 0xca, 0x6f, 0x29, 0x58,
	0xac, 0xb3, 0x5e, 0xcf, 0xe0, 0x09, 0xdd, 0x6c, 0xc3, 0x5c, 0x8f, 0xe9, 0xb4, 0x30, 0x5f, 0x42,
	0xeb, 0x4b, 0x31, 0x19, 0x0a, 0x19, 0x2c, 0xef, 0x33, 0x9d, 0x12, 0x41, 0xc2, 0x4a, 0x84, 0xc6,
	0xbd, 0x99, 0x90, 0x4a, 0xbc, 0x0d, 0xd9, 0x5e, 0x5f, 0xb6, 0xd1, 0x42, 0x5a, 0x7c, 0xc4, 0xd1,
	0x87, 0x73, 0x5f, 0xa2, 0xc8, 0x08, 0xaf, 0x3c, 0x82, 0x39, 0xcf, 0x1d, 0xbe, 0x06, 0xf9, 0xfd,
	0xf6, 0x6e, 0xa3, 0xf3, 0xb4, 0x75, 0x78, 0xd0, 0xa8, 0x37, 0x1f, 0x35, 0x1b, 0xbb, 0xf9, 0x19,
	0x7c, 0x15, 0x16, 0x8f, 0xc8, 0x4e, 0xeb, 0x70, 0xa7, 0x7e, 0xd4, 0x6c, 0xb7, 0x76, 0x9e, 0xe4,
	0x11, 0x7e, 0x0d, 0xae, 0xb6, 0xda, 0xad, 0x4e, 0x78, 0x3b, 0x55, 0x7b, 0x1d, 0xae, 0x8d, 0x1f,
	0x0b, 0x97, 0x9a, 0x54, 0xe3, 0xcc, 0x51, 0x5e, 0x20, 0x58, 0x0a, 0xa2, 0x93, 0xb5, 0x6c, 0x41,
	0x3e, 0xf0, 0xdf, 0x71, 0xc4, 0x69, 0x0e, 0xda, 0xe6, 0xea, 0xe5, 0xb2, 0xfd, 0xde, 0xb5, 0xdc,
	0x0b, 0xad, 0x5d, 0xbc, 0x0a, 0x8b, 0x86, 0xa5, 0xd3, 0xaf, 0x3a, 0x7d, 0x5b, 0x57, 0x39, 0x75,
	0x0b, 0x73, 0x25, 0xb4, 0x3e, 0x4f, 0x16, 0xc4, 0xe6, 0x53, 0x7f, 0x4f, 0x51, 0x01, 0xef, 0x98,
	0x26, 0xd3, 0x54, 0x4e, 0x9b, 0xba, 0x9b, 0xb0, 0x74, 0x41, 0x53, 0x47, 0x89, 0x9a, 0x7a, 0x1d,
	0x56, 0x42, 0x2e, 0x64, 0xb8, 0xaf, 0x66, 0xe4, 0xf7, 0x14, 0x64, 0x82, 0x80, 0xf1, 0x7d, 0x48,
	0x1b, 0x96, 0x4b, 0x1d, 0x2e, 0x42, 0xca, 0x55, 0x6f, 0x5c, 0xd2, 0xd9, 0xf7, 0x66, 0x88, 0x04,
	0x7b, 0x34, 0x3f, 0x15, 0xe2, 0xcc, 0x4d, 0xa7, 0xf9, 0x60, 0x9f, 0x26, 0xbc, 0xa5, 0x13, 0xd2,
	0x84, 0xb7, 0x2a, 0xa4, 0x75, 0x6a, 0x52, 0x4e, 0x65, 0x63, 0x8c, 0x8d, 0xd0, 0xe3, 0xf8, 0x48,
	0xbc, 0x0a, 0x0b, 0xc7, 0xaa, 0x4b, 0x3b, 0xe7, 0xd4, 0x71, 0xbd, 0x73, 0xed, 0x65, 0x7e, 0x76,
	0x0f, 0x91, 0x9c, 0xb7, 0xfb, 0xcc, 0xdf, 0xac, 0xe5, 0x20, 0xcb, 0x6c, 0xea, 0x88, 0x54, 0xd4,
	0x6e, 0xc1, 0x0d, 0x8d, 0x59, 0x27, 0xa6, 0xa1, 0xf1, 0x8e, 0x4e, 0x39, 0x95, 0xc7, 0x8c, 0x3b,
	0x2a, 0xa7, 0xdd, 0x81, 0xf2, 0x3d, 0x82, 0xa5, 0xf0, 0x39, 0xc1, 0x1b, 0x30, 0x7b, 0x4a, 0x83,
	0x2e, 0x1f, 0x9f, 0x76, 0x0f, 0x84, 0x0b, 0x70, 0x25, 0x90, 0xe2, 0x65, 0x7a, 0x96, 0x04, 0x4b,
	0x7c, 0x07, 0xae, 0x4e, 0xf8, 0xa5, 0xba, 0x48, 0x6b, 0x86, 0xe4, 0x83, 0x17, 0xbb, 0x72, 0x5f,
	0xf9, 0x17, 0x41, 0x6e, 0x6c, 0xee, 0xe0, 0xcf, 0x20, 0x2f, 0xe6, 0x95, 0xc6, 0x2c, 0xd7, 0x70,
	0x39, 0xb5, 0xb4, 0x81, 0xf8, 0x84, 0x97, 0xaa, 0x9b, 0xd3, 0x66, 0x96, 0x78, 0xae, 0x8f, 0x78,
	0x7b, 0x33, 0x64, 0xd9, 0x09, 0x6f, 0x4d, 0x36, 0x87, 0x54, 0x44, 0x73, 0x50, 0xf6, 0x61, 0x79,
	0xc2, 0x12, 0x2e, 0xc1, 0x4d, 0xd2, 0xd8, 0xd9, 0xed, 0xd4, 0xdb, 0xad, 0xc3, 0xe6, 0xe1, 0x51,
	0xa3, 0x55, 0xff, 0x64, 0xe2, 0xb3, 0x07, 0x48, 0x1f, 0x1e, 0x91, 0x76, 0xeb, 0x71, 0x1e, 0xe1,
	0x05, 0xc8, 0x34, 0x9e, 0x35, 0x5a, 0x47, 0x4f, 0xc5, 0x67, 0x8e, 0x21, 0x3f, 0x16, 0x8c, 0x3f,
	0xd0, 0x7e, 0x4c, 0x01, 0xbe, 0xd8, 0xe2, 0x31, 0x01, 0x10, 0xc1, 0x7f, 0xe9, 0x18, 0x9c, 0xca,
	0xb9, 0xb6, 0x95, 0x70, 0x3e, 0x88, 0xe8, 0x3f, 0xf2, 0x88, 0x7b, 0x33, 0x24, 0xeb, 0x04, 0x0b,
	0xdc, 0x86, 0xac, 0x7f, 0x01, 0xb0, 0xcc, 0x60, 0xda, 0x6d, 0xbe, 0x8a, 0xc9, 0xb6, 0x65, 0x8a,
	0xd1, 0xec, 0xc8, 0xe7, 0xe2, 0xfb, 0x90, 0x1d, 0xba, 0xc2, 0x5b, 0x70, 0xcd, 0x76, 0xe8, 0xb9,
	0xc1, 0xfa, 0x6e, 0xe7, 0xe2, 0x64, 0x58, 0x09, 0xde, 0x8d, 0xd9, 0x2e, 0x02, 0x64, 0x02, 0xbb,
	0xb5, 0xb4, 0xdf, 0xe8, 0xab, 0x7f, 0xa7, 0x21, 0xbb, 0x1b, 0x88, 0xc1, 0xcf, 0x21, 0xed, 0xdf,
	0xf4, 0xb0, 0x12, 0xa9, 0x34, 0x74, 0x55, 0x2d, 0xae, 0x5e, 0x8a, 0x91, 0x23, 0xe8, 0xce, 0x77,
	0x7f, 0xfd, 0xf3, 0x53, 0x6a, 0x4d, 0x29, 0x79, 0x57, 0x5f, 0xd9, 0xad, 0xdc, 0xca, 0xd7, 0xa3,
	0x4e, 0xf6, 0xcd, 0x03, 0x53, 0x30, 0x1e, 0xa0, 0x0d, 0xfc, 0x03, 0x82, 0x4c, 0x70, 0xdd, 0xc0,
	0x6f, 0x47, 0x1f, 0xbb, 0xf0, 0x55, 0xae, 0xb8, 0x36, 0x05, 0x25, 0x65, 0xdc, 0x13, 0x32, 0x6e,
	0x2b, 0x4a, 0xbc, 0x0c, 0x47, 0x72, 0x3c, 0x21, 0xbf, 0x20, 0xc8, 0x4f, 0xce, 0x77, 0x7c, 0x37,
	0xd2, 0x55, 0xcc, 0xd5, 0xa4, 0x78, 0x2f, 0x21, 0x5a, 0x0a, 0xbc, 0x2f, 0x04, 0x56, 0x94, 0x8d,
	0x78, 0x81, 0xc7, 0x13, 0x5c, 0x4f, 0xe8, 0x73, 0x48, 0xfb, 0x13, 0x2b, 0xa6, 0x62, 0xa1, 0x61,
	0x1d, 0x53, 0xb1, 0xf0, 0xc8, 0x4b, 0x52, 0x31, 0x4d, 0x30, 0x86, 0x15, 0x93, 0xd7, 0x8e, 0xb8,
	0x8a, 0x85, 0x6f, 0x3a, 0x71, 0x15, 0x9b, 0xbc, 0xbb, 0x24, 0xa9, 0x98, 0xe4, 0x78, 0x42, 0x5e,
	0x22, 0xc8, 0x8d, 0x4d, 0x34, 0x1c, 0x7d, 0x77, 0xb9, 0x38, 0x56, 0x8b, 0xeb, 0xd3, 0x81, 0x52,
	0xd1, 0xa6, 0x50, 0xb4, 0xa1, 0xac, 0xc5, 0x2b, 0x52, 0x47, 0xb4, 0x07, 0x68, 0xa3, 0xf6, 0x02,
	0xc1, 0x75, 0x8d, 0xf5, 0xa2, 0x3c, 0xd4, 0x96, 0x86, 0x9f, 0xdd, 0x81, 0xf7, 0x2b, 0x78, 0x80,
	0x3e, 0x7d, 0x28, 0x61, 0x5d, 0x66, 0xaa, 0x56, 0xb7, 0xcc, 0x9c, 0x6e, 0xa5, 0x4b, 0x2d, 0xf1,
	0xa3, 0x58, 0xf1, 0x5f, 0xa9, 0xb6, 0xe1, 0x86, 0x7e, 0x26, 0xb7, 0x87, 0x8b, 0x5f, 0x53, 0x6f,
	0x3c, 0xf6, 0xe9, 0x75, 0x93, 0xf5, 0xf5, 0xf2, 0xd0, 0x7a, 0xf9, 0xd9, 0xd6, 0x71, 0x5a, 0x18,
	0x79, 0xe7, 0xbf, 0x00, 0x00, 0x00, 0xff, 0xff, 0xb7, 0x0f, 0xc7, 0x4b, 0x0a, 0x0f, 0x00, 0x00,
}
