// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/bigtable/v2/data.proto

package bigtable

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// Specifies the complete (requested) contents of a single row of a table.
// Rows which exceed 256MiB in size cannot be read in full.
type Row struct {
	// The unique key which identifies this row within its table. This is the same
	// key that's used to identify the row in, for example, a MutateRowRequest.
	// May contain any non-empty byte string up to 4KiB in length.
	Key []byte `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// May be empty, but only if the entire row is empty.
	// The mutual ordering of column families is not specified.
	Families []*Family `protobuf:"bytes,2,rep,name=families" json:"families,omitempty"`
}

func (m *Row) Reset()                    { *m = Row{} }
func (m *Row) String() string            { return proto.CompactTextString(m) }
func (*Row) ProtoMessage()               {}
func (*Row) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{0} }

func (m *Row) GetKey() []byte {
	if m != nil {
		return m.Key
	}
	return nil
}

func (m *Row) GetFamilies() []*Family {
	if m != nil {
		return m.Families
	}
	return nil
}

// Specifies (some of) the contents of a single row/column family intersection
// of a table.
type Family struct {
	// The unique key which identifies this family within its row. This is the
	// same key that's used to identify the family in, for example, a RowFilter
	// which sets its "family_name_regex_filter" field.
	// Must match `[-_.a-zA-Z0-9]+`, except that AggregatingRowProcessors may
	// produce cells in a sentinel family with an empty name.
	// Must be no greater than 64 characters in length.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// Must not be empty. Sorted in order of increasing "qualifier".
	Columns []*Column `protobuf:"bytes,2,rep,name=columns" json:"columns,omitempty"`
}

func (m *Family) Reset()                    { *m = Family{} }
func (m *Family) String() string            { return proto.CompactTextString(m) }
func (*Family) ProtoMessage()               {}
func (*Family) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{1} }

func (m *Family) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Family) GetColumns() []*Column {
	if m != nil {
		return m.Columns
	}
	return nil
}

// Specifies (some of) the contents of a single row/column intersection of a
// table.
type Column struct {
	// The unique key which identifies this column within its family. This is the
	// same key that's used to identify the column in, for example, a RowFilter
	// which sets its `column_qualifier_regex_filter` field.
	// May contain any byte string, including the empty string, up to 16kiB in
	// length.
	Qualifier []byte `protobuf:"bytes,1,opt,name=qualifier,proto3" json:"qualifier,omitempty"`
	// Must not be empty. Sorted in order of decreasing "timestamp_micros".
	Cells []*Cell `protobuf:"bytes,2,rep,name=cells" json:"cells,omitempty"`
}

func (m *Column) Reset()                    { *m = Column{} }
func (m *Column) String() string            { return proto.CompactTextString(m) }
func (*Column) ProtoMessage()               {}
func (*Column) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{2} }

func (m *Column) GetQualifier() []byte {
	if m != nil {
		return m.Qualifier
	}
	return nil
}

func (m *Column) GetCells() []*Cell {
	if m != nil {
		return m.Cells
	}
	return nil
}

// Specifies (some of) the contents of a single row/column/timestamp of a table.
type Cell struct {
	// The cell's stored timestamp, which also uniquely identifies it within
	// its column.
	// Values are always expressed in microseconds, but individual tables may set
	// a coarser granularity to further restrict the allowed values. For
	// example, a table which specifies millisecond granularity will only allow
	// values of `timestamp_micros` which are multiples of 1000.
	TimestampMicros int64 `protobuf:"varint,1,opt,name=timestamp_micros,json=timestampMicros" json:"timestamp_micros,omitempty"`
	// The value stored in the cell.
	// May contain any byte string, including the empty string, up to 100MiB in
	// length.
	Value []byte `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	// Labels applied to the cell by a [RowFilter][google.bigtable.v2.RowFilter].
	Labels []string `protobuf:"bytes,3,rep,name=labels" json:"labels,omitempty"`
}

func (m *Cell) Reset()                    { *m = Cell{} }
func (m *Cell) String() string            { return proto.CompactTextString(m) }
func (*Cell) ProtoMessage()               {}
func (*Cell) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{3} }

func (m *Cell) GetTimestampMicros() int64 {
	if m != nil {
		return m.TimestampMicros
	}
	return 0
}

func (m *Cell) GetValue() []byte {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *Cell) GetLabels() []string {
	if m != nil {
		return m.Labels
	}
	return nil
}

// Specifies a contiguous range of rows.
type RowRange struct {
	// The row key at which to start the range.
	// If neither field is set, interpreted as the empty string, inclusive.
	//
	// Types that are valid to be assigned to StartKey:
	//	*RowRange_StartKeyClosed
	//	*RowRange_StartKeyOpen
	StartKey isRowRange_StartKey `protobuf_oneof:"start_key"`
	// The row key at which to end the range.
	// If neither field is set, interpreted as the infinite row key, exclusive.
	//
	// Types that are valid to be assigned to EndKey:
	//	*RowRange_EndKeyOpen
	//	*RowRange_EndKeyClosed
	EndKey isRowRange_EndKey `protobuf_oneof:"end_key"`
}

func (m *RowRange) Reset()                    { *m = RowRange{} }
func (m *RowRange) String() string            { return proto.CompactTextString(m) }
func (*RowRange) ProtoMessage()               {}
func (*RowRange) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{4} }

type isRowRange_StartKey interface {
	isRowRange_StartKey()
}
type isRowRange_EndKey interface {
	isRowRange_EndKey()
}

type RowRange_StartKeyClosed struct {
	StartKeyClosed []byte `protobuf:"bytes,1,opt,name=start_key_closed,json=startKeyClosed,proto3,oneof"`
}
type RowRange_StartKeyOpen struct {
	StartKeyOpen []byte `protobuf:"bytes,2,opt,name=start_key_open,json=startKeyOpen,proto3,oneof"`
}
type RowRange_EndKeyOpen struct {
	EndKeyOpen []byte `protobuf:"bytes,3,opt,name=end_key_open,json=endKeyOpen,proto3,oneof"`
}
type RowRange_EndKeyClosed struct {
	EndKeyClosed []byte `protobuf:"bytes,4,opt,name=end_key_closed,json=endKeyClosed,proto3,oneof"`
}

func (*RowRange_StartKeyClosed) isRowRange_StartKey() {}
func (*RowRange_StartKeyOpen) isRowRange_StartKey()   {}
func (*RowRange_EndKeyOpen) isRowRange_EndKey()       {}
func (*RowRange_EndKeyClosed) isRowRange_EndKey()     {}

func (m *RowRange) GetStartKey() isRowRange_StartKey {
	if m != nil {
		return m.StartKey
	}
	return nil
}
func (m *RowRange) GetEndKey() isRowRange_EndKey {
	if m != nil {
		return m.EndKey
	}
	return nil
}

func (m *RowRange) GetStartKeyClosed() []byte {
	if x, ok := m.GetStartKey().(*RowRange_StartKeyClosed); ok {
		return x.StartKeyClosed
	}
	return nil
}

func (m *RowRange) GetStartKeyOpen() []byte {
	if x, ok := m.GetStartKey().(*RowRange_StartKeyOpen); ok {
		return x.StartKeyOpen
	}
	return nil
}

func (m *RowRange) GetEndKeyOpen() []byte {
	if x, ok := m.GetEndKey().(*RowRange_EndKeyOpen); ok {
		return x.EndKeyOpen
	}
	return nil
}

func (m *RowRange) GetEndKeyClosed() []byte {
	if x, ok := m.GetEndKey().(*RowRange_EndKeyClosed); ok {
		return x.EndKeyClosed
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*RowRange) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _RowRange_OneofMarshaler, _RowRange_OneofUnmarshaler, _RowRange_OneofSizer, []interface{}{
		(*RowRange_StartKeyClosed)(nil),
		(*RowRange_StartKeyOpen)(nil),
		(*RowRange_EndKeyOpen)(nil),
		(*RowRange_EndKeyClosed)(nil),
	}
}

func _RowRange_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*RowRange)
	// start_key
	switch x := m.StartKey.(type) {
	case *RowRange_StartKeyClosed:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.StartKeyClosed)
	case *RowRange_StartKeyOpen:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.StartKeyOpen)
	case nil:
	default:
		return fmt.Errorf("RowRange.StartKey has unexpected type %T", x)
	}
	// end_key
	switch x := m.EndKey.(type) {
	case *RowRange_EndKeyOpen:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.EndKeyOpen)
	case *RowRange_EndKeyClosed:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.EndKeyClosed)
	case nil:
	default:
		return fmt.Errorf("RowRange.EndKey has unexpected type %T", x)
	}
	return nil
}

func _RowRange_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*RowRange)
	switch tag {
	case 1: // start_key.start_key_closed
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.StartKey = &RowRange_StartKeyClosed{x}
		return true, err
	case 2: // start_key.start_key_open
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.StartKey = &RowRange_StartKeyOpen{x}
		return true, err
	case 3: // end_key.end_key_open
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.EndKey = &RowRange_EndKeyOpen{x}
		return true, err
	case 4: // end_key.end_key_closed
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.EndKey = &RowRange_EndKeyClosed{x}
		return true, err
	default:
		return false, nil
	}
}

func _RowRange_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*RowRange)
	// start_key
	switch x := m.StartKey.(type) {
	case *RowRange_StartKeyClosed:
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.StartKeyClosed)))
		n += len(x.StartKeyClosed)
	case *RowRange_StartKeyOpen:
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.StartKeyOpen)))
		n += len(x.StartKeyOpen)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	// end_key
	switch x := m.EndKey.(type) {
	case *RowRange_EndKeyOpen:
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.EndKeyOpen)))
		n += len(x.EndKeyOpen)
	case *RowRange_EndKeyClosed:
		n += proto.SizeVarint(4<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.EndKeyClosed)))
		n += len(x.EndKeyClosed)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Specifies a non-contiguous set of rows.
type RowSet struct {
	// Single rows included in the set.
	RowKeys [][]byte `protobuf:"bytes,1,rep,name=row_keys,json=rowKeys,proto3" json:"row_keys,omitempty"`
	// Contiguous row ranges included in the set.
	RowRanges []*RowRange `protobuf:"bytes,2,rep,name=row_ranges,json=rowRanges" json:"row_ranges,omitempty"`
}

func (m *RowSet) Reset()                    { *m = RowSet{} }
func (m *RowSet) String() string            { return proto.CompactTextString(m) }
func (*RowSet) ProtoMessage()               {}
func (*RowSet) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{5} }

func (m *RowSet) GetRowKeys() [][]byte {
	if m != nil {
		return m.RowKeys
	}
	return nil
}

func (m *RowSet) GetRowRanges() []*RowRange {
	if m != nil {
		return m.RowRanges
	}
	return nil
}

// Specifies a contiguous range of columns within a single column family.
// The range spans from &lt;column_family&gt;:&lt;start_qualifier&gt; to
// &lt;column_family&gt;:&lt;end_qualifier&gt;, where both bounds can be either
// inclusive or exclusive.
type ColumnRange struct {
	// The name of the column family within which this range falls.
	FamilyName string `protobuf:"bytes,1,opt,name=family_name,json=familyName" json:"family_name,omitempty"`
	// The column qualifier at which to start the range (within `column_family`).
	// If neither field is set, interpreted as the empty string, inclusive.
	//
	// Types that are valid to be assigned to StartQualifier:
	//	*ColumnRange_StartQualifierClosed
	//	*ColumnRange_StartQualifierOpen
	StartQualifier isColumnRange_StartQualifier `protobuf_oneof:"start_qualifier"`
	// The column qualifier at which to end the range (within `column_family`).
	// If neither field is set, interpreted as the infinite string, exclusive.
	//
	// Types that are valid to be assigned to EndQualifier:
	//	*ColumnRange_EndQualifierClosed
	//	*ColumnRange_EndQualifierOpen
	EndQualifier isColumnRange_EndQualifier `protobuf_oneof:"end_qualifier"`
}

func (m *ColumnRange) Reset()                    { *m = ColumnRange{} }
func (m *ColumnRange) String() string            { return proto.CompactTextString(m) }
func (*ColumnRange) ProtoMessage()               {}
func (*ColumnRange) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{6} }

type isColumnRange_StartQualifier interface {
	isColumnRange_StartQualifier()
}
type isColumnRange_EndQualifier interface {
	isColumnRange_EndQualifier()
}

type ColumnRange_StartQualifierClosed struct {
	StartQualifierClosed []byte `protobuf:"bytes,2,opt,name=start_qualifier_closed,json=startQualifierClosed,proto3,oneof"`
}
type ColumnRange_StartQualifierOpen struct {
	StartQualifierOpen []byte `protobuf:"bytes,3,opt,name=start_qualifier_open,json=startQualifierOpen,proto3,oneof"`
}
type ColumnRange_EndQualifierClosed struct {
	EndQualifierClosed []byte `protobuf:"bytes,4,opt,name=end_qualifier_closed,json=endQualifierClosed,proto3,oneof"`
}
type ColumnRange_EndQualifierOpen struct {
	EndQualifierOpen []byte `protobuf:"bytes,5,opt,name=end_qualifier_open,json=endQualifierOpen,proto3,oneof"`
}

func (*ColumnRange_StartQualifierClosed) isColumnRange_StartQualifier() {}
func (*ColumnRange_StartQualifierOpen) isColumnRange_StartQualifier()   {}
func (*ColumnRange_EndQualifierClosed) isColumnRange_EndQualifier()     {}
func (*ColumnRange_EndQualifierOpen) isColumnRange_EndQualifier()       {}

func (m *ColumnRange) GetStartQualifier() isColumnRange_StartQualifier {
	if m != nil {
		return m.StartQualifier
	}
	return nil
}
func (m *ColumnRange) GetEndQualifier() isColumnRange_EndQualifier {
	if m != nil {
		return m.EndQualifier
	}
	return nil
}

func (m *ColumnRange) GetFamilyName() string {
	if m != nil {
		return m.FamilyName
	}
	return ""
}

func (m *ColumnRange) GetStartQualifierClosed() []byte {
	if x, ok := m.GetStartQualifier().(*ColumnRange_StartQualifierClosed); ok {
		return x.StartQualifierClosed
	}
	return nil
}

func (m *ColumnRange) GetStartQualifierOpen() []byte {
	if x, ok := m.GetStartQualifier().(*ColumnRange_StartQualifierOpen); ok {
		return x.StartQualifierOpen
	}
	return nil
}

func (m *ColumnRange) GetEndQualifierClosed() []byte {
	if x, ok := m.GetEndQualifier().(*ColumnRange_EndQualifierClosed); ok {
		return x.EndQualifierClosed
	}
	return nil
}

func (m *ColumnRange) GetEndQualifierOpen() []byte {
	if x, ok := m.GetEndQualifier().(*ColumnRange_EndQualifierOpen); ok {
		return x.EndQualifierOpen
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*ColumnRange) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _ColumnRange_OneofMarshaler, _ColumnRange_OneofUnmarshaler, _ColumnRange_OneofSizer, []interface{}{
		(*ColumnRange_StartQualifierClosed)(nil),
		(*ColumnRange_StartQualifierOpen)(nil),
		(*ColumnRange_EndQualifierClosed)(nil),
		(*ColumnRange_EndQualifierOpen)(nil),
	}
}

func _ColumnRange_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*ColumnRange)
	// start_qualifier
	switch x := m.StartQualifier.(type) {
	case *ColumnRange_StartQualifierClosed:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.StartQualifierClosed)
	case *ColumnRange_StartQualifierOpen:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.StartQualifierOpen)
	case nil:
	default:
		return fmt.Errorf("ColumnRange.StartQualifier has unexpected type %T", x)
	}
	// end_qualifier
	switch x := m.EndQualifier.(type) {
	case *ColumnRange_EndQualifierClosed:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.EndQualifierClosed)
	case *ColumnRange_EndQualifierOpen:
		b.EncodeVarint(5<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.EndQualifierOpen)
	case nil:
	default:
		return fmt.Errorf("ColumnRange.EndQualifier has unexpected type %T", x)
	}
	return nil
}

func _ColumnRange_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*ColumnRange)
	switch tag {
	case 2: // start_qualifier.start_qualifier_closed
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.StartQualifier = &ColumnRange_StartQualifierClosed{x}
		return true, err
	case 3: // start_qualifier.start_qualifier_open
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.StartQualifier = &ColumnRange_StartQualifierOpen{x}
		return true, err
	case 4: // end_qualifier.end_qualifier_closed
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.EndQualifier = &ColumnRange_EndQualifierClosed{x}
		return true, err
	case 5: // end_qualifier.end_qualifier_open
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.EndQualifier = &ColumnRange_EndQualifierOpen{x}
		return true, err
	default:
		return false, nil
	}
}

func _ColumnRange_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*ColumnRange)
	// start_qualifier
	switch x := m.StartQualifier.(type) {
	case *ColumnRange_StartQualifierClosed:
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.StartQualifierClosed)))
		n += len(x.StartQualifierClosed)
	case *ColumnRange_StartQualifierOpen:
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.StartQualifierOpen)))
		n += len(x.StartQualifierOpen)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	// end_qualifier
	switch x := m.EndQualifier.(type) {
	case *ColumnRange_EndQualifierClosed:
		n += proto.SizeVarint(4<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.EndQualifierClosed)))
		n += len(x.EndQualifierClosed)
	case *ColumnRange_EndQualifierOpen:
		n += proto.SizeVarint(5<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.EndQualifierOpen)))
		n += len(x.EndQualifierOpen)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Specified a contiguous range of microsecond timestamps.
type TimestampRange struct {
	// Inclusive lower bound. If left empty, interpreted as 0.
	StartTimestampMicros int64 `protobuf:"varint,1,opt,name=start_timestamp_micros,json=startTimestampMicros" json:"start_timestamp_micros,omitempty"`
	// Exclusive upper bound. If left empty, interpreted as infinity.
	EndTimestampMicros int64 `protobuf:"varint,2,opt,name=end_timestamp_micros,json=endTimestampMicros" json:"end_timestamp_micros,omitempty"`
}

func (m *TimestampRange) Reset()                    { *m = TimestampRange{} }
func (m *TimestampRange) String() string            { return proto.CompactTextString(m) }
func (*TimestampRange) ProtoMessage()               {}
func (*TimestampRange) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{7} }

func (m *TimestampRange) GetStartTimestampMicros() int64 {
	if m != nil {
		return m.StartTimestampMicros
	}
	return 0
}

func (m *TimestampRange) GetEndTimestampMicros() int64 {
	if m != nil {
		return m.EndTimestampMicros
	}
	return 0
}

// Specifies a contiguous range of raw byte values.
type ValueRange struct {
	// The value at which to start the range.
	// If neither field is set, interpreted as the empty string, inclusive.
	//
	// Types that are valid to be assigned to StartValue:
	//	*ValueRange_StartValueClosed
	//	*ValueRange_StartValueOpen
	StartValue isValueRange_StartValue `protobuf_oneof:"start_value"`
	// The value at which to end the range.
	// If neither field is set, interpreted as the infinite string, exclusive.
	//
	// Types that are valid to be assigned to EndValue:
	//	*ValueRange_EndValueClosed
	//	*ValueRange_EndValueOpen
	EndValue isValueRange_EndValue `protobuf_oneof:"end_value"`
}

func (m *ValueRange) Reset()                    { *m = ValueRange{} }
func (m *ValueRange) String() string            { return proto.CompactTextString(m) }
func (*ValueRange) ProtoMessage()               {}
func (*ValueRange) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{8} }

type isValueRange_StartValue interface {
	isValueRange_StartValue()
}
type isValueRange_EndValue interface {
	isValueRange_EndValue()
}

type ValueRange_StartValueClosed struct {
	StartValueClosed []byte `protobuf:"bytes,1,opt,name=start_value_closed,json=startValueClosed,proto3,oneof"`
}
type ValueRange_StartValueOpen struct {
	StartValueOpen []byte `protobuf:"bytes,2,opt,name=start_value_open,json=startValueOpen,proto3,oneof"`
}
type ValueRange_EndValueClosed struct {
	EndValueClosed []byte `protobuf:"bytes,3,opt,name=end_value_closed,json=endValueClosed,proto3,oneof"`
}
type ValueRange_EndValueOpen struct {
	EndValueOpen []byte `protobuf:"bytes,4,opt,name=end_value_open,json=endValueOpen,proto3,oneof"`
}

func (*ValueRange_StartValueClosed) isValueRange_StartValue() {}
func (*ValueRange_StartValueOpen) isValueRange_StartValue()   {}
func (*ValueRange_EndValueClosed) isValueRange_EndValue()     {}
func (*ValueRange_EndValueOpen) isValueRange_EndValue()       {}

func (m *ValueRange) GetStartValue() isValueRange_StartValue {
	if m != nil {
		return m.StartValue
	}
	return nil
}
func (m *ValueRange) GetEndValue() isValueRange_EndValue {
	if m != nil {
		return m.EndValue
	}
	return nil
}

func (m *ValueRange) GetStartValueClosed() []byte {
	if x, ok := m.GetStartValue().(*ValueRange_StartValueClosed); ok {
		return x.StartValueClosed
	}
	return nil
}

func (m *ValueRange) GetStartValueOpen() []byte {
	if x, ok := m.GetStartValue().(*ValueRange_StartValueOpen); ok {
		return x.StartValueOpen
	}
	return nil
}

func (m *ValueRange) GetEndValueClosed() []byte {
	if x, ok := m.GetEndValue().(*ValueRange_EndValueClosed); ok {
		return x.EndValueClosed
	}
	return nil
}

func (m *ValueRange) GetEndValueOpen() []byte {
	if x, ok := m.GetEndValue().(*ValueRange_EndValueOpen); ok {
		return x.EndValueOpen
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*ValueRange) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _ValueRange_OneofMarshaler, _ValueRange_OneofUnmarshaler, _ValueRange_OneofSizer, []interface{}{
		(*ValueRange_StartValueClosed)(nil),
		(*ValueRange_StartValueOpen)(nil),
		(*ValueRange_EndValueClosed)(nil),
		(*ValueRange_EndValueOpen)(nil),
	}
}

func _ValueRange_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*ValueRange)
	// start_value
	switch x := m.StartValue.(type) {
	case *ValueRange_StartValueClosed:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.StartValueClosed)
	case *ValueRange_StartValueOpen:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.StartValueOpen)
	case nil:
	default:
		return fmt.Errorf("ValueRange.StartValue has unexpected type %T", x)
	}
	// end_value
	switch x := m.EndValue.(type) {
	case *ValueRange_EndValueClosed:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.EndValueClosed)
	case *ValueRange_EndValueOpen:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.EndValueOpen)
	case nil:
	default:
		return fmt.Errorf("ValueRange.EndValue has unexpected type %T", x)
	}
	return nil
}

func _ValueRange_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*ValueRange)
	switch tag {
	case 1: // start_value.start_value_closed
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.StartValue = &ValueRange_StartValueClosed{x}
		return true, err
	case 2: // start_value.start_value_open
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.StartValue = &ValueRange_StartValueOpen{x}
		return true, err
	case 3: // end_value.end_value_closed
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.EndValue = &ValueRange_EndValueClosed{x}
		return true, err
	case 4: // end_value.end_value_open
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.EndValue = &ValueRange_EndValueOpen{x}
		return true, err
	default:
		return false, nil
	}
}

func _ValueRange_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*ValueRange)
	// start_value
	switch x := m.StartValue.(type) {
	case *ValueRange_StartValueClosed:
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.StartValueClosed)))
		n += len(x.StartValueClosed)
	case *ValueRange_StartValueOpen:
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.StartValueOpen)))
		n += len(x.StartValueOpen)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	// end_value
	switch x := m.EndValue.(type) {
	case *ValueRange_EndValueClosed:
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.EndValueClosed)))
		n += len(x.EndValueClosed)
	case *ValueRange_EndValueOpen:
		n += proto.SizeVarint(4<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.EndValueOpen)))
		n += len(x.EndValueOpen)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Takes a row as input and produces an alternate view of the row based on
// specified rules. For example, a RowFilter might trim down a row to include
// just the cells from columns matching a given regular expression, or might
// return all the cells of a row but not their values. More complicated filters
// can be composed out of these components to express requests such as, "within
// every column of a particular family, give just the two most recent cells
// which are older than timestamp X."
//
// There are two broad categories of RowFilters (true filters and transformers),
// as well as two ways to compose simple filters into more complex ones
// (chains and interleaves). They work as follows:
//
// * True filters alter the input row by excluding some of its cells wholesale
// from the output row. An example of a true filter is the `value_regex_filter`,
// which excludes cells whose values don't match the specified pattern. All
// regex true filters use RE2 syntax (https://github.com/google/re2/wiki/Syntax)
// in raw byte mode (RE2::Latin1), and are evaluated as full matches. An
// important point to keep in mind is that `RE2(.)` is equivalent by default to
// `RE2([^\n])`, meaning that it does not match newlines. When attempting to
// match an arbitrary byte, you should therefore use the escape sequence `\C`,
// which may need to be further escaped as `\\C` in your client language.
//
// * Transformers alter the input row by changing the values of some of its
// cells in the output, without excluding them completely. Currently, the only
// supported transformer is the `strip_value_transformer`, which replaces every
// cell's value with the empty string.
//
// * Chains and interleaves are described in more detail in the
// RowFilter.Chain and RowFilter.Interleave documentation.
//
// The total serialized size of a RowFilter message must not
// exceed 4096 bytes, and RowFilters may not be nested within each other
// (in Chains or Interleaves) to a depth of more than 20.
type RowFilter struct {
	// Which of the possible RowFilter types to apply. If none are set, this
	// RowFilter returns all cells in the input row.
	//
	// Types that are valid to be assigned to Filter:
	//	*RowFilter_Chain_
	//	*RowFilter_Interleave_
	//	*RowFilter_Condition_
	//	*RowFilter_Sink
	//	*RowFilter_PassAllFilter
	//	*RowFilter_BlockAllFilter
	//	*RowFilter_RowKeyRegexFilter
	//	*RowFilter_RowSampleFilter
	//	*RowFilter_FamilyNameRegexFilter
	//	*RowFilter_ColumnQualifierRegexFilter
	//	*RowFilter_ColumnRangeFilter
	//	*RowFilter_TimestampRangeFilter
	//	*RowFilter_ValueRegexFilter
	//	*RowFilter_ValueRangeFilter
	//	*RowFilter_CellsPerRowOffsetFilter
	//	*RowFilter_CellsPerRowLimitFilter
	//	*RowFilter_CellsPerColumnLimitFilter
	//	*RowFilter_StripValueTransformer
	//	*RowFilter_ApplyLabelTransformer
	Filter isRowFilter_Filter `protobuf_oneof:"filter"`
}

func (m *RowFilter) Reset()                    { *m = RowFilter{} }
func (m *RowFilter) String() string            { return proto.CompactTextString(m) }
func (*RowFilter) ProtoMessage()               {}
func (*RowFilter) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{9} }

type isRowFilter_Filter interface {
	isRowFilter_Filter()
}

type RowFilter_Chain_ struct {
	Chain *RowFilter_Chain `protobuf:"bytes,1,opt,name=chain,oneof"`
}
type RowFilter_Interleave_ struct {
	Interleave *RowFilter_Interleave `protobuf:"bytes,2,opt,name=interleave,oneof"`
}
type RowFilter_Condition_ struct {
	Condition *RowFilter_Condition `protobuf:"bytes,3,opt,name=condition,oneof"`
}
type RowFilter_Sink struct {
	Sink bool `protobuf:"varint,16,opt,name=sink,oneof"`
}
type RowFilter_PassAllFilter struct {
	PassAllFilter bool `protobuf:"varint,17,opt,name=pass_all_filter,json=passAllFilter,oneof"`
}
type RowFilter_BlockAllFilter struct {
	BlockAllFilter bool `protobuf:"varint,18,opt,name=block_all_filter,json=blockAllFilter,oneof"`
}
type RowFilter_RowKeyRegexFilter struct {
	RowKeyRegexFilter []byte `protobuf:"bytes,4,opt,name=row_key_regex_filter,json=rowKeyRegexFilter,proto3,oneof"`
}
type RowFilter_RowSampleFilter struct {
	RowSampleFilter float64 `protobuf:"fixed64,14,opt,name=row_sample_filter,json=rowSampleFilter,oneof"`
}
type RowFilter_FamilyNameRegexFilter struct {
	FamilyNameRegexFilter string `protobuf:"bytes,5,opt,name=family_name_regex_filter,json=familyNameRegexFilter,oneof"`
}
type RowFilter_ColumnQualifierRegexFilter struct {
	ColumnQualifierRegexFilter []byte `protobuf:"bytes,6,opt,name=column_qualifier_regex_filter,json=columnQualifierRegexFilter,proto3,oneof"`
}
type RowFilter_ColumnRangeFilter struct {
	ColumnRangeFilter *ColumnRange `protobuf:"bytes,7,opt,name=column_range_filter,json=columnRangeFilter,oneof"`
}
type RowFilter_TimestampRangeFilter struct {
	TimestampRangeFilter *TimestampRange `protobuf:"bytes,8,opt,name=timestamp_range_filter,json=timestampRangeFilter,oneof"`
}
type RowFilter_ValueRegexFilter struct {
	ValueRegexFilter []byte `protobuf:"bytes,9,opt,name=value_regex_filter,json=valueRegexFilter,proto3,oneof"`
}
type RowFilter_ValueRangeFilter struct {
	ValueRangeFilter *ValueRange `protobuf:"bytes,15,opt,name=value_range_filter,json=valueRangeFilter,oneof"`
}
type RowFilter_CellsPerRowOffsetFilter struct {
	CellsPerRowOffsetFilter int32 `protobuf:"varint,10,opt,name=cells_per_row_offset_filter,json=cellsPerRowOffsetFilter,oneof"`
}
type RowFilter_CellsPerRowLimitFilter struct {
	CellsPerRowLimitFilter int32 `protobuf:"varint,11,opt,name=cells_per_row_limit_filter,json=cellsPerRowLimitFilter,oneof"`
}
type RowFilter_CellsPerColumnLimitFilter struct {
	CellsPerColumnLimitFilter int32 `protobuf:"varint,12,opt,name=cells_per_column_limit_filter,json=cellsPerColumnLimitFilter,oneof"`
}
type RowFilter_StripValueTransformer struct {
	StripValueTransformer bool `protobuf:"varint,13,opt,name=strip_value_transformer,json=stripValueTransformer,oneof"`
}
type RowFilter_ApplyLabelTransformer struct {
	ApplyLabelTransformer string `protobuf:"bytes,19,opt,name=apply_label_transformer,json=applyLabelTransformer,oneof"`
}

func (*RowFilter_Chain_) isRowFilter_Filter()                     {}
func (*RowFilter_Interleave_) isRowFilter_Filter()                {}
func (*RowFilter_Condition_) isRowFilter_Filter()                 {}
func (*RowFilter_Sink) isRowFilter_Filter()                       {}
func (*RowFilter_PassAllFilter) isRowFilter_Filter()              {}
func (*RowFilter_BlockAllFilter) isRowFilter_Filter()             {}
func (*RowFilter_RowKeyRegexFilter) isRowFilter_Filter()          {}
func (*RowFilter_RowSampleFilter) isRowFilter_Filter()            {}
func (*RowFilter_FamilyNameRegexFilter) isRowFilter_Filter()      {}
func (*RowFilter_ColumnQualifierRegexFilter) isRowFilter_Filter() {}
func (*RowFilter_ColumnRangeFilter) isRowFilter_Filter()          {}
func (*RowFilter_TimestampRangeFilter) isRowFilter_Filter()       {}
func (*RowFilter_ValueRegexFilter) isRowFilter_Filter()           {}
func (*RowFilter_ValueRangeFilter) isRowFilter_Filter()           {}
func (*RowFilter_CellsPerRowOffsetFilter) isRowFilter_Filter()    {}
func (*RowFilter_CellsPerRowLimitFilter) isRowFilter_Filter()     {}
func (*RowFilter_CellsPerColumnLimitFilter) isRowFilter_Filter()  {}
func (*RowFilter_StripValueTransformer) isRowFilter_Filter()      {}
func (*RowFilter_ApplyLabelTransformer) isRowFilter_Filter()      {}

func (m *RowFilter) GetFilter() isRowFilter_Filter {
	if m != nil {
		return m.Filter
	}
	return nil
}

func (m *RowFilter) GetChain() *RowFilter_Chain {
	if x, ok := m.GetFilter().(*RowFilter_Chain_); ok {
		return x.Chain
	}
	return nil
}

func (m *RowFilter) GetInterleave() *RowFilter_Interleave {
	if x, ok := m.GetFilter().(*RowFilter_Interleave_); ok {
		return x.Interleave
	}
	return nil
}

func (m *RowFilter) GetCondition() *RowFilter_Condition {
	if x, ok := m.GetFilter().(*RowFilter_Condition_); ok {
		return x.Condition
	}
	return nil
}

func (m *RowFilter) GetSink() bool {
	if x, ok := m.GetFilter().(*RowFilter_Sink); ok {
		return x.Sink
	}
	return false
}

func (m *RowFilter) GetPassAllFilter() bool {
	if x, ok := m.GetFilter().(*RowFilter_PassAllFilter); ok {
		return x.PassAllFilter
	}
	return false
}

func (m *RowFilter) GetBlockAllFilter() bool {
	if x, ok := m.GetFilter().(*RowFilter_BlockAllFilter); ok {
		return x.BlockAllFilter
	}
	return false
}

func (m *RowFilter) GetRowKeyRegexFilter() []byte {
	if x, ok := m.GetFilter().(*RowFilter_RowKeyRegexFilter); ok {
		return x.RowKeyRegexFilter
	}
	return nil
}

func (m *RowFilter) GetRowSampleFilter() float64 {
	if x, ok := m.GetFilter().(*RowFilter_RowSampleFilter); ok {
		return x.RowSampleFilter
	}
	return 0
}

func (m *RowFilter) GetFamilyNameRegexFilter() string {
	if x, ok := m.GetFilter().(*RowFilter_FamilyNameRegexFilter); ok {
		return x.FamilyNameRegexFilter
	}
	return ""
}

func (m *RowFilter) GetColumnQualifierRegexFilter() []byte {
	if x, ok := m.GetFilter().(*RowFilter_ColumnQualifierRegexFilter); ok {
		return x.ColumnQualifierRegexFilter
	}
	return nil
}

func (m *RowFilter) GetColumnRangeFilter() *ColumnRange {
	if x, ok := m.GetFilter().(*RowFilter_ColumnRangeFilter); ok {
		return x.ColumnRangeFilter
	}
	return nil
}

func (m *RowFilter) GetTimestampRangeFilter() *TimestampRange {
	if x, ok := m.GetFilter().(*RowFilter_TimestampRangeFilter); ok {
		return x.TimestampRangeFilter
	}
	return nil
}

func (m *RowFilter) GetValueRegexFilter() []byte {
	if x, ok := m.GetFilter().(*RowFilter_ValueRegexFilter); ok {
		return x.ValueRegexFilter
	}
	return nil
}

func (m *RowFilter) GetValueRangeFilter() *ValueRange {
	if x, ok := m.GetFilter().(*RowFilter_ValueRangeFilter); ok {
		return x.ValueRangeFilter
	}
	return nil
}

func (m *RowFilter) GetCellsPerRowOffsetFilter() int32 {
	if x, ok := m.GetFilter().(*RowFilter_CellsPerRowOffsetFilter); ok {
		return x.CellsPerRowOffsetFilter
	}
	return 0
}

func (m *RowFilter) GetCellsPerRowLimitFilter() int32 {
	if x, ok := m.GetFilter().(*RowFilter_CellsPerRowLimitFilter); ok {
		return x.CellsPerRowLimitFilter
	}
	return 0
}

func (m *RowFilter) GetCellsPerColumnLimitFilter() int32 {
	if x, ok := m.GetFilter().(*RowFilter_CellsPerColumnLimitFilter); ok {
		return x.CellsPerColumnLimitFilter
	}
	return 0
}

func (m *RowFilter) GetStripValueTransformer() bool {
	if x, ok := m.GetFilter().(*RowFilter_StripValueTransformer); ok {
		return x.StripValueTransformer
	}
	return false
}

func (m *RowFilter) GetApplyLabelTransformer() string {
	if x, ok := m.GetFilter().(*RowFilter_ApplyLabelTransformer); ok {
		return x.ApplyLabelTransformer
	}
	return ""
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*RowFilter) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _RowFilter_OneofMarshaler, _RowFilter_OneofUnmarshaler, _RowFilter_OneofSizer, []interface{}{
		(*RowFilter_Chain_)(nil),
		(*RowFilter_Interleave_)(nil),
		(*RowFilter_Condition_)(nil),
		(*RowFilter_Sink)(nil),
		(*RowFilter_PassAllFilter)(nil),
		(*RowFilter_BlockAllFilter)(nil),
		(*RowFilter_RowKeyRegexFilter)(nil),
		(*RowFilter_RowSampleFilter)(nil),
		(*RowFilter_FamilyNameRegexFilter)(nil),
		(*RowFilter_ColumnQualifierRegexFilter)(nil),
		(*RowFilter_ColumnRangeFilter)(nil),
		(*RowFilter_TimestampRangeFilter)(nil),
		(*RowFilter_ValueRegexFilter)(nil),
		(*RowFilter_ValueRangeFilter)(nil),
		(*RowFilter_CellsPerRowOffsetFilter)(nil),
		(*RowFilter_CellsPerRowLimitFilter)(nil),
		(*RowFilter_CellsPerColumnLimitFilter)(nil),
		(*RowFilter_StripValueTransformer)(nil),
		(*RowFilter_ApplyLabelTransformer)(nil),
	}
}

func _RowFilter_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*RowFilter)
	// filter
	switch x := m.Filter.(type) {
	case *RowFilter_Chain_:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Chain); err != nil {
			return err
		}
	case *RowFilter_Interleave_:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Interleave); err != nil {
			return err
		}
	case *RowFilter_Condition_:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Condition); err != nil {
			return err
		}
	case *RowFilter_Sink:
		t := uint64(0)
		if x.Sink {
			t = 1
		}
		b.EncodeVarint(16<<3 | proto.WireVarint)
		b.EncodeVarint(t)
	case *RowFilter_PassAllFilter:
		t := uint64(0)
		if x.PassAllFilter {
			t = 1
		}
		b.EncodeVarint(17<<3 | proto.WireVarint)
		b.EncodeVarint(t)
	case *RowFilter_BlockAllFilter:
		t := uint64(0)
		if x.BlockAllFilter {
			t = 1
		}
		b.EncodeVarint(18<<3 | proto.WireVarint)
		b.EncodeVarint(t)
	case *RowFilter_RowKeyRegexFilter:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.RowKeyRegexFilter)
	case *RowFilter_RowSampleFilter:
		b.EncodeVarint(14<<3 | proto.WireFixed64)
		b.EncodeFixed64(math.Float64bits(x.RowSampleFilter))
	case *RowFilter_FamilyNameRegexFilter:
		b.EncodeVarint(5<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.FamilyNameRegexFilter)
	case *RowFilter_ColumnQualifierRegexFilter:
		b.EncodeVarint(6<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.ColumnQualifierRegexFilter)
	case *RowFilter_ColumnRangeFilter:
		b.EncodeVarint(7<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ColumnRangeFilter); err != nil {
			return err
		}
	case *RowFilter_TimestampRangeFilter:
		b.EncodeVarint(8<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TimestampRangeFilter); err != nil {
			return err
		}
	case *RowFilter_ValueRegexFilter:
		b.EncodeVarint(9<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.ValueRegexFilter)
	case *RowFilter_ValueRangeFilter:
		b.EncodeVarint(15<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ValueRangeFilter); err != nil {
			return err
		}
	case *RowFilter_CellsPerRowOffsetFilter:
		b.EncodeVarint(10<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.CellsPerRowOffsetFilter))
	case *RowFilter_CellsPerRowLimitFilter:
		b.EncodeVarint(11<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.CellsPerRowLimitFilter))
	case *RowFilter_CellsPerColumnLimitFilter:
		b.EncodeVarint(12<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.CellsPerColumnLimitFilter))
	case *RowFilter_StripValueTransformer:
		t := uint64(0)
		if x.StripValueTransformer {
			t = 1
		}
		b.EncodeVarint(13<<3 | proto.WireVarint)
		b.EncodeVarint(t)
	case *RowFilter_ApplyLabelTransformer:
		b.EncodeVarint(19<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.ApplyLabelTransformer)
	case nil:
	default:
		return fmt.Errorf("RowFilter.Filter has unexpected type %T", x)
	}
	return nil
}

func _RowFilter_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*RowFilter)
	switch tag {
	case 1: // filter.chain
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(RowFilter_Chain)
		err := b.DecodeMessage(msg)
		m.Filter = &RowFilter_Chain_{msg}
		return true, err
	case 2: // filter.interleave
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(RowFilter_Interleave)
		err := b.DecodeMessage(msg)
		m.Filter = &RowFilter_Interleave_{msg}
		return true, err
	case 3: // filter.condition
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(RowFilter_Condition)
		err := b.DecodeMessage(msg)
		m.Filter = &RowFilter_Condition_{msg}
		return true, err
	case 16: // filter.sink
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Filter = &RowFilter_Sink{x != 0}
		return true, err
	case 17: // filter.pass_all_filter
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Filter = &RowFilter_PassAllFilter{x != 0}
		return true, err
	case 18: // filter.block_all_filter
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Filter = &RowFilter_BlockAllFilter{x != 0}
		return true, err
	case 4: // filter.row_key_regex_filter
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.Filter = &RowFilter_RowKeyRegexFilter{x}
		return true, err
	case 14: // filter.row_sample_filter
		if wire != proto.WireFixed64 {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeFixed64()
		m.Filter = &RowFilter_RowSampleFilter{math.Float64frombits(x)}
		return true, err
	case 5: // filter.family_name_regex_filter
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Filter = &RowFilter_FamilyNameRegexFilter{x}
		return true, err
	case 6: // filter.column_qualifier_regex_filter
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.Filter = &RowFilter_ColumnQualifierRegexFilter{x}
		return true, err
	case 7: // filter.column_range_filter
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ColumnRange)
		err := b.DecodeMessage(msg)
		m.Filter = &RowFilter_ColumnRangeFilter{msg}
		return true, err
	case 8: // filter.timestamp_range_filter
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(TimestampRange)
		err := b.DecodeMessage(msg)
		m.Filter = &RowFilter_TimestampRangeFilter{msg}
		return true, err
	case 9: // filter.value_regex_filter
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.Filter = &RowFilter_ValueRegexFilter{x}
		return true, err
	case 15: // filter.value_range_filter
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ValueRange)
		err := b.DecodeMessage(msg)
		m.Filter = &RowFilter_ValueRangeFilter{msg}
		return true, err
	case 10: // filter.cells_per_row_offset_filter
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Filter = &RowFilter_CellsPerRowOffsetFilter{int32(x)}
		return true, err
	case 11: // filter.cells_per_row_limit_filter
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Filter = &RowFilter_CellsPerRowLimitFilter{int32(x)}
		return true, err
	case 12: // filter.cells_per_column_limit_filter
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Filter = &RowFilter_CellsPerColumnLimitFilter{int32(x)}
		return true, err
	case 13: // filter.strip_value_transformer
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Filter = &RowFilter_StripValueTransformer{x != 0}
		return true, err
	case 19: // filter.apply_label_transformer
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Filter = &RowFilter_ApplyLabelTransformer{x}
		return true, err
	default:
		return false, nil
	}
}

func _RowFilter_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*RowFilter)
	// filter
	switch x := m.Filter.(type) {
	case *RowFilter_Chain_:
		s := proto.Size(x.Chain)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RowFilter_Interleave_:
		s := proto.Size(x.Interleave)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RowFilter_Condition_:
		s := proto.Size(x.Condition)
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RowFilter_Sink:
		n += proto.SizeVarint(16<<3 | proto.WireVarint)
		n += 1
	case *RowFilter_PassAllFilter:
		n += proto.SizeVarint(17<<3 | proto.WireVarint)
		n += 1
	case *RowFilter_BlockAllFilter:
		n += proto.SizeVarint(18<<3 | proto.WireVarint)
		n += 1
	case *RowFilter_RowKeyRegexFilter:
		n += proto.SizeVarint(4<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.RowKeyRegexFilter)))
		n += len(x.RowKeyRegexFilter)
	case *RowFilter_RowSampleFilter:
		n += proto.SizeVarint(14<<3 | proto.WireFixed64)
		n += 8
	case *RowFilter_FamilyNameRegexFilter:
		n += proto.SizeVarint(5<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.FamilyNameRegexFilter)))
		n += len(x.FamilyNameRegexFilter)
	case *RowFilter_ColumnQualifierRegexFilter:
		n += proto.SizeVarint(6<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.ColumnQualifierRegexFilter)))
		n += len(x.ColumnQualifierRegexFilter)
	case *RowFilter_ColumnRangeFilter:
		s := proto.Size(x.ColumnRangeFilter)
		n += proto.SizeVarint(7<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RowFilter_TimestampRangeFilter:
		s := proto.Size(x.TimestampRangeFilter)
		n += proto.SizeVarint(8<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RowFilter_ValueRegexFilter:
		n += proto.SizeVarint(9<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.ValueRegexFilter)))
		n += len(x.ValueRegexFilter)
	case *RowFilter_ValueRangeFilter:
		s := proto.Size(x.ValueRangeFilter)
		n += proto.SizeVarint(15<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RowFilter_CellsPerRowOffsetFilter:
		n += proto.SizeVarint(10<<3 | proto.WireVarint)
		n += proto.SizeVarint(uint64(x.CellsPerRowOffsetFilter))
	case *RowFilter_CellsPerRowLimitFilter:
		n += proto.SizeVarint(11<<3 | proto.WireVarint)
		n += proto.SizeVarint(uint64(x.CellsPerRowLimitFilter))
	case *RowFilter_CellsPerColumnLimitFilter:
		n += proto.SizeVarint(12<<3 | proto.WireVarint)
		n += proto.SizeVarint(uint64(x.CellsPerColumnLimitFilter))
	case *RowFilter_StripValueTransformer:
		n += proto.SizeVarint(13<<3 | proto.WireVarint)
		n += 1
	case *RowFilter_ApplyLabelTransformer:
		n += proto.SizeVarint(19<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.ApplyLabelTransformer)))
		n += len(x.ApplyLabelTransformer)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// A RowFilter which sends rows through several RowFilters in sequence.
type RowFilter_Chain struct {
	// The elements of "filters" are chained together to process the input row:
	// in row -> f(0) -> intermediate row -> f(1) -> ... -> f(N) -> out row
	// The full chain is executed atomically.
	Filters []*RowFilter `protobuf:"bytes,1,rep,name=filters" json:"filters,omitempty"`
}

func (m *RowFilter_Chain) Reset()                    { *m = RowFilter_Chain{} }
func (m *RowFilter_Chain) String() string            { return proto.CompactTextString(m) }
func (*RowFilter_Chain) ProtoMessage()               {}
func (*RowFilter_Chain) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{9, 0} }

func (m *RowFilter_Chain) GetFilters() []*RowFilter {
	if m != nil {
		return m.Filters
	}
	return nil
}

// A RowFilter which sends each row to each of several component
// RowFilters and interleaves the results.
type RowFilter_Interleave struct {
	// The elements of "filters" all process a copy of the input row, and the
	// results are pooled, sorted, and combined into a single output row.
	// If multiple cells are produced with the same column and timestamp,
	// they will all appear in the output row in an unspecified mutual order.
	// Consider the following example, with three filters:
	//
	//                                  input row
	//                                      |
	//            -----------------------------------------------------
	//            |                         |                         |
	//           f(0)                      f(1)                      f(2)
	//            |                         |                         |
	//     1: foo,bar,10,x             foo,bar,10,z              far,bar,7,a
	//     2: foo,blah,11,z            far,blah,5,x              far,blah,5,x
	//            |                         |                         |
	//            -----------------------------------------------------
	//                                      |
	//     1:                      foo,bar,10,z   // could have switched with #2
	//     2:                      foo,bar,10,x   // could have switched with #1
	//     3:                      foo,blah,11,z
	//     4:                      far,bar,7,a
	//     5:                      far,blah,5,x   // identical to #6
	//     6:                      far,blah,5,x   // identical to #5
	//
	// All interleaved filters are executed atomically.
	Filters []*RowFilter `protobuf:"bytes,1,rep,name=filters" json:"filters,omitempty"`
}

func (m *RowFilter_Interleave) Reset()                    { *m = RowFilter_Interleave{} }
func (m *RowFilter_Interleave) String() string            { return proto.CompactTextString(m) }
func (*RowFilter_Interleave) ProtoMessage()               {}
func (*RowFilter_Interleave) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{9, 1} }

func (m *RowFilter_Interleave) GetFilters() []*RowFilter {
	if m != nil {
		return m.Filters
	}
	return nil
}

// A RowFilter which evaluates one of two possible RowFilters, depending on
// whether or not a predicate RowFilter outputs any cells from the input row.
//
// IMPORTANT NOTE: The predicate filter does not execute atomically with the
// true and false filters, which may lead to inconsistent or unexpected
// results. Additionally, Condition filters have poor performance, especially
// when filters are set for the false condition.
type RowFilter_Condition struct {
	// If `predicate_filter` outputs any cells, then `true_filter` will be
	// evaluated on the input row. Otherwise, `false_filter` will be evaluated.
	PredicateFilter *RowFilter `protobuf:"bytes,1,opt,name=predicate_filter,json=predicateFilter" json:"predicate_filter,omitempty"`
	// The filter to apply to the input row if `predicate_filter` returns any
	// results. If not provided, no results will be returned in the true case.
	TrueFilter *RowFilter `protobuf:"bytes,2,opt,name=true_filter,json=trueFilter" json:"true_filter,omitempty"`
	// The filter to apply to the input row if `predicate_filter` does not
	// return any results. If not provided, no results will be returned in the
	// false case.
	FalseFilter *RowFilter `protobuf:"bytes,3,opt,name=false_filter,json=falseFilter" json:"false_filter,omitempty"`
}

func (m *RowFilter_Condition) Reset()                    { *m = RowFilter_Condition{} }
func (m *RowFilter_Condition) String() string            { return proto.CompactTextString(m) }
func (*RowFilter_Condition) ProtoMessage()               {}
func (*RowFilter_Condition) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{9, 2} }

func (m *RowFilter_Condition) GetPredicateFilter() *RowFilter {
	if m != nil {
		return m.PredicateFilter
	}
	return nil
}

func (m *RowFilter_Condition) GetTrueFilter() *RowFilter {
	if m != nil {
		return m.TrueFilter
	}
	return nil
}

func (m *RowFilter_Condition) GetFalseFilter() *RowFilter {
	if m != nil {
		return m.FalseFilter
	}
	return nil
}

// Specifies a particular change to be made to the contents of a row.
type Mutation struct {
	// Which of the possible Mutation types to apply.
	//
	// Types that are valid to be assigned to Mutation:
	//	*Mutation_SetCell_
	//	*Mutation_DeleteFromColumn_
	//	*Mutation_DeleteFromFamily_
	//	*Mutation_DeleteFromRow_
	Mutation isMutation_Mutation `protobuf_oneof:"mutation"`
}

func (m *Mutation) Reset()                    { *m = Mutation{} }
func (m *Mutation) String() string            { return proto.CompactTextString(m) }
func (*Mutation) ProtoMessage()               {}
func (*Mutation) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{10} }

type isMutation_Mutation interface {
	isMutation_Mutation()
}

type Mutation_SetCell_ struct {
	SetCell *Mutation_SetCell `protobuf:"bytes,1,opt,name=set_cell,json=setCell,oneof"`
}
type Mutation_DeleteFromColumn_ struct {
	DeleteFromColumn *Mutation_DeleteFromColumn `protobuf:"bytes,2,opt,name=delete_from_column,json=deleteFromColumn,oneof"`
}
type Mutation_DeleteFromFamily_ struct {
	DeleteFromFamily *Mutation_DeleteFromFamily `protobuf:"bytes,3,opt,name=delete_from_family,json=deleteFromFamily,oneof"`
}
type Mutation_DeleteFromRow_ struct {
	DeleteFromRow *Mutation_DeleteFromRow `protobuf:"bytes,4,opt,name=delete_from_row,json=deleteFromRow,oneof"`
}

func (*Mutation_SetCell_) isMutation_Mutation()          {}
func (*Mutation_DeleteFromColumn_) isMutation_Mutation() {}
func (*Mutation_DeleteFromFamily_) isMutation_Mutation() {}
func (*Mutation_DeleteFromRow_) isMutation_Mutation()    {}

func (m *Mutation) GetMutation() isMutation_Mutation {
	if m != nil {
		return m.Mutation
	}
	return nil
}

func (m *Mutation) GetSetCell() *Mutation_SetCell {
	if x, ok := m.GetMutation().(*Mutation_SetCell_); ok {
		return x.SetCell
	}
	return nil
}

func (m *Mutation) GetDeleteFromColumn() *Mutation_DeleteFromColumn {
	if x, ok := m.GetMutation().(*Mutation_DeleteFromColumn_); ok {
		return x.DeleteFromColumn
	}
	return nil
}

func (m *Mutation) GetDeleteFromFamily() *Mutation_DeleteFromFamily {
	if x, ok := m.GetMutation().(*Mutation_DeleteFromFamily_); ok {
		return x.DeleteFromFamily
	}
	return nil
}

func (m *Mutation) GetDeleteFromRow() *Mutation_DeleteFromRow {
	if x, ok := m.GetMutation().(*Mutation_DeleteFromRow_); ok {
		return x.DeleteFromRow
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Mutation) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Mutation_OneofMarshaler, _Mutation_OneofUnmarshaler, _Mutation_OneofSizer, []interface{}{
		(*Mutation_SetCell_)(nil),
		(*Mutation_DeleteFromColumn_)(nil),
		(*Mutation_DeleteFromFamily_)(nil),
		(*Mutation_DeleteFromRow_)(nil),
	}
}

func _Mutation_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Mutation)
	// mutation
	switch x := m.Mutation.(type) {
	case *Mutation_SetCell_:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.SetCell); err != nil {
			return err
		}
	case *Mutation_DeleteFromColumn_:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.DeleteFromColumn); err != nil {
			return err
		}
	case *Mutation_DeleteFromFamily_:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.DeleteFromFamily); err != nil {
			return err
		}
	case *Mutation_DeleteFromRow_:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.DeleteFromRow); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Mutation.Mutation has unexpected type %T", x)
	}
	return nil
}

func _Mutation_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Mutation)
	switch tag {
	case 1: // mutation.set_cell
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Mutation_SetCell)
		err := b.DecodeMessage(msg)
		m.Mutation = &Mutation_SetCell_{msg}
		return true, err
	case 2: // mutation.delete_from_column
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Mutation_DeleteFromColumn)
		err := b.DecodeMessage(msg)
		m.Mutation = &Mutation_DeleteFromColumn_{msg}
		return true, err
	case 3: // mutation.delete_from_family
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Mutation_DeleteFromFamily)
		err := b.DecodeMessage(msg)
		m.Mutation = &Mutation_DeleteFromFamily_{msg}
		return true, err
	case 4: // mutation.delete_from_row
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Mutation_DeleteFromRow)
		err := b.DecodeMessage(msg)
		m.Mutation = &Mutation_DeleteFromRow_{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Mutation_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Mutation)
	// mutation
	switch x := m.Mutation.(type) {
	case *Mutation_SetCell_:
		s := proto.Size(x.SetCell)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Mutation_DeleteFromColumn_:
		s := proto.Size(x.DeleteFromColumn)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Mutation_DeleteFromFamily_:
		s := proto.Size(x.DeleteFromFamily)
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Mutation_DeleteFromRow_:
		s := proto.Size(x.DeleteFromRow)
		n += proto.SizeVarint(4<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// A Mutation which sets the value of the specified cell.
type Mutation_SetCell struct {
	// The name of the family into which new data should be written.
	// Must match `[-_.a-zA-Z0-9]+`
	FamilyName string `protobuf:"bytes,1,opt,name=family_name,json=familyName" json:"family_name,omitempty"`
	// The qualifier of the column into which new data should be written.
	// Can be any byte string, including the empty string.
	ColumnQualifier []byte `protobuf:"bytes,2,opt,name=column_qualifier,json=columnQualifier,proto3" json:"column_qualifier,omitempty"`
	// The timestamp of the cell into which new data should be written.
	// Use -1 for current Bigtable server time.
	// Otherwise, the client should set this value itself, noting that the
	// default value is a timestamp of zero if the field is left unspecified.
	// Values must match the granularity of the table (e.g. micros, millis).
	TimestampMicros int64 `protobuf:"varint,3,opt,name=timestamp_micros,json=timestampMicros" json:"timestamp_micros,omitempty"`
	// The value to be written into the specified cell.
	Value []byte `protobuf:"bytes,4,opt,name=value,proto3" json:"value,omitempty"`
}

func (m *Mutation_SetCell) Reset()                    { *m = Mutation_SetCell{} }
func (m *Mutation_SetCell) String() string            { return proto.CompactTextString(m) }
func (*Mutation_SetCell) ProtoMessage()               {}
func (*Mutation_SetCell) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{10, 0} }

func (m *Mutation_SetCell) GetFamilyName() string {
	if m != nil {
		return m.FamilyName
	}
	return ""
}

func (m *Mutation_SetCell) GetColumnQualifier() []byte {
	if m != nil {
		return m.ColumnQualifier
	}
	return nil
}

func (m *Mutation_SetCell) GetTimestampMicros() int64 {
	if m != nil {
		return m.TimestampMicros
	}
	return 0
}

func (m *Mutation_SetCell) GetValue() []byte {
	if m != nil {
		return m.Value
	}
	return nil
}

// A Mutation which deletes cells from the specified column, optionally
// restricting the deletions to a given timestamp range.
type Mutation_DeleteFromColumn struct {
	// The name of the family from which cells should be deleted.
	// Must match `[-_.a-zA-Z0-9]+`
	FamilyName string `protobuf:"bytes,1,opt,name=family_name,json=familyName" json:"family_name,omitempty"`
	// The qualifier of the column from which cells should be deleted.
	// Can be any byte string, including the empty string.
	ColumnQualifier []byte `protobuf:"bytes,2,opt,name=column_qualifier,json=columnQualifier,proto3" json:"column_qualifier,omitempty"`
	// The range of timestamps within which cells should be deleted.
	TimeRange *TimestampRange `protobuf:"bytes,3,opt,name=time_range,json=timeRange" json:"time_range,omitempty"`
}

func (m *Mutation_DeleteFromColumn) Reset()                    { *m = Mutation_DeleteFromColumn{} }
func (m *Mutation_DeleteFromColumn) String() string            { return proto.CompactTextString(m) }
func (*Mutation_DeleteFromColumn) ProtoMessage()               {}
func (*Mutation_DeleteFromColumn) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{10, 1} }

func (m *Mutation_DeleteFromColumn) GetFamilyName() string {
	if m != nil {
		return m.FamilyName
	}
	return ""
}

func (m *Mutation_DeleteFromColumn) GetColumnQualifier() []byte {
	if m != nil {
		return m.ColumnQualifier
	}
	return nil
}

func (m *Mutation_DeleteFromColumn) GetTimeRange() *TimestampRange {
	if m != nil {
		return m.TimeRange
	}
	return nil
}

// A Mutation which deletes all cells from the specified column family.
type Mutation_DeleteFromFamily struct {
	// The name of the family from which cells should be deleted.
	// Must match `[-_.a-zA-Z0-9]+`
	FamilyName string `protobuf:"bytes,1,opt,name=family_name,json=familyName" json:"family_name,omitempty"`
}

func (m *Mutation_DeleteFromFamily) Reset()                    { *m = Mutation_DeleteFromFamily{} }
func (m *Mutation_DeleteFromFamily) String() string            { return proto.CompactTextString(m) }
func (*Mutation_DeleteFromFamily) ProtoMessage()               {}
func (*Mutation_DeleteFromFamily) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{10, 2} }

func (m *Mutation_DeleteFromFamily) GetFamilyName() string {
	if m != nil {
		return m.FamilyName
	}
	return ""
}

// A Mutation which deletes all cells from the containing row.
type Mutation_DeleteFromRow struct {
}

func (m *Mutation_DeleteFromRow) Reset()                    { *m = Mutation_DeleteFromRow{} }
func (m *Mutation_DeleteFromRow) String() string            { return proto.CompactTextString(m) }
func (*Mutation_DeleteFromRow) ProtoMessage()               {}
func (*Mutation_DeleteFromRow) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{10, 3} }

// Specifies an atomic read/modify/write operation on the latest value of the
// specified column.
type ReadModifyWriteRule struct {
	// The name of the family to which the read/modify/write should be applied.
	// Must match `[-_.a-zA-Z0-9]+`
	FamilyName string `protobuf:"bytes,1,opt,name=family_name,json=familyName" json:"family_name,omitempty"`
	// The qualifier of the column to which the read/modify/write should be
	// applied.
	// Can be any byte string, including the empty string.
	ColumnQualifier []byte `protobuf:"bytes,2,opt,name=column_qualifier,json=columnQualifier,proto3" json:"column_qualifier,omitempty"`
	// The rule used to determine the column's new latest value from its current
	// latest value.
	//
	// Types that are valid to be assigned to Rule:
	//	*ReadModifyWriteRule_AppendValue
	//	*ReadModifyWriteRule_IncrementAmount
	Rule isReadModifyWriteRule_Rule `protobuf_oneof:"rule"`
}

func (m *ReadModifyWriteRule) Reset()                    { *m = ReadModifyWriteRule{} }
func (m *ReadModifyWriteRule) String() string            { return proto.CompactTextString(m) }
func (*ReadModifyWriteRule) ProtoMessage()               {}
func (*ReadModifyWriteRule) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{11} }

type isReadModifyWriteRule_Rule interface {
	isReadModifyWriteRule_Rule()
}

type ReadModifyWriteRule_AppendValue struct {
	AppendValue []byte `protobuf:"bytes,3,opt,name=append_value,json=appendValue,proto3,oneof"`
}
type ReadModifyWriteRule_IncrementAmount struct {
	IncrementAmount int64 `protobuf:"varint,4,opt,name=increment_amount,json=incrementAmount,oneof"`
}

func (*ReadModifyWriteRule_AppendValue) isReadModifyWriteRule_Rule()     {}
func (*ReadModifyWriteRule_IncrementAmount) isReadModifyWriteRule_Rule() {}

func (m *ReadModifyWriteRule) GetRule() isReadModifyWriteRule_Rule {
	if m != nil {
		return m.Rule
	}
	return nil
}

func (m *ReadModifyWriteRule) GetFamilyName() string {
	if m != nil {
		return m.FamilyName
	}
	return ""
}

func (m *ReadModifyWriteRule) GetColumnQualifier() []byte {
	if m != nil {
		return m.ColumnQualifier
	}
	return nil
}

func (m *ReadModifyWriteRule) GetAppendValue() []byte {
	if x, ok := m.GetRule().(*ReadModifyWriteRule_AppendValue); ok {
		return x.AppendValue
	}
	return nil
}

func (m *ReadModifyWriteRule) GetIncrementAmount() int64 {
	if x, ok := m.GetRule().(*ReadModifyWriteRule_IncrementAmount); ok {
		return x.IncrementAmount
	}
	return 0
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*ReadModifyWriteRule) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _ReadModifyWriteRule_OneofMarshaler, _ReadModifyWriteRule_OneofUnmarshaler, _ReadModifyWriteRule_OneofSizer, []interface{}{
		(*ReadModifyWriteRule_AppendValue)(nil),
		(*ReadModifyWriteRule_IncrementAmount)(nil),
	}
}

func _ReadModifyWriteRule_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*ReadModifyWriteRule)
	// rule
	switch x := m.Rule.(type) {
	case *ReadModifyWriteRule_AppendValue:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.AppendValue)
	case *ReadModifyWriteRule_IncrementAmount:
		b.EncodeVarint(4<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.IncrementAmount))
	case nil:
	default:
		return fmt.Errorf("ReadModifyWriteRule.Rule has unexpected type %T", x)
	}
	return nil
}

func _ReadModifyWriteRule_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*ReadModifyWriteRule)
	switch tag {
	case 3: // rule.append_value
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.Rule = &ReadModifyWriteRule_AppendValue{x}
		return true, err
	case 4: // rule.increment_amount
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Rule = &ReadModifyWriteRule_IncrementAmount{int64(x)}
		return true, err
	default:
		return false, nil
	}
}

func _ReadModifyWriteRule_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*ReadModifyWriteRule)
	// rule
	switch x := m.Rule.(type) {
	case *ReadModifyWriteRule_AppendValue:
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.AppendValue)))
		n += len(x.AppendValue)
	case *ReadModifyWriteRule_IncrementAmount:
		n += proto.SizeVarint(4<<3 | proto.WireVarint)
		n += proto.SizeVarint(uint64(x.IncrementAmount))
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

func init() {
	proto.RegisterType((*Row)(nil), "google.bigtable.v2.Row")
	proto.RegisterType((*Family)(nil), "google.bigtable.v2.Family")
	proto.RegisterType((*Column)(nil), "google.bigtable.v2.Column")
	proto.RegisterType((*Cell)(nil), "google.bigtable.v2.Cell")
	proto.RegisterType((*RowRange)(nil), "google.bigtable.v2.RowRange")
	proto.RegisterType((*RowSet)(nil), "google.bigtable.v2.RowSet")
	proto.RegisterType((*ColumnRange)(nil), "google.bigtable.v2.ColumnRange")
	proto.RegisterType((*TimestampRange)(nil), "google.bigtable.v2.TimestampRange")
	proto.RegisterType((*ValueRange)(nil), "google.bigtable.v2.ValueRange")
	proto.RegisterType((*RowFilter)(nil), "google.bigtable.v2.RowFilter")
	proto.RegisterType((*RowFilter_Chain)(nil), "google.bigtable.v2.RowFilter.Chain")
	proto.RegisterType((*RowFilter_Interleave)(nil), "google.bigtable.v2.RowFilter.Interleave")
	proto.RegisterType((*RowFilter_Condition)(nil), "google.bigtable.v2.RowFilter.Condition")
	proto.RegisterType((*Mutation)(nil), "google.bigtable.v2.Mutation")
	proto.RegisterType((*Mutation_SetCell)(nil), "google.bigtable.v2.Mutation.SetCell")
	proto.RegisterType((*Mutation_DeleteFromColumn)(nil), "google.bigtable.v2.Mutation.DeleteFromColumn")
	proto.RegisterType((*Mutation_DeleteFromFamily)(nil), "google.bigtable.v2.Mutation.DeleteFromFamily")
	proto.RegisterType((*Mutation_DeleteFromRow)(nil), "google.bigtable.v2.Mutation.DeleteFromRow")
	proto.RegisterType((*ReadModifyWriteRule)(nil), "google.bigtable.v2.ReadModifyWriteRule")
}

func init() { proto.RegisterFile("google/bigtable/v2/data.proto", fileDescriptor1) }

var fileDescriptor1 = []byte{
	// 1430 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x57, 0xdd, 0x6e, 0x1b, 0x45,
	0x14, 0xf6, 0xc6, 0x89, 0x7f, 0xce, 0x3a, 0xb6, 0x3b, 0x4d, 0x53, 0xd7, 0x34, 0x34, 0xda, 0xa2,
	0xe2, 0x06, 0x70, 0xc0, 0xad, 0xca, 0x4f, 0x11, 0x6a, 0x9c, 0xd2, 0x1a, 0xfa, 0x3f, 0x8d, 0x8a,
	0x54, 0x09, 0x2d, 0x13, 0x7b, 0x6c, 0x56, 0x99, 0xdd, 0x59, 0x76, 0xd7, 0x71, 0x2d, 0xf1, 0x1c,
	0xdc, 0xc3, 0x25, 0xaf, 0xc0, 0x1d, 0x2f, 0x01, 0x8f, 0xc1, 0x03, 0x70, 0x81, 0xe6, 0x67, 0xff,
	0x5c, 0x37, 0x89, 0x50, 0xef, 0x76, 0xcf, 0xf9, 0xbe, 0xef, 0x9c, 0x39, 0x73, 0xe6, 0xec, 0x2c,
	0x6c, 0x4d, 0x38, 0x9f, 0x30, 0xba, 0x7b, 0xe8, 0x4c, 0x22, 0x72, 0xc8, 0xe8, 0xee, 0x71, 0x6f,
	0x77, 0x44, 0x22, 0xd2, 0xf5, 0x03, 0x1e, 0x71, 0x84, 0x94, 0xbb, 0x1b, 0xbb, 0xbb, 0xc7, 0x3d,
	0xeb, 0x09, 0x14, 0x31, 0x9f, 0xa1, 0x26, 0x14, 0x8f, 0xe8, 0xbc, 0x65, 0x6c, 0x1b, 0x9d, 0x1a,
	0x16, 0x8f, 0xe8, 0x16, 0x54, 0xc6, 0xc4, 0x75, 0x98, 0x43, 0xc3, 0xd6, 0xca, 0x76, 0xb1, 0x63,
	0xf6, 0xda, 0xdd, 0xd7, 0xf9, 0xdd, 0x7b, 0x02, 0x33, 0xc7, 0x09, 0xd6, 0xc2, 0x50, 0x52, 0x36,
	0x84, 0x60, 0xd5, 0x23, 0x2e, 0x95, 0xa2, 0x55, 0x2c, 0x9f, 0xd1, 0x4d, 0x28, 0x0f, 0x39, 0x9b,
	0xba, 0xde, 0x89, 0xa2, 0xfb, 0x12, 0x82, 0x63, 0xa8, 0xf5, 0x02, 0x4a, 0xca, 0x84, 0x2e, 0x43,
	0xf5, 0xa7, 0x29, 0x61, 0xce, 0xd8, 0xa1, 0x81, 0xce, 0x36, 0x35, 0xa0, 0x2e, 0xac, 0x0d, 0x29,
	0x63, 0xb1, 0x76, 0x6b, 0xa9, 0x36, 0x65, 0x0c, 0x2b, 0x98, 0x65, 0xc3, 0xaa, 0x78, 0x45, 0xd7,
	0xa1, 0x19, 0x39, 0x2e, 0x0d, 0x23, 0xe2, 0xfa, 0xb6, 0xeb, 0x0c, 0x03, 0x1e, 0x4a, 0xf1, 0x22,
	0x6e, 0x24, 0xf6, 0x47, 0xd2, 0x8c, 0x36, 0x60, 0xed, 0x98, 0xb0, 0x29, 0x6d, 0xad, 0xc8, 0xe0,
	0xea, 0x05, 0x6d, 0x42, 0x89, 0x91, 0x43, 0xca, 0xc2, 0x56, 0x71, 0xbb, 0xd8, 0xa9, 0x62, 0xfd,
	0x66, 0xfd, 0x69, 0x40, 0x05, 0xf3, 0x19, 0x26, 0xde, 0x84, 0xa2, 0x1d, 0x68, 0x86, 0x11, 0x09,
	0x22, 0xfb, 0x88, 0xce, 0xed, 0x21, 0xe3, 0x21, 0x1d, 0xa9, 0x25, 0x0c, 0x0a, 0xb8, 0x2e, 0x3d,
	0x0f, 0xe8, 0x7c, 0x5f, 0xda, 0xd1, 0x35, 0xa8, 0xa7, 0x58, 0xee, 0x53, 0x4f, 0xc5, 0x1b, 0x14,
	0x70, 0x2d, 0x46, 0x3e, 0xf1, 0xa9, 0x87, 0x2c, 0xa8, 0x51, 0x6f, 0x94, 0xa2, 0x8a, 0x12, 0x65,
	0x60, 0xa0, 0xde, 0x28, 0xc6, 0x5c, 0x83, 0x7a, 0x8c, 0xd1, 0x51, 0x57, 0x35, 0xaa, 0xa6, 0x50,
	0x2a, 0x66, 0xdf, 0x84, 0x6a, 0x12, 0xb3, 0x5f, 0x85, 0xb2, 0x26, 0x59, 0x3f, 0x40, 0x09, 0xf3,
	0xd9, 0x73, 0x1a, 0xa1, 0x4b, 0x50, 0x09, 0xf8, 0x4c, 0x18, 0x45, 0x7d, 0x8a, 0x9d, 0x1a, 0x2e,
	0x07, 0x7c, 0xf6, 0x80, 0xce, 0x43, 0x74, 0x1b, 0x40, 0xb8, 0x02, 0xb1, 0xd2, 0xb8, 0xfe, 0x97,
	0x97, 0xd5, 0x3f, 0x2e, 0x07, 0xae, 0x06, 0xfa, 0x29, 0xb4, 0x7e, 0x5b, 0x01, 0x53, 0xef, 0xb9,
	0xac, 0xd4, 0x15, 0x30, 0x65, 0x3f, 0xcd, 0xed, 0x4c, 0x03, 0x81, 0x32, 0x3d, 0x16, 0x6d, 0x74,
	0x0b, 0x36, 0x55, 0xaa, 0xc9, 0xde, 0xc7, 0x4b, 0x8b, 0xcb, 0xb4, 0x21, 0xfd, 0xcf, 0x62, 0xb7,
	0x2e, 0x6b, 0x0f, 0x36, 0x16, 0x79, 0x99, 0xb2, 0x15, 0x30, 0xca, 0xb3, 0x64, 0xf9, 0x7a, 0xb0,
	0x21, 0x2a, 0xf1, 0x5a, 0xa4, 0xb8, 0x88, 0x88, 0x7a, 0xa3, 0xc5, 0x38, 0x5d, 0x40, 0x79, 0x8e,
	0x8c, 0xb2, 0xa6, 0x19, 0xcd, 0x2c, 0x43, 0xc4, 0xe8, 0x9f, 0x83, 0xc6, 0x42, 0x5e, 0xfd, 0x06,
	0xac, 0xe7, 0x24, 0xac, 0x57, 0x50, 0x3f, 0x88, 0x9b, 0x51, 0x95, 0xe9, 0x66, 0x5c, 0x85, 0x37,
	0x34, 0xaf, 0x5a, 0xeb, 0xc1, 0x42, 0x07, 0x7f, 0xac, 0xd6, 0xf3, 0x1a, 0x67, 0x45, 0x72, 0x44,
	0xde, 0x0b, 0x0c, 0xeb, 0x6f, 0x03, 0xe0, 0x85, 0xe8, 0x73, 0x15, 0xb6, 0x0b, 0xaa, 0x4c, 0xb6,
	0xec, 0xfd, 0xc5, 0x4e, 0x56, 0x3d, 0x2e, 0xe1, 0xba, 0x18, 0x49, 0xdf, 0x2b, 0x7c, 0xae, 0x9b,
	0xeb, 0x29, 0x5a, 0x16, 0x7b, 0x07, 0x44, 0x71, 0xf2, 0xca, 0x71, 0x4f, 0x8b, 0x2e, 0xce, 0xea,
	0xea, 0xbe, 0xce, 0xa8, 0x66, 0xfb, 0x3a, 0xd1, 0xec, 0xaf, 0x83, 0x99, 0x89, 0x2f, 0xda, 0x3c,
	0xa1, 0x59, 0xff, 0x9a, 0x50, 0xc5, 0x7c, 0x76, 0xcf, 0x61, 0x11, 0x0d, 0xd0, 0x6d, 0x58, 0x1b,
	0xfe, 0x48, 0x1c, 0x4f, 0x2e, 0xc6, 0xec, 0x5d, 0x7d, 0x43, 0xff, 0x2a, 0x74, 0x77, 0x5f, 0x40,
	0x07, 0x05, 0xac, 0x38, 0xe8, 0x5b, 0x00, 0xc7, 0x8b, 0x68, 0xc0, 0x28, 0x39, 0x56, 0xe3, 0xc1,
	0xec, 0x75, 0x4e, 0x56, 0xf8, 0x26, 0xc1, 0x0f, 0x0a, 0x38, 0xc3, 0x46, 0xf7, 0xa1, 0x3a, 0xe4,
	0xde, 0xc8, 0x89, 0x1c, 0xae, 0x9a, 0xd3, 0xec, 0xbd, 0x7f, 0x4a, 0x32, 0x31, 0x7c, 0x50, 0xc0,
	0x29, 0x17, 0x6d, 0xc0, 0x6a, 0xe8, 0x78, 0x47, 0xad, 0xe6, 0xb6, 0xd1, 0xa9, 0x0c, 0x0a, 0x58,
	0xbe, 0xa1, 0x0e, 0x34, 0x7c, 0x12, 0x86, 0x36, 0x61, 0xcc, 0x1e, 0x4b, 0x7e, 0xeb, 0x9c, 0x06,
	0xac, 0x0b, 0xc7, 0x1e, 0x63, 0xba, 0x22, 0x3b, 0xd0, 0x3c, 0x64, 0x7c, 0x78, 0x94, 0x85, 0x22,
	0x0d, 0xad, 0x4b, 0x4f, 0x8a, 0xfd, 0x04, 0x36, 0xf4, 0x74, 0xb0, 0x03, 0x3a, 0xa1, 0xaf, 0x62,
	0xfc, 0xaa, 0xde, 0xeb, 0x73, 0x6a, 0x56, 0x60, 0xe1, 0xd3, 0x94, 0x0f, 0x41, 0x18, 0xed, 0x90,
	0xb8, 0x3e, 0xa3, 0x31, 0xbe, 0xbe, 0x6d, 0x74, 0x8c, 0x41, 0x01, 0x37, 0x02, 0x3e, 0x7b, 0x2e,
	0x3d, 0x1a, 0xfd, 0x39, 0xb4, 0x32, 0x63, 0x21, 0x1f, 0x44, 0x9c, 0xad, 0xea, 0xa0, 0x80, 0x2f,
	0xa4, 0x53, 0x22, 0x1b, 0x68, 0x1f, 0xb6, 0xd4, 0xc7, 0x24, 0x73, 0x26, 0x73, 0xfc, 0x92, 0x4e,
	0xb2, 0xad, 0x60, 0xc9, 0xf1, 0xcc, 0x8a, 0x3c, 0x83, 0xf3, 0x5a, 0x44, 0x8e, 0xb9, 0x98, 0x5a,
	0x96, 0xfb, 0x73, 0xe5, 0x84, 0x0f, 0x99, 0x40, 0x8b, 0x02, 0x0c, 0xd3, 0x57, 0x2d, 0xf9, 0x12,
	0x36, 0xd3, 0x83, 0x98, 0x53, 0xad, 0x48, 0x55, 0x6b, 0x99, 0x6a, 0x7e, 0x0c, 0x88, 0x61, 0x17,
	0xe5, 0x2c, 0x5a, 0xbb, 0x0b, 0x48, 0x9d, 0x8d, 0xdc, 0x42, 0xab, 0xf1, 0x39, 0x95, 0xbe, 0xec,
	0xf2, 0x1e, 0x27, 0xf8, 0x6c, 0x1e, 0x0d, 0x99, 0xc7, 0xbb, 0xcb, 0xf2, 0x48, 0x67, 0x42, 0xaa,
	0x97, 0x89, 0xff, 0x15, 0xbc, 0x23, 0x3f, 0xb3, 0xb6, 0x2f, 0x8a, 0xcd, 0x67, 0x36, 0x1f, 0x8f,
	0x43, 0x1a, 0xc5, 0xc2, 0xb0, 0x6d, 0x74, 0xd6, 0x06, 0x05, 0x7c, 0x51, 0x82, 0x9e, 0xd2, 0x00,
	0xf3, 0xd9, 0x13, 0x89, 0xd0, 0xfc, 0x2f, 0xa1, 0x9d, 0xe7, 0x33, 0xc7, 0x75, 0x12, 0xba, 0xa9,
	0xe9, 0x9b, 0x19, 0xfa, 0x43, 0x01, 0xd0, 0xec, 0x3e, 0x6c, 0xa5, 0x6c, 0xbd, 0x6d, 0x39, 0x81,
	0x9a, 0x16, 0xb8, 0x14, 0x0b, 0xa8, 0xcd, 0xca, 0x6a, 0x7c, 0x06, 0x17, 0xc3, 0x28, 0x70, 0x7c,
	0x3d, 0x63, 0xa2, 0x80, 0x78, 0xe1, 0x98, 0x07, 0x2e, 0x0d, 0x5a, 0xeb, 0xfa, 0x10, 0x5c, 0x90,
	0x00, 0x59, 0x89, 0x83, 0xd4, 0x2d, 0x98, 0xc4, 0xf7, 0xd9, 0xdc, 0x96, 0x17, 0x81, 0x1c, 0xf3,
	0x7c, 0xdc, 0xa9, 0x12, 0xf0, 0x50, 0xf8, 0x33, 0xcc, 0xf6, 0x1d, 0x58, 0x93, 0x83, 0x05, 0x7d,
	0x0a, 0x65, 0x95, 0xa9, 0xfa, 0xd6, 0x9a, 0xbd, 0xad, 0x13, 0x27, 0x00, 0x8e, 0xd1, 0xed, 0xaf,
	0x01, 0xd2, 0xc1, 0xf2, 0xff, 0x65, 0xfe, 0x32, 0xa0, 0x9a, 0x4c, 0x15, 0x34, 0x80, 0xa6, 0x1f,
	0xd0, 0x91, 0x33, 0x24, 0x51, 0xd2, 0x1a, 0x6a, 0x4a, 0x9e, 0xa2, 0xd7, 0x48, 0x68, 0x49, 0x5b,
	0x98, 0x51, 0x30, 0x4d, 0x44, 0x56, 0xce, 0x22, 0x02, 0x82, 0xa1, 0xf9, 0x77, 0xa0, 0x36, 0x26,
	0x2c, 0x4c, 0x04, 0x8a, 0x67, 0x11, 0x30, 0x25, 0x45, 0xbd, 0xf4, 0x2b, 0x50, 0x52, 0x5c, 0xeb,
	0x9f, 0x35, 0xa8, 0x3c, 0x9a, 0x46, 0x44, 0x2e, 0x71, 0x0f, 0x2a, 0xa2, 0x3d, 0x45, 0x3b, 0xe8,
	0xa5, 0xbd, 0xb7, 0x4c, 0x34, 0xc6, 0x77, 0x9f, 0xd3, 0x48, 0xdc, 0x1e, 0x07, 0x05, 0x5c, 0x0e,
	0xd5, 0x23, 0xfa, 0x1e, 0xd0, 0x88, 0x32, 0x2a, 0x4a, 0x14, 0x70, 0x57, 0xb7, 0x9d, 0x5e, 0xe2,
	0x47, 0x27, 0x8a, 0xdd, 0x95, 0xb4, 0x7b, 0x01, 0x77, 0x55, 0x1b, 0x8a, 0x13, 0x35, 0x5a, 0xb0,
	0x2d, 0xca, 0xab, 0x51, 0xa7, 0x0b, 0x70, 0x56, 0x79, 0x75, 0x39, 0xcf, 0xcb, 0xeb, 0x0b, 0xfb,
	0x01, 0x34, 0xb2, 0xf2, 0x01, 0x9f, 0xc9, 0xd9, 0x6d, 0xf6, 0x76, 0xce, 0xa8, 0x8d, 0xf9, 0x4c,
	0x7c, 0x42, 0x46, 0x59, 0x43, 0xfb, 0x17, 0x03, 0xca, 0xba, 0x54, 0xa7, 0x5f, 0xec, 0xae, 0x43,
	0x73, 0x71, 0x4e, 0xeb, 0x9b, 0x76, 0x63, 0x61, 0x30, 0x2f, 0xbd, 0xb4, 0x17, 0x4f, 0xb9, 0xb4,
	0xaf, 0x66, 0x2e, 0xed, 0xed, 0x5f, 0x0d, 0x68, 0x2e, 0x96, 0xfd, 0xad, 0x66, 0xb8, 0x07, 0x20,
	0x32, 0x51, 0xf3, 0x54, 0x6f, 0xd3, 0x19, 0x06, 0x3a, 0xae, 0x0a, 0x96, 0x7c, 0x6c, 0xdf, 0xc8,
	0xa6, 0xa8, 0xb7, 0xe9, 0xb4, 0x14, 0xdb, 0x0d, 0x58, 0xcf, 0xed, 0x49, 0x1f, 0xa0, 0xe2, 0xea,
	0xdd, 0xb2, 0xfe, 0x30, 0xe0, 0x3c, 0xa6, 0x64, 0xf4, 0x88, 0x8f, 0x9c, 0xf1, 0xfc, 0xbb, 0xc0,
	0x89, 0x28, 0x9e, 0x32, 0xfa, 0x56, 0x17, 0x7e, 0x15, 0x6a, 0xc4, 0xf7, 0x93, 0x5b, 0x56, 0x72,
	0xbd, 0x36, 0x95, 0x55, 0x4e, 0x4b, 0xf4, 0x01, 0x34, 0x1d, 0x6f, 0x18, 0x50, 0x97, 0x7a, 0x91,
	0x4d, 0x5c, 0x3e, 0xf5, 0x22, 0xb9, 0x3f, 0x45, 0xf1, 0xe9, 0x4f, 0x3c, 0x7b, 0xd2, 0xd1, 0x2f,
	0xc1, 0x6a, 0x30, 0x65, 0xb4, 0xff, 0x33, 0x6c, 0x0e, 0xb9, 0xbb, 0xa4, 0x86, 0xfd, 0xea, 0x5d,
	0x12, 0x91, 0xa7, 0xe2, 0x3f, 0xf7, 0xa9, 0xf1, 0xf2, 0x0b, 0x0d, 0x98, 0x70, 0x46, 0xbc, 0x49,
	0x97, 0x07, 0x93, 0xdd, 0x09, 0xf5, 0xe4, 0x5f, 0xf0, 0xae, 0x72, 0x11, 0xdf, 0x09, 0xb3, 0xff,
	0xc9, 0xb7, 0xe3, 0xe7, 0xdf, 0x57, 0x5a, 0xf7, 0x15, 0x79, 0x9f, 0xf1, 0xe9, 0xa8, 0xdb, 0x8f,
	0x63, 0xbc, 0xe8, 0x1d, 0x96, 0xa4, 0xc2, 0x8d, 0xff, 0x02, 0x00, 0x00, 0xff, 0xff, 0x32, 0x40,
	0x30, 0x5e, 0x68, 0x0f, 0x00, 0x00,
}
