/*
 *  Breeze  --  An application launcher with command-line style
 *  Copyright (C) 2005, 2006, 2008 Hironao Komatsu
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef EDITORWIN_H_INCLUDED
#define EDITORWIN_H_INCLUDED

#include <gtk/gtk.h>

G_BEGIN_DECLS

#define TYPE_EDITOR_WIN (editor_win_get_type())
#define EDITOR_WIN(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_EDITOR_WIN, EditorWin))
#define EDITOR_WIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_EDITOR_WIN, EditorWinClass))
#define IS_EDITOR_WIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_EDITOR_WIN))
#define IS_EDITOR_WIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_EDITOR_WIN))
#define EDITOR_WIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_EDITOR_WIN, EditorWinClass))

typedef struct _EditorWin EditorWin;
struct _EditorWin {
  GtkDialog parent;
  GtkWidget *treeview;
  gboolean is_edited;
};

typedef struct _EditorWinClass EditorWinClass;
struct _EditorWinClass {
  GtkDialogClass parent;
};

GType editor_win_get_type(void);

GtkWidget *editor_win_new(void);

void editor_win_save_changes(EditorWin *w);

G_END_DECLS

#endif
