/*
 *  Breeze  --  An application launcher with command-line style
 *  Copyright (C) 2005, 2006, 2008 Hironao Komatsu
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include <glib/gi18n.h>
#include <glib/gprintf.h>
#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>

#include "registwin.h"
#include "user_commands.h"

static void regist_win_class_init(RegistWinClass *klass);
static void regist_win_init(RegistWin *self);
static void entry_activate_callback(GtkWidget *w, gpointer user_data);
static void fileSelectButton_clicked_callback(GtkWidget *w, gpointer user_data);
static void registwin_response_callback(GtkWidget *w, gint response_id,
					gpointer user_data);

GType regist_win_get_type()
{
  static GType type = G_TYPE_INVALID;

  if (G_UNLIKELY(type == G_TYPE_INVALID)) {
    static const GTypeInfo info = {
      sizeof(RegistWinClass),
      NULL,
      NULL,
      (GClassInitFunc) regist_win_class_init,
      NULL,
      NULL,
      sizeof(RegistWin),
      0,
      (GInstanceInitFunc) regist_win_init,
      NULL,
    };
    type = g_type_register_static(GTK_TYPE_DIALOG, "RegistWin", &info, 0);
  }
  return type;
}

static GtkDialogClass *parent_class = NULL;

static void regist_win_class_init(RegistWinClass *klass)
{
  parent_class = g_type_class_peek_parent(klass);
}

static void regist_win_init(RegistWin *self)
{
}

GtkWidget *regist_win_new(gchar *keyword)
{
  RegistWin *self = g_object_new(TYPE_REGIST_WIN, NULL);

  GtkWidget *hbox;
  GtkWidget *label;
  GtkWidget *fileSelectButton;
  gchar label_text[256];
  gint ins_pos;

  gtk_window_set_title(GTK_WINDOW(self), _("Register keyword"));
  gtk_container_set_border_width(GTK_CONTAINER(self), 4);

  hbox = gtk_hbox_new(FALSE, 0);

  self->keyword_to_register = g_strdup(keyword);
  g_snprintf(label_text, sizeof(label_text),
	     _("Command for \"%s\": "), self->keyword_to_register);
  label = gtk_label_new(label_text);
  gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 4);

  self->entry = gtk_entry_new();
  /* set text in self->entry and have the text selected */
  ins_pos = 0;
  gtk_editable_insert_text(GTK_EDITABLE(self->entry), self->keyword_to_register,
			   strlen(self->keyword_to_register), &ins_pos);
  gtk_editable_select_region(GTK_EDITABLE(self->entry), 0, -1);

  gtk_dialog_add_buttons(GTK_DIALOG(self),
			 GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
			 GTK_STOCK_OK, GTK_RESPONSE_OK,
			 NULL);
  fileSelectButton = gtk_button_new_with_label(N_("..."));

  g_signal_connect(self->entry, "activate",
		   G_CALLBACK(entry_activate_callback), self);
  g_signal_connect(fileSelectButton, "clicked",
		   G_CALLBACK(fileSelectButton_clicked_callback), self);

  gtk_box_pack_start(GTK_BOX(hbox), self->entry, TRUE, FALSE, 4);
  gtk_box_pack_start(GTK_BOX(hbox), fileSelectButton, FALSE, FALSE, 4);

  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(self)->vbox),
		     hbox, TRUE, TRUE, 4);

  g_signal_connect(GTK_WIDGET(self), "response",
		   G_CALLBACK(registwin_response_callback), self);

  gtk_widget_show_all(GTK_WIDGET(self));

  return GTK_WIDGET(self);
}

static void entry_activate_callback(GtkWidget *w, gpointer user_data)
{
  GtkWidget *dialog = GTK_WIDGET((RegistWin*)user_data);

  gtk_dialog_response(GTK_DIALOG(dialog), GTK_RESPONSE_OK);
}

static void fileSelectButton_clicked_callback(GtkWidget *w, gpointer user_data)
{
  RegistWin *self = (RegistWin*)user_data;
  GtkWidget *entry = self->entry;
  GtkWidget *chooser;
  gint ret;

  chooser = gtk_file_chooser_dialog_new(_("Select file"),
					GTK_WINDOW(self),
					GTK_FILE_CHOOSER_ACTION_OPEN,
					GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
					GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT,
					NULL);

  ret = gtk_dialog_run(GTK_DIALOG(chooser));

  if (ret == GTK_RESPONSE_ACCEPT) {
    gchar *path = gtk_file_chooser_get_filename(GTK_FILE_CHOOSER(chooser));
    gchar *path_utf8 = g_filename_to_utf8(path, strlen(path), NULL, NULL, NULL);
    gint pos = 0;

    gtk_editable_delete_text(GTK_EDITABLE(entry), pos, -1);
    gtk_editable_insert_text(GTK_EDITABLE(entry), path_utf8,
			     strlen(path_utf8), &pos);
    g_free(path_utf8);
    g_free(path);
  }
  gtk_widget_destroy(chooser);
}

static void registwin_response_callback(GtkWidget *w, gint response_id,
					gpointer user_data)
{
  RegistWin *self = (RegistWin*)user_data;
  gchar *command;
  gchar *command_to_register;

  if (response_id != GTK_RESPONSE_OK)
    return;

  command = g_strdup(gtk_entry_get_text(GTK_ENTRY(self->entry)));
  command_to_register = g_strstrip(command);

  if (command_to_register[0] == '\0') {
    g_warning(_("empty command.\n"));
    gtk_entry_set_text(GTK_ENTRY(self->entry), "");
    g_free(command);
    return;
  }

  if (insert_user_commands(self->keyword_to_register,
			   g_strdup(command_to_register)))
    g_warning(_("Failed to register keyword.\n"));

  g_free(command);
}

