/*
 *  Breeze  --  An application launcher with command-line style
 *  Copyright (C) 2005, 2006 Hironao Komatsu
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <ctype.h>
#include <glib.h>

#include "breeze.h"
#include "config.h"

gchar *strip(gchar *str, gboolean *is_empty)
{
  gchar *p, *q;

  for (p = str; *p && isspace(*p); p++)
    *p = '\0';
  q = p;
  for (; *p; p++);
  while (p > q && isspace(p[-1]))
    *--p = '\0';

  if (is_empty)
    *is_empty = (p == q) ? TRUE : FALSE;

  return q;
}
