/*
 *  Breeze  --  An application launcher with command-line style
 *  Copyright (C) 2005, 2006 Hironao Komatsu
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>

#include "breeze.h"
#include "config.h"

static GtkWidget *fsel;
static const gchar *selected = NULL;

static void ok_button_clicked_callback(GtkWidget *w, gpointer user_data)
{
  selected = gtk_file_selection_get_filename(GTK_FILE_SELECTION(fsel));
  gtk_main_quit();
}

static void cancel_button_clicked_callback(GtkWidget *w, gpointer user_data)
{
  gtk_main_quit();
}

static void delete_event_callback(GtkWidget *w, gpointer user_data)
{
  gtk_main_quit();
}

const gchar *select_file(const gchar *title)
{
  GtkAccelGroup *accel;

  fsel = gtk_file_selection_new(title);

  gtk_file_selection_hide_fileop_buttons(GTK_FILE_SELECTION(fsel));
  g_signal_connect(GTK_FILE_SELECTION(fsel)->ok_button, "clicked",
		   G_CALLBACK(ok_button_clicked_callback), NULL);
  g_signal_connect(GTK_FILE_SELECTION(fsel)->cancel_button, "clicked",
		   G_CALLBACK(cancel_button_clicked_callback), NULL);
  g_signal_connect(GTK_WINDOW(fsel), "delete_event",
		   G_CALLBACK(delete_event_callback), NULL);

  accel = gtk_accel_group_new();
  gtk_window_add_accel_group(GTK_WINDOW(fsel), accel);
  gtk_widget_add_accelerator(GTK_FILE_SELECTION(fsel)->cancel_button,
			     "clicked", accel, GDK_Escape, 0, 0);

  gtk_widget_show(fsel);
  gtk_grab_add(fsel);
  gtk_main();
  gtk_grab_remove(fsel);

  gtk_widget_destroy(fsel);

  return selected;
}
