/*
 *  Breeze  --  An application launcher with command-line style
 *  Copyright (C) 2005, 2006 Hironao Komatsu
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include <glib.h>

#include "breeze.h"
#include "config.h"

static GtkWidget *dialog;
static GtkWidget *entry;
static gchar *keyword_to_regist = NULL;

static void delete_event_callback(GtkWidget *w, gpointer user_data)
{
  if (keyword_to_regist)
    g_free(keyword_to_regist);
  gtk_widget_destroy(dialog);
  gtk_main_quit();
}

static void entry_activate_callback(GtkWidget *w, gpointer user_data)
{
  gchar *command = g_strdup(gtk_entry_get_text(GTK_ENTRY(entry)));
  gchar *command_to_regist;
  gboolean is_empty;

  command_to_regist = strip(command, &is_empty);

  if (is_empty) {
    fprintf(stderr, "warning: empty command.\n");
    gtk_entry_set_text(GTK_ENTRY(entry), "");
    g_free(command);
    return;
  }

  command_to_regist = g_strdup(command_to_regist);

  g_free(command);

  if (insert_user_commands(keyword_to_regist, command_to_regist)) {
    fprintf(stderr, "Failed to regist keyword.\n");
    g_free(command_to_regist);
  }
  else
    keyword_to_regist = NULL;

  delete_event_callback(dialog, NULL);
}

static void okButton_clicked_callback(GtkWidget *w, gpointer user_data)
{
  entry_activate_callback(entry, NULL);
}

static void fileSelectButton_clicked_callback(GtkWidget *w, gpointer user_data)
{
  const gchar *selected = select_file("Select file");

  if (selected) {
    gint pos = gtk_editable_get_position(GTK_EDITABLE(entry));
    gtk_editable_insert_text(GTK_EDITABLE(entry), selected,
			     strlen(selected), &pos);
  }
}

static int registwin_new(const gchar *keyword)
{
  GtkWidget *hbox;
  GtkWidget *label;
  GtkWidget *okButton;
  GtkWidget *cancelButton;
  GtkWidget *fileSelectButton;
  GtkAccelGroup *accel;
  char label_text[256];

  dialog = gtk_dialog_new();

  gtk_window_set_title(GTK_WINDOW(dialog), "Regist keyword");
  gtk_container_set_border_width(GTK_CONTAINER(dialog), 4);

  keyword_to_regist = g_strdup(keyword);
  snprintf(label_text, sizeof(label_text),
	   "Command for \"%s\": ", keyword_to_regist);
  label = gtk_label_new(label_text);

  entry = gtk_entry_new();
  hbox = gtk_hbox_new(FALSE, 0);
  okButton = gtk_button_new_with_label("OK");
  cancelButton = gtk_button_new_with_label("Cancel");
  fileSelectButton = gtk_button_new_with_label("...");

  g_signal_connect(dialog, "delete_event",
		   G_CALLBACK(delete_event_callback), NULL);
  g_signal_connect(cancelButton, "clicked",
		   G_CALLBACK(delete_event_callback), NULL);
  g_signal_connect(okButton, "clicked",
		   G_CALLBACK(okButton_clicked_callback), NULL);
  g_signal_connect(entry, "activate",
		   G_CALLBACK(entry_activate_callback), NULL);
  g_signal_connect(fileSelectButton, "clicked",
		   G_CALLBACK(fileSelectButton_clicked_callback), NULL);

  gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 4);
  gtk_box_pack_start(GTK_BOX(hbox), entry, TRUE, FALSE, 4);
  gtk_box_pack_start(GTK_BOX(hbox), fileSelectButton, FALSE, FALSE, 4);

  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox),
		     hbox, TRUE, TRUE, 4);
  gtk_box_pack_end(GTK_BOX(GTK_DIALOG(dialog)->action_area),
		   cancelButton, FALSE, FALSE, 4);
  gtk_box_pack_end(GTK_BOX(GTK_DIALOG(dialog)->action_area),
		   okButton, FALSE, FALSE, 4);

  accel = gtk_accel_group_new();
  gtk_window_add_accel_group(GTK_WINDOW(dialog), accel);
  gtk_widget_add_accelerator(cancelButton, "clicked", accel, GDK_Escape, 0, 0);

  gtk_widget_show_all(dialog);

  return 0;
}

int popup_registwin(const gchar *keyword)
{
  registwin_new(keyword);

  return 0;
}
