# $Id: bos_pg.rb,v 1.25 2005/06/16 22:18:41 nisi Exp $

# pagegen Ϣ
def pre_bos_pg_init
	return nil unless Request["p"]
	@pagen = BosPagegen.new(Request["p"]) unless @pagen
	@wikip = WikiPlugin.new(self)
	@wiki = WikiParser.new(nil,nil,@wikip)
	@pg_pms = @pagen.chk_permission(@login_user)
end

# ----
def bos_pg_main
	return nil unless @pagen
	if bos_chk_v then
		SanitizedString[@wiki.generate(@pagen[:content])]
	else
		'ΥڡϺ줿ΥڡǤ'
	end
end

def bos_pg_id
	return nil unless @pagen
	@pagen[:product_id] if bos_chk_v
end

def bos_pg_name
	return nil unless @pagen
	@pagen[:product_name] if bos_chk_v
end

def bos_chk_v
	return nil unless @pagen
	n = DateTime.now
	s = DateTime.parse("1900-01-01 00:00:00")
	e = DateTime.parse("9999-01-01 00:00:00")
	if n.to_sql >= (@pagen[:disp_start_date]).to_sql && n.to_sql <= (@pagen[:disp_end_date] || s).to_sql then
		@pg_pms[0]
	else
		false
	end
end

def bos_pg_edit
	return nil unless @pagen
	if @pg_pms[1] then
		if Request["bos_pg_edit"] == "on" then
			begin
				stdate = DateTime.parse(Request["in_bos_start_date"])
			rescue
				stdate = DateTime.now
			end
			begin
				eddate = DateTime.parse(Request["in_bos_end_date"])
			rescue
				eddate = DateTime.parse("9999-01-01 00:00:00")
			end
			@pagen[:product_name]    = Request["in_bos_pg_title"]
			@pagen[:content]         = Request["in_bos_pg_text"]
			@pagen[:template]        = Request["in_bos_pg_template"]
			@pagen[:disp_start_date] = stdate
			@pagen[:disp_end_date]   = eddate
			@pagen[:user_id]         = Request["in_bos_user_id"]
			@pagen[:group_id]        = Request["in_bos_group_id"]
			@pagen[:permission]      = Request["in_bos_permission"].to_i(8)
			@pagen.commit
		end
	end
	{
		:bos_pg_id         => @pagen[:product_id],
		:p                 => a(:value => @pagen[:product_id]),
		:in_bos_pg_id      => a(:value => @pagen[:product_id]){{}},
		:in_bos_pg_title   => a(:value => @pagen[:product_name]){{}},
		:in_bos_pg_text    => @pagen[:content],
		:in_bos_template   => a(:value => @pagen[:template]){{}},
		:in_bos_start_date => a(:value => (@pagen[:disp_start_date] ? @pagen[:disp_start_date].to_sql : "1900-01-01 00:00:00")){{}},
		:in_bos_end_date   => a(:value => (@pagen[:disp_end_date]   ? @pagen[:disp_end_date].to_sql   : "9999-01-01 00:00:00")){{}},
		:in_bos_user_id    => a(:value => ((!@pagen[:user_id] || @pagen[:user_id] == "") ? @login_user[:user_id] : @pagen[:user_id] )){{}},
		:in_bos_group_id   => {:groups => form_select(
				BosGroup.get_all_group_list.collect{|a| { a[:group_id].to_s => a[:group_name] } },@pagen[:group_id])},
		:in_bos_permission => a(:value => (@pagen[:permission]      ? @pagen[:permission].to_s(8)     : "750" )){{}}
	}
end

def bos_pg_editlink
	ret = nil
	if bos_user_admin_only_dev
		ret = a(:href => "admin/product.htm?p=#{@pagen[:product_id]}"){"Խ"} if @pagen && @pagen[:product_id]
	end
	ret
end

def bos_pg_viewlink
	return nil unless @pagen
	a(:href => "../product.htm?p=#{@pagen[:product_id]}"){{}}
end

def bos_pg_newlink
	a(:href => "?p=0"){{}}
end

def bos_pg_listlink
	a(:href => "?"){{}}
end

def bos_pg_list_navi
	bos_pg_list_pre unless @pg_list
	page_navi(@pg_maxpage,"page",{"pagect" => 10,:script_name => "product.htm"})
end

def bos_pg_list
	bos_pg_list_pre unless @pg_list
	{:bos_pg_list_rec => @pg_list}
end

def bos_pg_list_pre
	pagen = BosPagegen.new(0)
	@pg_list = []
	rec,info = pagen.get_list(Request["page"],Request["pagect"])
	@pg_maxpage = info[:max_page]
	pa = (!Request["page"] || Request["page"] == '') ? '1' : Request["page"]
	rec.each{|rs|
		@pg_list << {
			:bos_pg_list_no    => rs[:product_id],
			:bos_pg_list_title => rs[:product_name],
			:bos_pg_list_view  => a(:href => "../product.htm?p=#{rs[:product_id]}"){{}},
			:bos_pg_list_edit  => a(:href => "product.htm?p=#{rs[:product_id]}&page=#{pa}"){{}}} }
end
