# $Id: bos_pg.rb,v 1.11 2005/06/18 01:56:29 nisi Exp $

class BosPagegen
	include BOS::PropMethods
	
	Table_name = "bos_#{BOS::Prop[:site_name]}_products"
	Pages = {}
	if BOS::MySQLo.list_tables.include?(Table_name) then
		BOS::Rdb.exp({
			:command => "s",
			:target  => Table_name,
			:cols    => {
				:product_id      => 0,
				:product_name    => "- no name -"}}).each do |v|
					Pages.store(v[:product_id],v[:product_name])
				end
	end
	
	def initialize(product_id)
		@mydb = BOS::MySQLo
		@mydo = Rudby.new(BOS::MySQLo)
		@prop = set_default
		setup if BOS::Prop[:sitesetup] && !@mydb.list_tables.include?(Table_name)
		if !(product_id.is_a? Numeric) || !(product_id.integer?) then
			product_id = product_id.to_i == 0 ? get_id(product_id) : product_id.to_i
		end
		if product_id != 0 then
			load_id(product_id)
		end
	end
	
	def setup
		@mydb.query("CREATE TABLE #{Table_name}(" +
			"product_id INT NOT NULL AUTO_INCREMENT PRIMARY KEY," +
			"product_name VARCHAR(255)," +
			"content TEXT," +
			"user_id VARCHAR(20)," +
			"group_id INT," +
			"permission INT," +
			"template VARCHAR(64)," +
			"disp_start_date DATETIME," +
			"disp_end_date DATETIME );")
	end
	
	def get_id(titlestr=nil)
		return 0 if !titlestr
		Pages.index(titlestr)
	end
	
	def load(titlestr=nil)
		return "" if !titlestr
		pid = get_id(titlestr)
		if pid then
			load_id(pid)
		else
			""
		end
	end
	
	def load_id(pid)
		return nil if !pid
		@prop = @mydo.exp({
			:command => "s",
			:target  => Table_name,
			:cols    => set_default,
			:where   => "product_id = #{pid}" })[0]
		@prop[:content]
	end
	
	def exist?(titlestr=nil)
		return false if !titlestr
		Pages.has_value?(titlestr)
	end
	
	def get_list(pg=1, pc=10, sc="")
		pg = pg || 1
		pc = pc || 10
		@mydo.exp({
			:command => "s",
			:target  => Table_name,
			:cols    => set_default,
			:order   => "product_id ASC",
			:page    => pg,
			:pagesize => pc })
	end
	
	def set_default
		{
			:product_id      => 0,
			:product_name    => "- no name -",
			:content         => "",
			:template        => "",
			:user_id         => "",
			:group_id        => "",
			:permission      => 0750,
			:disp_start_date => DateTime.now,
			:disp_end_date   => DateTime.parse("9999/01/01") }
	end
	
	def chk_permission(b)
		r,w,x = false,false,false
		if defined?(b.groups) && b.groups.include?(1) then
			r,w,x = true,true,true
		else
			if chk_user(b) then
				r = (@prop[:permission][8] == 1)
				w = (@prop[:permission][7] == 1)
				x = (@prop[:permission][6] == 1)
			elsif chk_group(b) then
				r = (@prop[:permission][5] == 1)
				w = (@prop[:permission][4] == 1)
				x = (@prop[:permission][3] == 1)
			else
				r = (@prop[:permission][2] == 1)
				w = (@prop[:permission][1] == 1)
				x = (@prop[:permission][0] == 1)
			end
		end
		return  r,w,x
	end
	
	def chk_group(b)
		if defined?(b.groups) then
			b.groups.include?(@prop[:group_id])
		else
			if b then
				b.include?(@prop[:group_id])
			else
				false
			end
		end
	end
	
	def chk_user(b)
		return false unless defined?(b[])
		b[:user_id] == @prop[:user_id]
	end
#	alias :=~ :chk_group
	
	def commit
		if @prop[:product_id] == 0 then
			@prop.delete(:product_id)
			@prop[:product_id] = @mydo.exp({
				:command => "i",
				:target  => Table_name,
				:cols    => @prop })[:insid]
		else
			lct = @mydo.exp({
				:command => "u",
				:target  => Table_name,
				:cols    => @prop,
				:where   => "product_id = #{@prop[:product_id]}" })
		end

		@prop[:product_id]
	end

end
