# $Id: bos_miniwiki.rb,v 1.9 2005/06/16 21:52:30 nisi Exp $

require "cgi"

class WikiParser
	attr_accessor :dat, :fdat, :edat, :script_name, :header, :footer, :suffix
	
	def initialize(data=nil, db=nil, plugin=nil, suffix='l')
		@str,@dat = nil,nil
		@db, @plugin, @suffix = db, plugin, suffix
		@fdat = default_fdat
		@edat = default_edat
		@script_name = 'product.htm?p='
		@header = '<div class="body"><div class="section"><div class="day">'
		@footer = '</div></div></div>'
		datset(data)
	end
	
	def default_fdat # tDyary
		{
			:h1     => '/div></div></div><div class="day"><h2><span class="date"><a name="#{a}"> </a></span><span class="title"',
			:h2     => 'h3><a name="#{a}"><span class="sanchor">_</span></a',
			:h3     => 'h4><a name="#{a}"> </a',
			:h4     => 'h5><a name="#{a}"> </a',
			:h5     => 'h6><a name="#{a}"> </a',
			:h6     => 'h7><a name="#{a}"> </a',
			:p      => 'p',
			:blockquote => 'blockquote',
			:pre    => 'pre',
			:code   => 'code',
			:ul     => 'ul',
			:ol     => 'ol',
			:li     => 'li',
			:table  => 'table',
			:tr     => 'tr',
			:th     => 'th',
			:td     => 'td',
			:dl     => 'dl',
			:dt     => 'dt',
			:dd     => 'dd',
			:hr     => 'hr',
			:strong => 'strong',
			:em     => 'em',
			:del    => 'del',
			:a      => 'a',
			:img    => 'img',
			
			:plugin => 'span style="color:#ff0000;"'
		}
	end
	
	def default_edat
		{
			:h1     => 'span></h2><div class="body"><div class="section"',
			:h2     => 'h3',
			:h3     => 'h4',
			:h4     => 'h5',
			:h5     => 'h6',
			:h6     => 'h7',
			:plugin => 'span'
		}
	end
	
	def generate(data=nil)
		parse(data)
		to_html
	end
	
	def parse(data=nil)
		@str = data if data
		@str.gsub!(/(\r\n|[\r\n])/,"\n")
		ret = []
		com,par = false,[]
		lpar = nil
		tsi = 0
		tcom = false
		
		rest = Proc.new do |co,pa|
			if com && lpar && lpar.size > 0 then
				(2..tsi).each{|i|
					ti = 2 + (tsi-i)
					lpar[ti - 1] << {:tag => tcom, :contents => lpar[ti]}
					lpar[ti] = nil }
				ret << {:tag => com, :contents => lpar}
			end
			ret << {:tag => com, :contents => par}  if com && par.size > 0
			com,par = co,pa
			lpar = nil
			tsi = 0
		end
		
		@str.each{|li|
			lis = li.chomp
			case lis
			when /^(\!{1,6})(.+)/
				rest.call(false,[])
				ret << {:tag => "h#{$1.size}".intern, :contents => inline_parse($2)}
			when /^(\/\/)/
				rest.call(false,[])
			when /^(\s|\:|\"\"|\|\||[\*\#]+)(.*)/
				tcom = false
				ea,ed = $1,$2
				case ea
				when /\s/
					tcom = :pre
				when /\"\"/
					tcom = :blockquote
				when /\:/
					tcom = :dl
					trec = []
					r = ed.split(':')
					trec << { :tag => :dt, :contents => inline_parse(r[0])} if r[0]
					trec << { :tag => :dd, :contents => inline_parse(r[1])} if r[1]
					ed = trec
				when /[\*\#]+/
					hh,si = ea[0..0],ea.size
					lpar = [] unless lpar
					lpar[si] = [] unless lpar[si]
					tcom = hh == '*' ? :ul : :ol
					if si < tsi then
						((si+1)..tsi).each{|i|
							ti = (si+1) + (tsi-i)
							lpar[ti - 1] << {:tag => tcom, :contents => lpar[ti]}
							lpar[ti] = nil }
					end
					tsi = si
					lpar[si] << { :tag => :li, :contents => inline_parse(ed) }
					ed = nil
				when /\|\|/
					tcom = :table
					trec = []
					ed.split('||').each do |r|
						r =~ /^(\~?)([\^\>]*)/
						rws,cls = $2.count('^')+1,$2.count('>')+1
						thas = {
							:tag => $1 == "~" ? :th : :td ,
							:contents => inline_parse($') }
						thas.store(:rowspan,rws.to_s) if rws > 1
						thas.store(:colspan,cls.to_s) if cls > 1
						trec << thas
					end
					ed = {:tag => :tr, :contents => trec}
				end
				if tcom && (com == tcom || com == false) then
					com = tcom
					par << ed if ed
				else
					rest.call(tcom,[ed])
				end
			when /^(\-{4})$/
				rest.call(false,[])
				ret << {:tag => :hr, :contents => ""}
			when ""
				rest.call(false,[])
			else
				if com == :p || com == false then
					com = :p
					par << inline_parse(lis)
				else
					rest.call(:p,[inline_parse(lis)])
				end
			end
		}
		rest.call(false,[])
		@dat = ret
	end
	
	def to_html(data=nil)
		datset(data)
		ret = ""
		lt = 0
		@dat.each do |h|
			dst = ""
			case h[:contents]
			when Array
				h[:contents].each{|te| dst << lin(te) + "\n" }
			when String
				dst = lin(h[:contents])
			end
			tftag = @fdat[h[:tag]].gsub('#{a}',"#{@suffix}#{lt}")
			if dst == "" then
				ret << "<#{tftag} />\n"
			else
				ret << "<#{tftag}>#{dst}</#{@edat[h[:tag]]||@fdat[h[:tag]]}>\n"
			end
			lt +=1 if /^h([123456])/ =~ h[:tag].to_s
		end
		@header + ret + @footer
	end

	def to_s
		@str
	end
	
	def dat
		@dat
	end
	
	private	
	def inline_parse(str)
		ret = []
		if str =~ /(\[\[|\'\'\'|\'\'|\=\=|\{\{)/ then
			ret << $`
			ea,ed = $1,$'
			case ea
			when '[['
				if ed =~ /\]\]/ then
					tb = $'
					da = $`.split(/\||\:/,2)
					if $& == '|' || $& == nil then
						if da[1] && da[1].size > 0 then
							if da[1] =~ /\.(jpg|jpeg|png|gif)$/ then
								ret << {:tag => :img, :contents => "" ,:src => da[1], :alt => da[0] }
							else
								ret << {:tag => :a, :contents => da[0] ,:href => da[1]}
							end
						else
							ret << {:tag => :a, :contents => da[0] ,:href => "#{@script_name}#{esc(da[0])}"}
						end
					else # InterWiki
						ret << {:tag => :a, :contents => da[0] ,:href => da[1]}
					end
					ret += inline_parse(tb).to_a
				else
					ret += inline_parse(ed).to_a
				end
			when '\'\'\''
				if ed =~ /\'\'\'/ then
					ret << {:tag => :strong, :contents => $`}
					ret += inline_parse($').to_a
				else
					ret += inline_parse(ed).to_a
				end
			when '\'\''
				if ed =~ /\'\'/ then
					ret << {:tag => :em, :contents => $`}
					ret += inline_parse($').to_a
				else
					ret += inline_parse(ed).to_a
				end
			when '=='
				if ed =~ /\=\=/ then
					ret << {:tag => :del, :contents => $`}
					ret += inline_parse($').to_a
				else
					ret += inline_parse(ed).to_a
				end
			when '{{'
				if ed =~ /\}\}/ then
					ret << {:tag => :plugin, :contents => $`}
					ret += inline_parse($').to_a
				else
					ret += inline_parse(ed).to_a
				end
			end
		else
			ret = str
		end
		ret
	end
	
	def lin(dat)
		ret = ""
		case dat
		when Array
			dat.each{|d|
				ret += lin(d) }
		when String
			ret += escH(dat)
		when Hash
			attr = ""
			dat.keys.each{|k|
				attr << " #{k}=\"#{dat[k]}\"" if k != :tag && k != :contents }
			if dat[:tag] == :plugin then
				if @plugin then
					if /^(\w+)(?:\((.*)\))?/ =~ dat[:contents] then
						pcom,args = $1, $2 ? $2.split(',') : nil
						if args then
							ret += @plugin.send(pcom,*args)
						else
							ret += @plugin.send(pcom)
						end
					else
						ret += "<span style=\"color:#FF0000;\">Plugin syntax error</span>"
					end
				else
					ret += "<span style=\"color:#FF0000;\">Plugin ERROR</span>"
				end
			elsif !dat[:contents] || dat[:contents] == "" then
				ret += "<#{@fdat[dat[:tag]]}#{attr} />"
			else
				ret += "<#{@fdat[dat[:tag]]}#{attr}>#{lin(dat[:contents])}</#{@edat[dat[:tag]]||@fdat[dat[:tag]]}>"
			end
		end
		ret
	end
	
	def escH(dat)
		CGI::escapeHTML(dat)
	end
	
	def esc(dat)
		CGI::escape(dat)
	end
	
	def datset(data)
		case data
		when String
			parse(data)
		when Array
			@dat = data
		end
	end
	
end

class WikiPlugin
	
	def initialize(model, suffix='wiki_plugin_')
		@model = model
		@suffix = suffix
	end
	
	def send(pcom, *args)
		if pcom.class == String || pcom.class == Symbol then
			tpcom = "#{@suffix}#{pcom.to_s}"
			if @model.methods.include?(tpcom) then
				@model.__send__(tpcom, *args)
			else
				"<span style=\"color:#FF0000;\">Plugin not found '#{pcom}'</span>"
			end
		else
			"<span style=\"color:#FF0000;\">Plugin ERROR '#{pcom}'</span>"
		end
	end
	
end
