# $Id: bos_category.rb,v 1.5 2005/06/18 01:56:29 nisi Exp $

class BosCategory
	include BOS::PropMethods
	
	Table_name = "bos_#{BOS::Prop[:site_name]}_categories"
	
	def initialize(category_id)
		@mydb = BOS::MySQLo
		@mydo = BOS::Rdb
		@prop = set_default
		setup if BOS::Prop[:sitesetup] && !@mydb.list_tables.include?(Table_name)
		if !(category_id.is_a? Numeric) || !(category_id.integer?) then
			category_id = category_id.to_i == 0 ? get_id(category_id) : category_id.to_i
		end
		if category_id != 0 then
			load_id(category_id)
		end
	end
	
	def setup
		@mydb.query("CREATE TABLE #{Table_name}(" +
			"category_id INT NOT NULL AUTO_INCREMENT PRIMARY KEY," +
			"item_id INT," +
			"item_type VARCHAR(1)," +
			"self_id INT," +
			"sub_id INT," +
			"disp_order INT," +
			"disp_type_order INT);")
	end
	
	def set_default
		{
			:category_id     => 0,
			:item_id         => 0,
			:item_type       => "p",
			:self_id         => 0,
			:sub_id          => 0,
			:disp_order      => 0,
			:disp_type_order => 0 }
	end
	
	def load_id(cid,sl=nil)
		return nil if !cid
		@prop = @mydo.exp({
			:command => "s",
			:target  => Table_name,
			:cols    => set_default,
			:where   => w("self_category_id"){|a| a == cid }})
		@prop = @prop[sl] if sl
		load_cate_tree
	end
	
	def load_cate_tree(cid=nil)
	end
	
	def add(cid,peid=nil)
	end
	
	def del(cid,peid=nil)
	end
	
	def commit
		if @prop[:category_id] == 0 then
			@prop.delete(:category_id)
			@prop[:category_id] = @mydo.exp({
				:command => "i",
				:target  => Table_name,
				:cols    => @prop })[:insid]
		else
			lct = @mydo.exp({
				:command => "u",
				:target  => Table_name,
				:cols    => @prop,
				:where   => w("category_id"){|a| a == @prop[:category_id]}})
		end

		@prop[:category_id]
	end

end
