# Rudby
#
#  Ruby MySQL֥
#   ( Ruby/MySQL or MySQL/Ruby)
#
# $Id: rudby.rb,v 1.6 2005/05/18 00:04:30 nisi Exp $
#

require 'nkf'
require 'mysql'
require 'date'
require 'time'

class Date
	def to_sql
		self.strftime("%Y-%m-%d")
	end
end

class DateTime
	def to_sql
		self.strftime("%Y-%m-%d %H:%M:%S")
	end
end

class Time
	def to_sql
		self.strftime("%H:%M:%S")
	end
end

class String
	def to_h2z
		NKF::nkf('-EeX -m0', self)
	end

	def to_Sql
		Mysql::quote(self)
	end

	def to_S
		to_h2z.to_Sql
	end
	
	def to_ss
		Rudby::SqlString.new(self)
	end
end

def join(ft,lt=nil)
	ft = ft.to_s.to_ss
	if lt.kind_of?(String) then
		lt = "#{lt}".to_ss
	end
	if !lt then
		" JOIN #{ft} ON#{yield(ft,lt)}"
	else
		" #{ft} JOIN #{lt} ON#{yield(ft,lt)}"
	end
end
alias j join

def left_join(ft,lt=nil)
	ft = ft.to_s.to_ss
	if lt.kind_of?(String) then
		lt = "#{lt}".to_ss
	end
	if !lt then
		" LEFT JOIN #{ft} ON#{yield(ft,lt)}"
	else
		" #{ft} LEFT JOIN #{lt} ON#{yield(ft,lt)}"
	end
end
alias lj left_join

def right_join(ft,lt=nil)
	ft = ft.to_s.to_ss
	if lt.kind_of?(String) then
		lt = "#{lt}".to_ss
	end
	if !lt then
		" RIGHT JOIN #{ft} ON#{yield(ft,lt)}"
	else
		" #{ft} RIGHT JOIN #{lt} ON#{yield(ft,lt)}"
	end
end
alias rj right_join

def where(*t)
	t = t.collect{|inst|
		inst = "#{inst}".to_ss if inst.kind_of?(String) }
	"#{yield(*t)}"
end
alias w where

def limit(st,ct)
	" #{st},#{ct} "
end
alias l limit

class Rudby
	attr_accessor :mydb, :dat, :target, :h2z_mode

	def initialize(mydb=nil,*arg)
		@mydb = nil
		@dat = nil
		@target = nil
		@h2z_mode = false
		case mydb
		when Mysql
			@mydb = mydb
			@target = arg[0] if arg[0]
		when String
			@mydb = Mysql.new(mydb,arg[0],arg[1],arg[2])
			@target = arg[3] if arg[3]
		when Hash
			@dat = mydb
			@target = arg[0] if arg[0]
		end
	end
	
	def set(queryobj)
		@dat = queryobj
	end
	
	def exp(queryobj=nil)
		return nil unless @mydb
		queryobj = queryobj || @dat
		reth = {}
		com,query,mp,queryobj = create_query(queryobj)
		case com
		when "s"
			reta = []
			@mydb.query(query).each_hash do |tmRw|
				tmRw.each {|has,val|
					if queryobj[:cols].class == Hash then
						tmpv = queryobj[:cols][has.intern] || queryobj[:cols][has]
						case tmpv
						when DateTime
							val = DateTime.parse(val) if val
						when Date
							val = Date.parse(val) if val
						when Time
							val = Time.parse(val) if val
						when Numeric
							val = val.to_i if val
						when String
							val = val.to_s if val
#						when NilClass,FalseClass
#							val = val
						end
						reth.store(queryobj[:cols][has.intern] ? has.intern : has ,val )
					elsif queryobj[:cols].class == Array then
						if queryobj[:cols].include?(has.intern) then
							reth.store(has.intern ,val )
						else
							reth.store(has ,val )
						end
					else
						reth.store(has.intern ,val )
					end
				}
				reta << reth
				reth = {}
			end
			reth = reta
		when "u","d"
			@mydb.query(query)
			reth.store(:affected_rows,@mydb.affected_rows())
		when "i"
			@mydb.query(query)
			reth.store(:insid,@mydb.insert_id)
		when "ui"
			@mydb.query(query)
			if @mydb.affected_rows() <= 0 then
				queryobj[:command] = "i"
				com,query = create_query(queryobj)
				@mydb.query(query)
				reth.store(:insid,@mydb.insert_id)
			else
				reth.store(:affected_rows,@mydb.affected_rows())
			end
		end
		mp ? [reth,mp] : reth
	end
	alias :query :exp

	def create_query(queryobj=nil)
		queryobj = queryobj || @dat
		pmk = nil
		pmk = get_pri_key(@target) if @target
		if (queryobj.class != Hash) && pmk then
			wtm = w(pmk){|a| a == queryobj }
			queryobj = {}
			queryobj[:where] = wtm
		end
		if !queryobj[:target] then
			queryobj[:target] = @target
		end
		if queryobj[:target] && !queryobj[:cols] then
			queryobj[:cols] = get_default_cols(queryobj[:target])
		end
		upw = ""
		upw = ("WHERE " + w(pmk){|a| a == queryobj[:cols][pmk.intern] }) if pmk && queryobj[:cols][pmk.intern]
		reta = []
		case queryobj
		when String
			reta << "s"
			reta << queryobj
		when Hash
			if queryobj[:query] && queryobj[:query] != "" then
				reta << "s"
				reta << queryobj[:query].to_s
			else
				if !queryobj[:command] then
					queryobj[:command] = "s"
				end
				tmpw = (queryobj[:where] && queryobj[:where] != "") ? "WHERE #{queryobj[:where]} " : ""
				tmpo = (queryobj[:order] && queryobj[:order] != "") ? "ORDER BY #{queryobj[:order]} " : ""
				tmpl = (queryobj[:limit] && queryobj[:limit] != "") ? "LIMIT #{queryobj[:limit]} " : ""
				if queryobj[:page] && queryobj[:pagesize] then
					pageb = (queryobj[:page].to_i - 1) * queryobj[:pagesize].to_i
					tmpl = "LIMIT #{pageb},#{queryobj[:pagesize]} "
				end
				case queryobj[:command].downcase
				when "update","u"
					reta << "u"
					ques = up_qval(queryobj[:cols])
					if tmpw == "" then
						reta << "UPDATE #{queryobj[:target]} SET #{ques} #{upw};"
					else
						reta << "UPDATE #{queryobj[:target]} SET #{ques} #{tmpw};"
					end
				when "delete","d"
					reta << "d"
					if tmpw == "" then
						reta << "DELETE FROM #{queryobj[:target]} #{upw};"
					else
						reta << "DELETE FROM #{queryobj[:target]} #{tmpw};"
					end
				when "insert","i"
					reta << "i"
					ques = in_qval(queryobj[:cols])
					reta << "INSERT INTO #{queryobj[:target]}(#{ques[0]}) VALUES(#{ques[1]}) ;"
				when "update_insert","ui"
					reta << "ui"
					ques = up_qval(queryobj[:cols])
					if tmpw == "" then
						reta << "UPDATE #{queryobj[:target]} SET #{ques} #{upw};"
					else
						reta << "UPDATE #{queryobj[:target]} SET #{ques} #{tmpw};"
					end
				else # "select","s"
					reta << "s"
					ques = sel_qval(queryobj[:cols])
					ttque = "#{queryobj[:target]} #{tmpw}#{tmpo}"
					reta << "SELECT #{ques} FROM #{ttque}#{tmpl};"
					if queryobj[:page] && queryobj[:pagesize] then
						@mydb.query("SELECT COUNT(*) AS CT FROM #{ttque};").each_hash do |tmRw|
							reta << {:max_count => tmRw["CT"].to_i ,:max_page => (tmRw["CT"].to_f / queryobj[:pagesize].to_f).ceil}
						end
					end
				end
			end
		when Array
			reta << "s"
			queryobj.join.to_s
		else
			reta = [nil,nil]
		end
		if reta.size == 2 then
			reta + [nil,queryobj]
		else
			reta + [queryobj]
		end
	end
	
	def to_s(queryobj=nil)
		queryobj = queryobj || @dat
		ret = create_query(queryobj)
		ret[1]
	end
	
	def commit(queryr,pmode=nil)
		ret = []
		if @target then
			pmk = get_pri_key(@target)
		else
			return
		end
		case queryr
		when Hash
			if pmode then
				ret << commit_r(queryr,pmk,pmode)
			else
				commit_r(queryr,pmk)
			end
		when Array
			if pmode then
				queryr.each{|iq|
					ret << commit_r(iq,pmk,pmode) }
			else
				queryr.each{|iq|
					commit_r(iq,pmk) }
			end
		end
		ret.join("\n") if pmode
	end
	
	private
	
	def commit_r(queryr,pmk,pmode=nil)
		if queryr.class == Hash && queryr[pmk.intern] then
			tmpq = queryr.dup
			tmpq.delete(pmk.intern)
			if pmode then
				to_s(:command => "u",:cols => tmpq, :where => w(pmk){|a| a == queryr[pmk.intern]})
			else
				exp(:command => "u",:cols => tmpq, :where => w(pmk){|a| a == queryr[pmk.intern]})
			end
		end
	end
	
	def sel_qval(has)
		ret = ""
		case has
		when Hash
			has.each {|h,v|
#				return nil if !(h.is_a? Symbol)
				ret << h.to_s + ","
			}
			ret.chop!
		when Array
			ret = has.join(",")
		end
		ret
	end
	
	def up_qval(has)
		ret = ""
		has.each {|h,v|
#			return nil if !(h.is_a? Symbol)
			case v
			when DateTime,Date,Time
				ret << h.to_s + " = '" + v.to_sql + "',"
			when Numeric
				ret << h.to_s + " = " + v.to_s + ","
			when String
				@h2z_mode ? ret << h.to_s + " = '" + v.to_S + "'," : ret << h.to_s + " = '" + v.to_Sql + "',"
			when NilClass,FalseClass
				ret << h.to_s + " = NULL,"
			else
				@h2z_mode ? ret << h.to_s + " = '" + "#{v}".to_S + "'," : ret << h.to_s + " = '" + "#{v}".to_Sql + "',"
			end
		}
		ret.chop
	end
	
	def in_qval(has)
		ret = ["",""]
		has.each {|h,v|
#			return nil if !(h.is_a? Symbol)
			case v
			when DateTime,Date,Time
				ret[0] << h.to_s + ","
				ret[1] << "'" + v.to_sql + "',"
			when Numeric
				ret[0] << h.to_s + ","
				ret[1] << v.to_s + ","
			when String
				ret[0] << h.to_s + ","
				@h2z_mode ? ret[1] << "'" + v.to_S + "'," : ret[1] << "'" + v.to_Sql + "'," 
			when NilClass,FalseClass
				ret[0] << h.to_s + ","
				ret[1] << v.to_s + "NULL,"
			else
				ret[0] << h.to_s + ","
				@h2z_mode ? ret[1] << "'" + "#{v}".to_S + "'," : ret[1] << "'" + "#{v}".to_Sql + "'," 
			end
		}
		ret[0].chop!
		ret[1].chop!
		ret
	end
	
	def get_pri_key(tb)
		index= @mydb.list_fields(tb).num_fields()
		for ct in 0..index-1
			field_object = @mydb.list_fields(tb).fetch_field_direct(ct)
			if (field_object.flags & Mysql::Field::PRI_KEY_FLAG) == Mysql::Field::PRI_KEY_FLAG then
				return field_object.name
			end
		end
	end
	
	def get_default_cols(tb)
		ret = {}
		index= @mydb.list_fields(tb).num_fields()
		for ct in 0..index-1
			field_object = @mydb.list_fields(tb).fetch_field_direct(ct)
			ret[field_object.name.intern] = get_type(field_object.type)
		end
		ret
	end
	
	def get_type(intype)
		case intype
		when Mysql::Field::TYPE_DECIMAL
			true
		when Mysql::Field::TYPE_TINY,
			Mysql::Field::TYPE_SHORT,
			Mysql::Field::TYPE_LONG,
			Mysql::Field::TYPE_LONGLONG,
			Mysql::Field::TYPE_INT24,
			Mysql::Field::TYPE_LONG,
			Mysql::Field::TYPE_LONG
			0
		when Mysql::Field::TYPE_FLOAT,
			Mysql::Field::TYPE_DOUBLE
			0.0
		when Mysql::Field::TYPE_NULL
			nil
		when Mysql::Field::TYPE_TIMESTAMP,
			Mysql::Field::TYPE_DATETIME,
			Mysql::Field::TYPE_YEAR,
			Mysql::Field::TYPE_NEWDATE
			DateTime.new
		when Mysql::Field::TYPE_DATE
			Date.new
		when Mysql::Field::TYPE_TIME
			Time.new
		when Mysql::Field::TYPE_ENUM,
			Mysql::Field::TYPE_SET
			[]
		else
			""
		end
	end
	
	class SqlString < String
	
		def cvstr(inst)
			case inst
			when DateTime,Date,Time
				"'#{inst.to_sql.to_S}'"
			when Numeric
				"#{inst.to_s.to_S}"
			when SqlString
				"#{inst}"
			when String
				"'#{inst.to_S}'"
			when NilClass,FalseClass
				"NULL"
			else
				"'" + "#{inst}".to_S + "'"
			end
		end
		
		def ==(oth)
			if oth then
				" (#{cvstr(self)} = #{cvstr(oth)}) ".to_ss
			else
				" (#{cvstr(self)} IS NULL) ".to_ss
			end
		end
		
		def >=(oth)
			" (#{cvstr(self)} >= #{cvstr(oth)}) ".to_ss
		end
		
		def >(oth)
			" (#{cvstr(self)} > #{cvstr(oth)}) ".to_ss
		end
		
		def <=(oth)
			" (#{cvstr(self)} <= #{cvstr(oth)}) ".to_ss
		end
		
		def <(oth)
			" (#{cvstr(self)} < #{cvstr(oth)}) ".to_ss
		end
		
		def =~(oth)
			" (#{cvstr(self)} REGEXP #{cvstr(oth)}) ".to_ss
		end
		alias regexp =~
		
		def like(oth)
			" (#{cvstr(self)} LIKE #{cvstr(oth)}) ".to_ss
		end
		
		def ^(oth)
			if oth then
				" (#{cvstr(self)} <> #{cvstr(oth)}) ".to_ss
			else
				" (#{cvstr(self)} IS NOT NULL) ".to_ss
			end
		end
		
		def &(oth)
			" #{cvstr(self)} AND #{cvstr(oth)} ".to_ss
		end
		
		def *(oth)
			" (#{cvstr(self)} AND #{cvstr(oth)}) ".to_ss
		end
		
		def |(oth)
			" #{cvstr(self)} OR #{cvstr(oth)} ".to_ss
		end
		
		def +(oth)
			" (#{cvstr(self)} OR #{cvstr(oth)}) ".to_ss
		end
		
		def [](cols)
			"#{self}\.#{cols.to_s}".to_ss
		end
		
		def between(a,b)
			" (#{self} BETWEEN #{cvstr(a)} AND #{cvstr(b)}) ".to_ss
		end
		alias b between
		
	end # Rudby::SqlString
	
end # Rudby
