# $Id: bos_pg.rb,v 1.7 2005/05/18 00:04:30 nisi Exp $

class BosPagegen
	include BOS::PropMethods
	
	Table_name = "bos_#{Prop[:site_name]}_products"
	Pages = {}
	BOS::Rdb.exp({
		:command => "s",
		:target  => Table_name,
		:cols    => {
			:product_id      => 0,
			:product_name    => "- no name -"}}).each do |v|
		Pages.store(v[:product_id],v[:product_name])
	end
	
	def initialize(product_id)
		@mydb = BOS::MySQLo
		@mydo = BOS::Rdb
		@prop = set_default
		setup if Prop[:sitesetup] && !@mydb.list_tables.include?(Table_name)
		if !(product_id.is_a? Numeric) || !(product_id.integer?) then
			product_id = product_id.to_i == 0 ? get_id(product_id) : product_id.to_i
		end
		if product_id != 0 then
			load_id(product_id)
		end
	end
	
	def setup
		@mydb.query("CREATE TABLE #{Table_name}(" +
			"product_id INT NOT NULL AUTO_INCREMENT PRIMARY KEY," +
			"product_name VARCHAR(255)," +
			"content TEXT," +
			"template VARCHAR(64)," +
			"disp_start_date DATETIME," +
			"disp_end_date DATETIME," +
			"disp_flg CHAR(1) );")
	end
	
	def get_id(titlestr=nil)
		return 0 if !titlestr
#		ret = 0
#		retr = @mydo.exp({
#			:command => "s",
#			:target  => Table_name,
#			:cols    => {:product_id => 0},
#			:where   => w("product_name"){|a| a == titlestr } })
#		ret = retr[0][:product_id] if retr && retr[0]
#		ret
		Pages.index(titlestr)
	end
	
	def load(titlestr=nil)
		return "" if !titlestr
		pid = get_id(titlestr)
		if pid then
			load_id(pid)
		else
			""
		end
	end
	
	def load_id(pid)
		return nil if !pid
		@prop = @mydo.exp({
			:command => "s",
			:target  => Table_name,
			:cols    => set_default,
			:where   => "product_id = #{pid}" })[0]
		@prop[:content]
	end
	
	def exist?(titlestr=nil)
		return false if !titlestr
		Pages.has_value?(titlestr)
	end
	
	def get_list(pg=1, pc=10, sc="")
		pg = pg || 1
		pc = pc || 10
		@mydo.exp({
			:command => "s",
			:target  => Table_name,
			:cols    => set_default,
			:order   => "product_id ASC",
			:page    => pg,
			:pagesize => pc })
	end
	
	def set_default
		{
			:product_id      => 0,
			:product_name    => "- no name -",
			:content         => "",
			:template        => "",
			:disp_start_date => DateTime.now,
			:disp_end_date   => DateTime.now,
			:disp_flg        => "n" }
	end
	
	def commit
		if @prop[:product_id] == 0 then
			@prop.delete(:product_id)
			@prop[:product_id] = @mydo.exp({
				:command => "i",
				:target  => Table_name,
				:cols    => @prop })[:insid]
		else
			lct = @mydo.exp({
				:command => "u",
				:target  => Table_name,
				:cols    => @prop,
				:where   => "product_id = #{@prop[:product_id]}" })
		end

		@prop[:product_id]
	end

end
