# $Id: util.rb,v 1.6 2005/04/15 23:02:43 nisi Exp $

class String
	def to_sani
		SanitizedString[self]
	end
	
	def to_html
		SanitizedString[self.to_escHTML.gsub('\n','<br>')]
	end
end

module BOS

	module PropMethods
		def [](key)
			@prop[key]
		end
		
		def []=(key,val)
			@prop[key] = val
		end
	end
	
	module Utils
	
		def form_select(inar,selected_val="",opt=nil)
			opt = opt || {}
			selected_val = selected_val.to_a
			
			at_mode     = opt[:mode]   || "select"
			
			sels = ""
			case at_mode.to_s
			when "radio","checkbox"
				sels = "checked"
			else # "select"
				sels = "selected"
			end
			
			ret = []
			inar.each do |ina|
				attrs = {}
				vval  = ""
				ina.each do |key,val|
					case key.class.to_s
					when "Symbol"
						attrs[key] = val
					when "String"
						attrs[:value] = key
						attrs[sels.to_sym] = (selected_val.include?(key) ? sels : nil)
						vval = val
					end
				end
				ret << a(attrs){vval}
			end
			ret
		end
		
		def page_navi(max_page=0,selected_page=1,opt=nil)
			return "" if !max_page || !selected_page || (max_page == 0) || (selected_page == 0)
			opt = opt || {}
			
			at_page     = opt[:query_page_name] || "page"
			at_script   = opt[:script_name]     || "./"
			at_addquery = opt[:add_query]       || ""
			at_top_str  = opt[:top]    || opt[:start] || "<<top"
			at_end_str  = opt[:bottom] || opt[:end]   || "last>>"
			at_prev_str = opt[:prev]            || "<prev"
			at_next_str = opt[:next]            || "next>"
			at_size     = opt[:size]            || 10
			at_a_symbol = (opt[:symbol] || opt[:a_id]  || :lin).to_sym
			
			at_addquery = at_addquery.to_urlq if at_addquery.class.name == "Hash"
			
			if selected_page.class.name == "String"
				at_page = selected_page
				selected_page = (BOS::Request[selected_page] || 1).to_i
			end
			
			seladdq = {}
			opt.each do |k,v|
				seladdq[k] = (BOS::Request[k] || v) if k.class.name == "String"
			end
			seladdq = seladdq.to_urlq
			seladdq = seladdq + '&' if seladdq != ''
			
			navistr = []
			lpg = selected_page - (at_size / 2)
			lpg = 1 if lpg < 1
			
			at_addquery += '&' if at_addquery != ""
			bst = "#{at_script}?#{seladdq}#{at_addquery}#{at_page}="
			
			navistr << {at_a_symbol => a(:href => "#{bst}1"){at_top_str}} if at_top_str != ""
			navistr << {at_a_symbol => a(:href => "#{bst}#{selected_page - 1}"){at_prev_str}} if at_prev_str != '' && (selected_page - 1) > 0
			at_size.times{
				break if lpg > max_page
				if selected_page == lpg then
					navistr << {at_a_symbol => a(:href => nil){lpg.to_s}}
				else
					navistr << {at_a_symbol => a(:href => "#{bst}#{lpg}"){lpg.to_s}}
				end
				lpg += 1
			}
			navistr << {at_a_symbol => a(:href => "#{bst}#{selected_page + 1}"){at_next_str}} if at_next_str != "" && (selected_page + 1) <= max_page
			navistr << {at_a_symbol => a(:href => "#{bst}#{max_page}"){at_end_str}} if max_page != 0 && at_end_str != ""
			
			navistr
		end

	end
end
