# $Id: bos_pg.rb,v 1.22 2005/06/02 11:55:10 nisi Exp $

# pagegen Ϣ
def pre_bos_pg_init
	return nil unless Request["p"]
	@pagen = BosPagegen.new(Request["p"]) unless @pagen
	@wikip = WikiPlugin.new(self)
	@wiki = WikiParser.new(nil,nil,@wikip)
end

# ----
def bos_pg_main
	return nil unless @pagen
	if bos_chk_v then
		SanitizedString[@wiki.generate(@pagen[:content])]
	else
		'ΥڡϺ줿ΥڡǤ'
	end
end

def bos_pg_id
	return nil unless @pagen
	@pagen[:product_id] if bos_chk_v
end

def bos_pg_name
	return nil unless @pagen
	@pagen[:product_name] if bos_chk_v
end

def bos_chk_v
	return nil unless @pagen
	n = DateTime.now
	s = DateTime.parse("1900-01-01 00:00:00")
	e = DateTime.parse("9999-01-01 00:00:00")
	if n.to_sql >= (@pagen[:disp_start_date]).to_sql && n.to_sql <= (@pagen[:disp_end_date] || s).to_sql then
		case @pagen[:disp_flg]
		when 'p'
			true
		when 'n'
			(@login_user && @login_user == 'a')
		when 'h'
			(@login_user && @login_user == 'a')
		when 'd'
			nil
		end
	else
		false
	end
end

def bos_pg_edit
	return nil unless @pagen
	if @login_user && @login_user == 'a' then
		if Request["bos_pg_edit"] == "on" then
			begin
				stdate = DateTime.parse(Request["in_bos_start_date"])
			rescue
				stdate = DateTime.now
			end
			begin
				eddate = DateTime.parse(Request["in_bos_end_date"])
			rescue
				eddate = DateTime.parse("9999-01-01 00:00:00")
			end
			@pagen[:product_name]    = Request["in_bos_pg_title"]
			@pagen[:content]         = Request["in_bos_pg_text"]
			@pagen[:template]        = Request["in_bos_pg_template"]
			@pagen[:disp_start_date] = stdate
			@pagen[:disp_end_date]   = eddate
			@pagen[:disp_flg]        = Request["in_bos_disp_flg"]
			@pagen.commit
		end
	end
	{
		:bos_pg_id         => @pagen[:product_id],
		:p                 => a(:value => @pagen[:product_id]),
		:in_bos_pg_id      => a(:value => @pagen[:product_id]){{}},
		:in_bos_pg_title   => a(:value => @pagen[:product_name]){{}},
		:in_bos_pg_text    => @pagen[:content],
		:in_bos_template   => a(:value => @pagen[:template]){{}},
		:in_bos_start_date => a(:value => (@pagen[:disp_start_date] ? @pagen[:disp_start_date].to_sql : "1900-01-01 00:00:00")){{}},
		:in_bos_end_date   => a(:value => (@pagen[:disp_end_date]   ? @pagen[:disp_end_date].to_sql   : "9999-01-01 00:00:00")){{}},
		:in_bos_disp_flg   => {:disp_flg => form_select(
			[{'p' => 'ɽ'},{'n' => ''},{'h' => 'ɽ'},{'d' => ''}],@pagen[:disp_flg])}
	}
end

def bos_pg_viewlink
	return nil unless @pagen
	a(:href => "../product.htm?p=#{@pagen[:product_id]}"){{}}
end

def bos_pg_newlink
	a(:href => "?p=0"){{}}
end

def bos_pg_listlink
	a(:href => "?"){{}}
end

def bos_pg_list_navi
	bos_pg_list_pre unless @pg_list
	page_navi(@pg_maxpage,"page",{"pagect" => 10,:script_name => "product.htm"})
end

def bos_pg_list
	bos_pg_list_pre unless @pg_list
	{:bos_pg_list_rec => @pg_list}
end

def bos_pg_list_pre
	pagen = BosPagegen.new(0)
	@pg_list = []
	rec,info = pagen.get_list(Request["page"],Request["pagect"])
	@pg_maxpage = info[:max_page]
	pa = (!Request["page"] || Request["page"] == '') ? '1' : Request["page"]
	rec.each{|rs|
		@pg_list << {
			:bos_pg_list_no    => rs[:product_id],
			:bos_pg_list_title => rs[:product_name],
			:bos_pg_list_view  => a(:href => "../product.htm?p=#{rs[:product_id]}"){{}},
			:bos_pg_list_edit  => a(:href => "product.htm?p=#{rs[:product_id]}&page=#{pa}"){{}}} }
end
