# $Id: bos.rb,v 1.19 2005/05/27 23:26:58 nisi Exp $

require 'cgi'
require 'cgi/session'
require 'fileutils'
require 'web'
require 'kconv'

if $bos_prop[:amrita2] then
	require 'amrita2/template'
	include Amrita2
else
	require 'amrita/template'
	include Amrita
end
if $bos_prop[:db_server] then
	require 'mysql'
	require "bos/rudby"
end
require "bos/urlquery"
require "bos/util"

include BOS::Utils

BOS_VERSION = '0.9.1.2'

module BOS
	Prop    = $bos_prop
	
	Request = Web::Interface::CGI.new.request
	Req     = Request
	
	Cgi     = CGI::new
	Params  = Cgi.params
	
	Session = CGI::Session::new(Cgi)
#	Session = BOS::Session::new(Cgi)
	Ses     = Session
	
	URLq    = URLQueryString.new(Cgi)
	
	if Prop[:db_server] then
		MySQLo = Mysql.new(
			Prop[:db_server],
			Prop[:db_user],
			Prop[:db_pass],
			Prop[:db_name] )
		Rdb  = Rudby.new(MySQLo)
	end
	
	def BOS::start
		template = ENV['REDIRECT_TEMPLATE'] || ENV['REDIRECT_REDIRECT_TEMPLATE']
		template = "#{Prop[:top_page]}.#{Prop[:bos_template]}" if !template || template == ""

		model = BOS::BosModel::new
		
		based = ""
		('./' + template).split("\/").each do |tdir|
			based += tdir
			Dir::glob("#{based}/#{Prop[:class_dir]}/*.rb").each do |f|
				next unless test(?f, f)
				open( f ) do |fd|
					eval( fd.read )
				end
			end

			Dir::glob("#{based}/#{Prop[:class_dir]}/*.class").each do |f|
				next unless test(?f, f)
				open( f ) do |fd|
					tmpf = fd.read
					eval( tmpf )
					cclass = ""
					cname = ""
					
					cname = File.basename(f,".class")
					if tmpf =~ /class ([A-Z]\w*)/ then
						cclass = $1
					end

					if cclass && cname && cclass != "" && cname != "" then
						model.c[cname.intern] = eval("BOS::#{cclass}").new()
					end
				end
			end

			Dir::glob("#{based}/#{Prop[:plugin_dir]}/*.rb").each do |f|
				next unless test(?f, f)
				open( f ) do |fd|
					model.instance_eval( fd.read )
				end
			end
			
			based += "/"
		end
		
		model.methods.sort.each{|m|
			eval("model.#{m}") if m =~ /^pre_.+/ }
		
		outhtml = ""
		template = tempgen(template)
		tmpl = TemplateText.new(template.toeuc)
		tmpl.expand(outhtml, model)
		Cgi.out({
				"Charset" => Prop[:encode],
				"Expires" => Time.now,
				"Cache-Control" => "no-cache",
				"Pragma" => "no-cache"
			}){ outhtml }

		model.methods.sort.each{|m|
			eval("model.#{m}") if m =~ /^post_.+/ }
	end
	
	def BOS::tempgen(templ,tpath="")
		return "" if !templ || templ == ""
		ret = ""
		ttempl = ""
		if templ[0] == '/' then
			thistmp = "#{templ}"
		else
			thistmp = "#{tpath}#{templ}"
		end
		tpname = File.dirname(thistmp)
		tpname = tpname == "." ? "" : tpname
		open(thistmp){|inf| ttempl = inf.read }
		ttempl.split($/).each do |ln|
			tmfl = true
			if /^\<\!\-\-\s*\#(.+)\s+(.+)\s*\-\-\>$/ =~ ln then
				incom = $1
				invals = $2
				if /(.+)\s*\=\s*\"(.+)\"/ =~ invals then
					inatt = $1
					inval = $2
				end
				case incom
				when "include"
					if inatt == "file" then
						ret << tempgen(inval,tpname != "" ? tpname + '/' : "")
						tmfl =false
					end
				end
			end
			
			ret << ln + "\n" if tmfl
		end
		ret
	end
	
#	class BosSession
#		def initialize(cgi)
#			@ses = CGI::Session::new(cgi)
#			@sses = CGI::Session::new(cgi,{"session_secure" => true})
#		end
#		
#		def [](key)
#			if key.class == Symbol then
#				@sses[key.to_s]
#			else
#				@ses[key]
#			end
#		end
#		
#		def []=(key,val)
#			if key.class == Symbol then
#				@sses[key.to_s] = val
#			else
#				@ses[key] = val
#			end
#		end
#	end
	
	class BosModel
		include Amrita::ExpandByMember unless Prop[:amrita2]
		attr_accessor :c
		
		def initialize
			@c = {}
		end
		
		def hidden
			nil
		end
		
		def dev # ǥХå
			$Dev
		end
		
	end

end

