# URLQueryString
#
#  URLQueryinput-form
#
# $Id: urlquery.rb,v 1.3 2005/02/18 00:32:17 nisi Exp $
#
require 'cgi'

class String
	def to_esc
		CGI::escape(self)
	end
	
	def to_escHTML
		CGI::escapeHTML(self)
	end
end

class Hash
	def to_urlq
		taq = []
		self.each{|k,v|
			taq << "#{k.to_s.to_esc}=#{v.to_s.to_esc}" }
		taq.join('&')
	end
end

class URLQueryString
	attr_accessor :dat
	
	def initialize(indat)
		indat = indat.dup
		@dat = {}
		case indat
		when String
			indat = indat.gsub('&amp;','&')
			indat = indat[1..-1] if indat[0..0] == "?"
			indat.split('&').each{|inn|
				k,v = inn.split('=')
				v = v.split(',') if v.include?(',')
				@dat.store(k.intern ,v)
			}
		when Hash
			indat.each{|k,v|
				k = k.intern if k.class != Symbol
				if v.class == Array then
					case v.size
					when 1
						@dat.store(k ,v[0])
					when 0
						@dat.store(k ,nil)
					else
						@dat.store(k ,v)
					end
				else
					@dat.store(k ,v)
				end
			}
		end
	end
	
	def to_s
		ret = []
		@dat.each{|k,v|
			case v
			when Array
				ret << "#{k}=#{v.join(',').to_s.to_esc}"
			when NilClass,FalseClass
			else
				ret << "#{k}=#{v.to_s.to_esc}"
			end
		}
		ret = ret.join('&')
	end
	
	def to_form
		ret = []
		@dat.each{|k,v|
			case v
			when Array
				ret << "<input name=\"#{k}\" type=\"hidden\" value=\"#{v.join(',').to_s.to_escHTML}\">\n"
			when NilClass,FalseClass
			else
				ret << "<input name=\"#{k}\" type=\"hidden\" value=\"#{v.to_s.to_escHTML}\">\n"
			end
		}
		ret = ret.join
	end

end
