# $Id: bos_plugin.rb,v 1.4 2004/09/05 01:21:12 nisi Exp $

class BosPlugin
	attr_accessor :prop
	
	def initialize(bosm)
		@bosm = bosm
		@bos  = @bosm.bos
		@mydb = @bos.mysql
		@mydo = Rudby::new(@mydb)
		@exdir = "extensions"
		@plist = {
			'class'          => "./" + $bos_prop[:class_dir],
			'plugin'         => "./" + $bos_prop[:plugin_dir],
			'template'       => "./",
			'admin_template' => "./" + $bos_prop[:admin_dir] }
	end
	
	def get_plugin_list
		ret = []
		Dir.glob("./#{@exdir}/*"){|fl|
			sfl  = File.basename(fl,'rb')
			inf  = "./#{@exdir}/#{sfl}/#{sfl}.rb"
			getp = get_plugin_item(inf)
			ret << getp if getp
		}
		ret
	end
	
	def get_plugin_item(plugin_file)
		ret  = {}
		begin
			open(plugin_file){|f|
				ret[:name] = f
				ret[:description] = ""
				@plist.keys.each{|il| ret[il.intern] = [] }
				cr = ""
				f.each_line{|il|
					if /^\=\=\s*(.+)\s*$/ =~ il then
						cr = $1
					else
						case cr
						when 'description'
							ret[:description] << il
						when *@plist.keys
							if /^\*\s*(.+)\s*$/ =~ il then
								ret[cr.intern] << $1
							end
						end
					end
				}
			}
		rescue
			ret = nil
		end
		ret
	end
	
	def install_plugin(plugin_name)
		pbase = "./#{@exdir}/#{plugin_name}/"
		getp = get_plugin_item("#{pbase}#{plugin_name}.rb")
		return nil if !getp
		@plist.keys.each{|inr|
			if getp[inr.intern] then
				getp[inr.intern].each{|f|
					FileUtils.cp("#{pbase}#{inr}/#{f}",@plist[inr])
				}
			end
		}
	end

end
