# $Id: bos_pg.rb,v 1.2 2004/08/18 21:31:58 nisi Exp $

class BosPagegen
	attr_accessor :prop
	
	def initialize(product_id,bosm)
		@bosm = bosm
		@bos  = @bosm.bos
		@mydb = @bos.mysql
		@mydo = Rudby::new(@mydb)
		@prop = set_default
		@table_name = "bos_#{$bos_prop[:site_name]}_products"
		setup if !@mydb.list_tables.include?(@table_name)
		if !(product_id.is_a? Numeric) || !(product_id.integer?) then
			product_id = product_id.to_i == 0 ? get_id(product_id) : product_id.to_i
		end
		if product_id != 0 then
			@prop = @mydo.exp({
				:command => "s",
				:target  => @table_name,
				:cols    => set_default,
				:where   => "product_id = #{product_id}" })[0]
		end
	end
	
	def setup
		@mydb.query("CREATE TABLE #{@table_name}(" +
			"product_id INT NOT NULL AUTO_INCREMENT PRIMARY KEY," +
			"product_name VARCHAR(255)," +
			"content TEXT," +
			"template VARCHAR(64)," +
			"disp_start_date DATETIME," +
			"disp_end_date DATETIME," +
			"disp_flg CHAR(1) );")
	end
	
	def get_id(titlestr=nil)
		return 0 if !titlestr
		ret = 0
		retr = @mydo.exp({
			:command => "s",
			:target  => @table_name,
			:cols    => {:product_id => 0},
			:where   => w("product_name"){|a| a == titlestr } })
		ret = retr[0][:product_id] if retr && retr[0]
		ret
	end
	
	def get_list
		@mydo.exp({
			:command => "s",
			:target  => @table_name,
			:cols    => set_default,
			:order   => "product_id ASC" })
	end
	
	def set_default
		{
			:product_id => 0,
			:product_name => "- no name -",
			:content => "",
			:template => "",
			:disp_start_date => nil,
			:disp_end_date => nil,
			:disp_flg => "n" }
	end
	
	def commit
		if @prop[:product_id] == 0 then
			@prop.delete(:product_id)
			@prop[:product_id] = @mydo.exp({
				:command => "i",
				:target  => @table_name,
				:cols    => @prop })[:insid]
		else
			lct = @mydo.exp({
				:command => "u",
				:target  => @table_name,
				:cols    => @prop,
				:where   => "product_id = #{@prop[:product_id]}" })
		end

		@prop[:product_id]
	end

end
