# $Id: bos.rb,v 1.6 2004/09/07 21:59:11 nisi Exp $

require 'cgi'
require 'cgi/session'
require 'amrita/template'
require 'fileutils'

if $bos_prop[:db_server] then
	require 'mysql'
	require "bos/rudby"
end

require "bos/urlquery"
include Amrita


BOS_VERSION = '0.9.1'

class String
	def to_sani
		SanitizedString[self]
	end
end

class BOS
	attr_accessor :prop, :c, :mysql, :rdb, :urlq

	def initialize
		@prop = {
			:site_name => $bos_prop[:site_name],
			:user_name => $bos_prop[:user_name],
			:bos_ver => BOS_VERSION }
		@c = {}

		template = ENV['REDIRECT_TEMPLATE'] || ENV['REDIRECT_REDIRECT_TEMPLATE']
		template = "#{$bos_prop[:top_page]}.#{$bos_prop[:bos_template]}" if !template || template == ""

		if $bos_prop[:db_server] then
			@mysql = Mysql.new(
				$bos_prop[:db_server],
				$bos_prop[:db_user],
				$bos_prop[:db_pass],
				$bos_prop[:db_name] )
			@rdb  = Rudby.new(@mysql)
		end

		model = BOS::BosModel::new(self)

		@urlq = URLQueryString.new(model.cgi)
		
		based = ""
		('./' + template).split("\/").each {|tdir|
			based += tdir
			Dir::glob("#{based}/#{$bos_prop[:class_dir]}/*.rb").each do |f|
				next unless test(?f, f)
				open( f ) do |fd|
					eval( fd.read )
				end
			end

			Dir::glob("#{based}/#{$bos_prop[:class_dir]}/*.class").each do |f|
				next unless test(?f, f)
				open( f ) do |fd|
					tmpf = fd.read
					eval( tmpf )
					cclass = ""
					cname = ""
					
					cname = File.basename(f,".class")
					if tmpf =~ /class ([A-Z]\w*)/ then
						cclass = $1
					end

					if cclass && cname && cclass != "" && cname != "" then
						model.bos.c[cname.intern] = eval("BOS::#{cclass}").new()
					end
				end
			end

			Dir::glob("#{based}/#{$bos_prop[:plugin_dir]}/*.rb").each do |f|
				next unless test(?f, f)
				open( f ) do |fd|
					model.instance_eval( fd.read )
				end
			end
			
			based += "/"
		}
		
		model.methods.each{|m|
			eval("model.#{m}") if m =~ /^pre_.+/
		}
		
		outhtml = ""
		templatetext = ""
		open(template){|inf| templatetext = inf.read }
		template = tempgen(templatetext)
		tmpl = TemplateText.new(template)
		tmpl.expand(outhtml, model)
		model.cgi.out{ outhtml }

		model.methods.each{|m|
			eval("model.#{m}") if m =~ /^post_.+/
		}
	end
	
	def tempgen(templ)
		ret = ""
		templ.split($/).each{|ln|
			tmfl = true
			if /^\<\!\-\-\s*\#(.+)\s+(.+)\s*\-\-\>$/ =~ ln then
				incom = $1
				invals = $2
				if /(.+)\s*\=\s*\"(.+)\"/ =~ invals then
					inatt = $1
					inval = $2
				end
				case incom
				when "include"
					if inatt == "file" then
						open(inval){|inf|
							ret << inf.read
						}
						tmfl =false
					end
				end
			end
			
			ret << ln + "\n" if tmfl
		}
		ret
	end

	class BosModel
		include Amrita::ExpandByMember
		attr_accessor :bos, :cgi, :session, :params
		
		def initialize(bos)
			@bos = bos
			@cgi = CGI::new
			@params = @cgi.params
			@session = CGI::Session::new(@cgi)
		end
		
		def hidden
			nil
		end
		
		def dev # ǥХå
			$Dev
		end
		
	end

end

