/*
 * Copyright 2011 BitMeister Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.bitmeister.asn1.sample;

import java.math.BigInteger;

import jp.bitmeister.asn1.annotation.ASN1Alternative;
import jp.bitmeister.asn1.annotation.ASN1Element;
import jp.bitmeister.asn1.annotation.ASN1Enumeration;
import jp.bitmeister.asn1.annotation.ASN1ModuleTags;
import jp.bitmeister.asn1.type.ASN1Module;
import jp.bitmeister.asn1.type.ASN1TagClass;
import jp.bitmeister.asn1.type.ASN1TagDefault;
import jp.bitmeister.asn1.type.ASN1Type;
import jp.bitmeister.asn1.type.builtin.CHOICE;
import jp.bitmeister.asn1.type.builtin.ENUMERATED;
import jp.bitmeister.asn1.type.builtin.INTEGER;
import jp.bitmeister.asn1.type.builtin.NULL;
import jp.bitmeister.asn1.type.builtin.OCTET_STRING;
import jp.bitmeister.asn1.type.builtin.SEQUENCE;
import jp.bitmeister.asn1.type.builtin.SEQUENCE_OF;
import jp.bitmeister.asn1.type.builtin.SET_OF;
import jp.bitmeister.asn1.type.useful.PrintableString;
import jp.bitmeister.asn1.type.useful.UTCTime;

@ASN1ModuleTags(ASN1TagDefault.AUTOMATIC_TAGS)
public class FrightStatusTypes extends ASN1Module {
	
	public FrightStatusTypes() {
		register(FrightStatus.class);
	}

	public static class FrightNumber extends PrintableString {

		public FrightNumber() {
			super();
		}

		public FrightNumber(String value) {
			super(value);
		}
	}

	public static class Airport extends ENUMERATED {

		@ASN1Enumeration
		public static final int tokyo = 0;

		@ASN1Enumeration
		public static final int osaka = 1;

		@ASN1Enumeration
		public static final int nagoya = 2;

		@ASN1Enumeration
		public static final int fukuoka = 3;

		public Airport() {
		}

		public Airport(BigInteger value) {
			super(value);
		}

		public Airport(long value) {
			super(value);
		}

	}

	public static class Information extends SEQUENCE {

		@ASN1Element(value = 0, hasDefault = true)
		public Airport airport = new Airport(Airport.tokyo);

		@ASN1Element(1)
		public UTCTime scheduled;

		@ASN1Element(value = 2, optional = true)
		public UTCTime actual;

		public Information() {
		}

		public Information(Airport airport, UTCTime scheduled,
				UTCTime actual) {
			super();
			this.airport = airport;
			this.scheduled = scheduled;
			this.actual = actual;
		}

	}

	public static class Status extends CHOICE {

		@ASN1Alternative(0)
		public NULL onTime;

		@ASN1Alternative(1)
		public INTEGER delay;

		public Status() {
		}

		public Status(ASN1TagClass tagClass, int tagNumber, ASN1Type data) {
			super(tagClass, tagNumber, data);
		}

		public Status(ASN1Type data) {
			super(data);
		}

	}
	
	public static class SetOf extends SET_OF<OCTET_STRING> {
	
		public SetOf() {
			super(OCTET_STRING.class);
		}
		
	}
	
	public static class AllFrights extends SEQUENCE_OF<FrightStatus> {

		public AllFrights() {
			super(FrightStatus.class);
		}

	}
}
