/*
 * Copyright 2011 BitMeister Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.bitmeister.asn1.type;

import jp.bitmeister.asn1.type.builtin.INTEGER;
import jp.bitmeister.asn1.type.builtin.REAL;

/**
 * The interface for classes whose instance can be compared to other instance.
 * 
 * <p>
 * {@code INTEGER} and {@code REAL} implements this interface and their value
 * shall be ordered by the natural ordering. {@code compareTo} method is used
 * for compare the value to the other value.
 * </p>
 * 
 * @author WATANABE, Jun. <jwat at bitmeister.jp>
 * 
 * @see INTEGER
 * @see REAL
 */
public interface ValueComparable {

	/**
	 * Compares the value of this instance to the value of the other instance.
	 * 
	 * @param other
	 *            The instance whose value to be compared.
	 * @return A negative integer, zero, or a positive integer as this value is
	 *         less than, equal to, or greater than the other value.
	 */
	public int compareTo(ASN1Type other);

}
