/*
 * Copyright 2011 BitMeister Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.bitmeister.asn1.type;

import jp.bitmeister.asn1.type.builtin.BIT_STRING;
import jp.bitmeister.asn1.type.builtin.OCTET_STRING;

/**
 * The interface for classes which can be encoded to constructed form.
 * 
 * <p>
 * {@code BIT_STRING} and {@code OCTET_STRING} implements this interface and
 * they shall be encoded either primitive or constructed form. The
 * {@code concatenate} method is used for decoding values which were segmented
 * in encoding process.
 * </p>
 * 
 * @author WATANABE, Jun. <jwat at bitmeister.jp>
 * 
 * @see BIT_STRING
 * @see OCTET_STRING
 */
public interface Concatenatable<T extends ASN1Type> {

	/**
	 * Appends the value of the data to the value of this instance.
	 * 
	 * @param data
	 *            The data that has the value to be appended. The ASN.1 type of
	 *            the {@code data} shall be same as this instance.
	 */
	public void concatenate(T data);

}
