/*
 * Copyright 2011 BitMeister Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.bitmeister.asn1.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import jp.bitmeister.asn1.type.builtin.BIT_STRING;

/**
 * Indicates that a field represents a named bit of a 'BIT STRING' type.
 * 
 * <p>
 * If a field annotated as {@code @ASN1NamedBit} is present in a definition of
 * sub-class of {@code BIT_STRING}, the value of the field is the index number
 * of a distinguished bit in a bitstring value. An {@code @ASN1NamedBit} field
 * must be a {@code public} {@code static} {@code final} field and the type
 * shall be {@code int}. Each value of {@code @ASN1NamedBit} fields appearing in
 * definition of a type must be distinct from the others.
 * </p>
 * <p>
 * For example, following ASN.1 definition :
 * 
 * <pre>
 * Sample ::= BIT STRING { read(0), write(1) }
 * </pre>
 * 
 * can be translated as :
 * 
 * <code><pre>
 * public class Sample extends BIT_STRING {
 * 
 * 	&#064;ASN1NamedBit
 * 	public static final int read = 0;
 * 
 * 	&#064;ASN1NamedBit
 * 	public static final int write = 1;
 * 
 * }
 * </pre></code>
 * 
 * </p>
 * 
 * @author WATANABE, Jun. <jwat at bitmeister.jp>
 * 
 * @see BIT_STRING
 */
@Target(ElementType.FIELD)
@Retention(RetentionPolicy.RUNTIME)
public @interface ASN1NamedBit {
}
