/*
 * Copyright 2011 BitMeister Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.bitmeister.asn1.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Indicates that a type does not have own identifier.
 * 
 * <p>
 * If an {@code @ASN1Anonymous} annotation is present on a type, base type's
 * identifier is used instead of identifier of the type. This annotation is used
 * for defining types which defined as an element of a constructive type or a
 * component of a collection type without own type name.
 * </p>
 * <p>
 * For example, following ASN.1 definition :
 * 
 * <pre>
 * Sample ::= SEQUENCE OF SEQUENCE {
 * 	number	INTEGER,
 * 	bool	BOOLEAN }
 * </pre>
 * 
 * can be translated as :
 * 
 * <code><pre>
 * public class Sample extends SEQUENCE_OF&lt;Sample.Sequence&gt; {
 * 
 * 	public Sample() {
 * 		super(Sample.Sequence.class);
 * 	}
 * 
 * 	&#064;ASN1Anonymous
 * 	public static class Sequence extends SEQUENCE {
 * 
 * 		&#064;ASN1Element(0)
 * 		public INTEGER number;
 * 
 * 		&#064;ASN1Element(1)
 * 		public BOOLEAN bool;
 * 
 * 	}
 * 
 * }
 * </pre></code>
 * 
 * </p>
 * 
 * @author WATANABE, Jun. <jwat at bitmeister.jp>
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
public @interface ASN1Anonymous {
}
