/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.utilities;

import java.util.regex.Pattern;
import org.w3c.dom.Element;
import uk.ac.ed.ph.snuggletex.utilities.MathMLUtilities;

public final class SnuggleUtilities {
    private static final Pattern charsToVerbPattern = Pattern.compile("([\\\\^~<>|]+)");
    private static final Pattern charsToBackslashPattern = Pattern.compile("([%#_$&\\{\\}])");

    public static String quoteTextForInput(String text2) {
        String result2 = charsToVerbPattern.matcher(text2).replaceAll("\\\\verb-$1-");
        result2 = charsToBackslashPattern.matcher(result2).replaceAll("\\\\$1");
        return result2;
    }

    public static String extractSnuggleTeXAnnotation(Element mathmlElement) {
        return MathMLUtilities.extractAnnotationString(mathmlElement, "SnuggleTeX");
    }
}

