/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.utilities;

import java.util.Map;
import java.util.Properties;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import uk.ac.ed.ph.snuggletex.DOMOutputOptions;
import uk.ac.ed.ph.snuggletex.SnuggleRuntimeException;
import uk.ac.ed.ph.snuggletex.internal.util.XMLUtilities;
import uk.ac.ed.ph.snuggletex.utilities.CSSUtilities;
import uk.ac.ed.ph.snuggletex.utilities.StylesheetCache;
import uk.ac.ed.ph.snuggletex.utilities.StylesheetManager;

public final class MathMLDownConverter {
    private final Properties cssProperties;
    private final StylesheetManager stylesheetManager;

    public MathMLDownConverter() {
        this((StylesheetManager)null, (Properties)null);
    }

    public MathMLDownConverter(Properties cssProperties) {
        this(null, cssProperties);
    }

    public MathMLDownConverter(StylesheetCache stylesheetCache) {
        this(new StylesheetManager(stylesheetCache), (Properties)null);
    }

    public MathMLDownConverter(StylesheetManager stylesheetManager, DOMOutputOptions options) {
        this(stylesheetManager, options != null && options.isInliningCSS() ? CSSUtilities.readInlineCSSProperties(options) : null);
    }

    public MathMLDownConverter(StylesheetManager stylesheetManager, Properties cssProperties) {
        this.stylesheetManager = stylesheetManager != null ? stylesheetManager : new StylesheetManager();
        this.cssProperties = cssProperties;
    }

    public Document downConvertDOM(Document document2) {
        Document cssPropertiesDocument = XMLUtilities.createNSAwareDocumentBuilder().newDocument();
        if (this.cssProperties != null) {
            this.buildCSSPropertiesDocument(cssPropertiesDocument, this.cssProperties);
        }
        CSSPropertiesURIResolver uriResolver = new CSSPropertiesURIResolver(cssPropertiesDocument);
        Templates templates = this.stylesheetManager.getStylesheet("classpath:/uk/ac/ed/ph/snuggletex/mathml-to-xhtml.xsl");
        Document result2 = XMLUtilities.createNSAwareDocumentBuilder().newDocument();
        try {
            Transformer transformer = templates.newTransformer();
            transformer.setURIResolver(uriResolver);
            transformer.transform(new DOMSource(document2), new DOMResult(result2));
        }
        catch (Exception e) {
            throw new SnuggleRuntimeException("Unexpected Exception down-converting DOM", e);
        }
        return result2;
    }

    public void buildCSSPropertiesDocument(Document result2, Properties cssProperties) {
        Element root2 = result2.createElementNS("http://www.ph.ed.ac.uk/snuggletex", "properties");
        result2.appendChild(root2);
        for (Map.Entry<Object, Object> entry : cssProperties.entrySet()) {
            Element element = result2.createElementNS("http://www.ph.ed.ac.uk/snuggletex", "property");
            element.setAttribute("name", (String)entry.getKey());
            element.setAttribute("value", (String)entry.getValue());
            root2.appendChild(element);
        }
    }

    protected static final class CSSPropertiesURIResolver
    implements URIResolver {
        private final Source cssPropertiesSource;

        public CSSPropertiesURIResolver(Document cssPropertiesDocument) {
            this.cssPropertiesSource = new DOMSource(cssPropertiesDocument, "urn:snuggletex-css-properties");
        }

        public Source resolve(String href, String base) {
            return href.equals("urn:snuggletex-css-properties") ? this.cssPropertiesSource : null;
        }
    }
}

