/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.dombuilding;

import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import uk.ac.ed.ph.snuggletex.definitions.CoreErrorCode;
import uk.ac.ed.ph.snuggletex.definitions.CorePackageDefinitions;
import uk.ac.ed.ph.snuggletex.dombuilding.CommandHandler;
import uk.ac.ed.ph.snuggletex.dombuilding.EnvironmentHandler;
import uk.ac.ed.ph.snuggletex.internal.DOMBuilder;
import uk.ac.ed.ph.snuggletex.internal.SnuggleParseException;
import uk.ac.ed.ph.snuggletex.tokens.ArgumentContainerToken;
import uk.ac.ed.ph.snuggletex.tokens.CommandToken;
import uk.ac.ed.ph.snuggletex.tokens.EnvironmentToken;
import uk.ac.ed.ph.snuggletex.tokens.FlowToken;
import uk.ac.ed.ph.snuggletex.tokens.SimpleToken;
import uk.ac.ed.ph.snuggletex.tokens.TokenType;

public abstract class AbstractCustomXMLElementHandler
implements EnvironmentHandler,
CommandHandler {
    protected abstract boolean isBlock();

    public void handleEnvironment(DOMBuilder builder, Element parentElement, EnvironmentToken token2) throws SnuggleParseException {
        this.buildCustomElement(builder, parentElement, token2.getOptionalArgument(), token2.getArguments()[0], token2.getArguments()[1], token2.getContent());
    }

    public void handleCommand(DOMBuilder builder, Element parentElement, CommandToken token2) throws SnuggleParseException {
        this.buildCustomElement(builder, parentElement, token2.getOptionalArgument(), token2.getArguments()[0], token2.getArguments()[1], token2.getArguments()[2]);
    }

    protected void buildCustomElement(DOMBuilder builder, Element parentElement, ArgumentContainerToken attrsToken, ArgumentContainerToken namespaceToken, ArgumentContainerToken qNameToken, ArgumentContainerToken contentToken) throws SnuggleParseException {
        Element resultElement;
        String namespaceUri = builder.extractStringValue(namespaceToken);
        builder.validateURI(parentElement, namespaceToken, namespaceUri);
        String qName = builder.extractStringValue(qNameToken);
        try {
            resultElement = builder.getDocument().createElementNS(namespaceUri, qName);
        }
        catch (DOMException e) {
            if (e.code == 5 || e.code == 14) {
                builder.appendOrThrowError(parentElement, qNameToken, CoreErrorCode.TDEX01, qName);
                return;
            }
            throw e;
        }
        parentElement.appendChild(resultElement);
        if (attrsToken != null) {
            this.extractAttributes(builder, parentElement, resultElement, attrsToken);
        }
        builder.handleTokens(resultElement, contentToken, this.isBlock());
    }

    private void extractAttributes(DOMBuilder builder, Element parentElement, Element resultElement, ArgumentContainerToken attrsToken) throws SnuggleParseException {
        for (FlowToken rawAttrToken : attrsToken) {
            if (rawAttrToken.isCommand(CorePackageDefinitions.CMD_XML_ATTR)) {
                CommandToken resolvedAttrToken = (CommandToken)rawAttrToken;
                String namespace = builder.extractStringValue(resolvedAttrToken.getArguments()[0]);
                String qName = builder.extractStringValue(resolvedAttrToken.getArguments()[1]);
                String value2 = builder.extractStringValue(resolvedAttrToken.getArguments()[2]);
                resultElement.setAttributeNS(namespace, qName, value2);
                continue;
            }
            if (rawAttrToken.getType() == TokenType.ERROR) {
                builder.handleToken(parentElement, rawAttrToken);
                continue;
            }
            if (rawAttrToken.getType() == TokenType.TEXT_MODE_TEXT && ((SimpleToken)rawAttrToken).getSlice().isWhitespace()) continue;
            builder.appendOrThrowError(parentElement, rawAttrToken, CoreErrorCode.TDEX00, new Object[0]);
        }
    }
}

