/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.internal.util;

import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StringUtilities {
    public static final String[] EMPTY_STRING_ARRAY = new String[0];

    public static String join(Iterable<? extends Object> objects, CharSequence separator) {
        StringBuilder result2 = new StringBuilder();
        Iterator<? extends Object> iter2 = objects.iterator();
        while (iter2.hasNext()) {
            result2.append(iter2.next().toString());
            if (!iter2.hasNext()) continue;
            result2.append(separator);
        }
        return result2.toString();
    }

    public static String join(Object[] objects, CharSequence separator) {
        return StringUtilities.join(objects, separator, 0, objects.length);
    }

    public static void join(StringBuilder resultBuilder, Object[] objects, CharSequence separator) {
        StringUtilities.join(resultBuilder, objects, separator, 0, objects.length);
    }

    public static String join(Object[] objects, CharSequence separator, int startIndex, int endIndex) {
        StringBuilder result2 = new StringBuilder();
        StringUtilities.join(result2, objects, separator, startIndex, endIndex);
        return result2.toString();
    }

    public static void join(StringBuilder resultBuilder, Object[] objects, CharSequence separator, int startIndex, int endIndex) {
        boolean hasDoneFirst = false;
        int i = startIndex;
        while (i < endIndex) {
            if (hasDoneFirst) {
                resultBuilder.append(separator);
            }
            resultBuilder.append(objects[i].toString());
            hasDoneFirst = true;
            ++i;
        }
    }

    public static boolean isNullOrEmpty(String string2) {
        return string2 == null || string2.length() == 0;
    }

    public static String nullIfEmpty(String string2) {
        return StringUtilities.isNullOrEmpty(string2) ? null : string2;
    }

    public static String emptyIfNull(String string2) {
        return string2 != null ? string2 : "";
    }

    public static String toYesNo(boolean state) {
        return state ? "yes" : "no";
    }

    public static String toTrueFalse(boolean state) {
        return state ? "true" : "false";
    }

    public static boolean fromYesNo(String value2) {
        return StringUtilities.fromBinaryValues(value2, "yes", "no");
    }

    public static boolean fromTrueFalse(String value2) {
        return StringUtilities.fromBinaryValues(value2, "true", "false");
    }

    public static boolean fromBinaryValues(String value2, String trueValue, String falseValue) {
        if (value2 != null) {
            if (value2.equals(trueValue)) {
                return true;
            }
            if (value2.equals(falseValue)) {
                return false;
            }
        }
        throw new IllegalArgumentException("Argument must be " + trueValue + " or " + falseValue);
    }
}

