/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.internal;

import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import uk.ac.ed.ph.snuggletex.DOMOutputOptions;
import uk.ac.ed.ph.snuggletex.DOMPostProcessor;
import uk.ac.ed.ph.snuggletex.internal.DOMBuilder;
import uk.ac.ed.ph.snuggletex.internal.SessionContext;
import uk.ac.ed.ph.snuggletex.internal.SnuggleParseException;
import uk.ac.ed.ph.snuggletex.internal.util.XMLUtilities;
import uk.ac.ed.ph.snuggletex.tokens.FlowToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DOMBuildingController {
    private final SessionContext sessionContext;
    private final DOMOutputOptions options;

    public DOMBuildingController(SessionContext sessionContext, DOMOutputOptions options) {
        this.sessionContext = sessionContext;
        this.options = options;
    }

    public void buildDOMSubtree(Element targetRoot, List<FlowToken> fixedTokens) throws SnuggleParseException {
        DOMPostProcessor[] domPostProcessors = this.options.getDOMPostProcessors();
        if (domPostProcessors != null && domPostProcessors.length > 0) {
            Document workDocument = XMLUtilities.createNSAwareDocumentBuilder().newDocument();
            Element workRoot = workDocument.createElementNS("http://www.ph.ed.ac.uk/snuggletex", "root");
            workDocument.appendChild(workRoot);
            DOMBuilder domBuilder = new DOMBuilder(this.sessionContext, workRoot, this.options);
            domBuilder.buildDOMSubtree(fixedTokens);
            int processorIndex = 0;
            while (processorIndex < domPostProcessors.length) {
                Element adoptRoot;
                DOMPostProcessor domPostProcessor = domPostProcessors[processorIndex];
                Document outputDocument = domPostProcessor.postProcessDOM(workDocument, this.options, this.sessionContext.getStylesheetManager());
                if (processorIndex == domPostProcessors.length - 1) {
                    adoptRoot = targetRoot;
                } else {
                    adoptRoot = workRoot;
                    NodeList toDelete = workRoot.getChildNodes();
                    int i = toDelete.getLength() - 1;
                    while (i >= 0) {
                        workRoot.removeChild(toDelete.item(i));
                        --i;
                    }
                }
                Element resultRoot = outputDocument.getDocumentElement();
                NodeList childNodes = resultRoot.getChildNodes();
                int i = 0;
                int size2 = childNodes.getLength();
                while (i < size2) {
                    Node childNode = childNodes.item(0);
                    adoptRoot.appendChild(adoptRoot.getOwnerDocument().adoptNode(childNode));
                    ++i;
                }
                ++processorIndex;
            }
        } else {
            DOMBuilder domBuilder = new DOMBuilder(this.sessionContext, targetRoot, this.options);
            domBuilder.buildDOMSubtree(fixedTokens);
        }
    }
}

