/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.cat.stat;

import org.osgi.framework.BundleContext;

import benten.cat.glossary.core.BentenGlossaryEngine;
import benten.cat.glossary.ui.CatGlossaryUiPlugin;
import benten.ui.AbstractBentenUiPlugin;

/**
 * CAT 統計プラグイン。
 * 
 * <UL>
 * <LI>このプラグインを Eclipse 上で有効化するためのプラグイン・クラスです。
 * </UL>
 * 
 * @author KASHIHARA Shinji
 */
public class CatStatPlugin extends AbstractBentenUiPlugin {

	/** 共用インスタンス */
	private static CatStatPlugin plugin;

	@Override
	public void start(final BundleContext context) throws Exception {
		super.start(context);
		plugin = this;
	}

	@Override
	public void stop(final BundleContext context) throws Exception {
		plugin = null;
		super.stop(context);
	}

	/**
	 * このプラグインの共用インスタンスを取得。
	 * @return このプラグインの共用インスタンス
	 */
	public static CatStatPlugin getDefault() {
		return plugin;
	}

	/**
	 * 用語集エンジンを取得します。
	 * @return 用語集エンジン
	 */
	public static BentenGlossaryEngine getGlossaryEngine() {
		return CatGlossaryUiPlugin.getDefault().getGlossaryEngine();
	}
}
