/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.twa.xliff.wizards;

import benten.twa.ui.jobs.WorkflowJob;
import benten.twa.ui.wizards.AbstractWorkflowWizard;
import benten.twa.xliff.handler.MergeXliffHandler;
import benten.twa.xliff.messages.BentenMergeXliffMessages;

/**
 * XLIFF フラグメントのマージ
 *
 * <pre>
 * XLIFF フラグメントを、もとになった XLIFF にマージします。
 *   1.  翻訳単位の id をもとに、XLIFF をマージします。
 * </pre>
 *
 * ★基本設計「翻訳ワークフロー支援機能: 翻訳中間形式断片抽出・マージ機能: XLIFFフラグメント・マージ機能」に対応します。
 *
 * @author YAMAMOTO Koji
 */
public class MergeXliffWizard extends AbstractWorkflowWizard {
	/**
	 * XLIFF マージ機能のためのメッセージ。
	 */
	protected static final BentenMergeXliffMessages fMsg = new BentenMergeXliffMessages();

	@Override
	public void addPages() {
		setWindowTitle(fMsg.getWindowTitle());
		addPage(new MergeXliffWizardPage());
		addPage(new MergeXliffWizardPage2(getSelection()));
	}

	@Override
	protected void scheduleJob() {
		final WorkflowJob job = new WorkflowJob(fMsg.getJobName());
		job.addHandler(new MergeXliffHandler(), getStatus());
		job.setCompleteMessage(getWindowTitle(), fMsg.getWizardPage3ResultMessage());
		job.schedule();
	}
}
