/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.ui.views;

import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

/**
 * カラム幅自動設定テーブル・ビューアー。
 *
 * <UL>
 * <LI>親コンテナーやカラム幅の変更により、自動的にカラム幅が調整されるテーブル・ビューアー・クラスです。
 * <LI>本クラスの {@link #addColumn} メソッド以外でカラム追加を行った場合の動作は保証されません。
 * </UL>
 *
 * @author KASHIHARA Shinji
 */
public class AutoColumnWidthTableViewer extends TableViewer {

	/** テーブル */
	private final Table table;

	/** テーブル・カラム・レイアウト */
	private final TableColumnLayout tableColumnLayout;

	/**
	 * コンストラクター。
	 * @param parent 親コンポジット
	 */
	public AutoColumnWidthTableViewer(final Composite parent) {
		super(new Table(new Composite(parent, SWT.NONE), SWT.BORDER | SWT.FULL_SELECTION));
		table = getTable();
		final Composite tableParent = table.getParent();
		tableParent.setLayoutData(new GridData(GridData.FILL_BOTH));

		table.setHeaderVisible(true);
		table.setLinesVisible(true);

		tableColumnLayout = new TableColumnLayout();
		tableParent.setLayout(tableColumnLayout);

		setContentProvider(new ArrayContentProvider());
	}

	/**
	 * カラムの追加。
	 * @param label ラベル
	 * @param weight 重み
	 * @return テーブル・カラム
	 */
	public TableColumn addColumn(final String label, final int weight) {
		return addColumn(label, weight, SWT.NONE);
	}

	/**
	 * カラムの追加。
	 * @param label ラベル
	 * @param weight 重み
	 * @param style スタイル
	 * @return テーブル・カラム
	 */
	public TableColumn addColumn(final String label, final int weight, final int style) {
		final TableColumn tableColumn = new TableColumn(table, style);
		tableColumn.setText(label);
		tableColumnLayout.setColumnData(tableColumn, new ColumnWeightData(weight));
		return tableColumn;
	}
}
